/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.ItemRequest;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import java.util.logging.Logger;

public final class RequestPrivateStoreSell
extends L2GameClientPacket {
    private static final String _C__9F_REQUESTPRIVATESTORESELL = "[C] 9F RequestPrivateStoreSell";
    private static Logger _log = Logger.getLogger(RequestPrivateStoreSell.class.getName());
    private static final int BATCH_LENGTH = 28;
    private int _storePlayerId;
    private ItemRequest[] _items = null;

    @Override
    protected void readImpl() {
        this._storePlayerId = this.readD();
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 28 != this._buf.remaining()) {
            return;
        }
        this._items = new ItemRequest[count];
        for (int i = 0; i < count; ++i) {
            int objectId = this.readD();
            int itemId = this.readD();
            this.readH();
            this.readH();
            long cnt = this.readQ();
            long price = this.readQ();
            if (objectId < 1 || itemId < 1 || cnt < 1L || price < 0L) {
                this._items = null;
                return;
            }
            this._items[i] = new ItemRequest(objectId, itemId, cnt, price);
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (this._items == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("privatestoresell")) {
            player.sendMessage("You selling items too fast");
            return;
        }
        L2PcInstance object = L2World.getInstance().getPlayer(this._storePlayerId);
        if (object == null) {
            return;
        }
        L2PcInstance storePlayer = object;
        if (!player.isInsideRadius(storePlayer, 150, true, false)) {
            return;
        }
        if (player.getInstanceId() != storePlayer.getInstanceId() && player.getInstanceId() != -1) {
            return;
        }
        if (storePlayer.getPrivateStoreType() != 3) {
            return;
        }
        if (player.isCursedWeaponEquipped()) {
            return;
        }
        TradeList storeList = storePlayer.getBuyList();
        if (storeList == null) {
            return;
        }
        if (!player.getAccessLevel().allowTransaction()) {
            player.sendMessage("Transactions are disable for your Access Level");
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!storeList.privateStoreSell(player, this._items)) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            _log.warning("PrivateStore sell has failed due to invalid list or request. Player: " + player.getName() + ", Private store of: " + storePlayer.getName());
            return;
        }
        if (storeList.getItemCount() == 0) {
            storePlayer.setPrivateStoreType(0);
            storePlayer.broadcastUserInfo();
        }
    }

    @Override
    public String getType() {
        return _C__9F_REQUESTPRIVATESTORESELL;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

