/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.olympiad.AbstractOlympiadGame;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameClassed;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameNonClassed;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTeams;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;

public class ExOlympiadMatchList
extends L2GameServerPacket {
    private static final String _S__FE_D4_OLYMPIADMATCHLIST = "[S] FE:D4 ExOlympiadMatchList";
    private final List<OlympiadGameTask> _games;

    public ExOlympiadMatchList(List<OlympiadGameTask> games) {
        this._games = games;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(254);
        this.writeH(212);
        this.writeD(0);
        this.writeD(this._games.size());
        this.writeD(0);
        for (OlympiadGameTask curGame : this._games) {
            AbstractOlympiadGame game = curGame.getGame();
            if (game == null) continue;
            this.writeD(game.getStadiumId());
            if (game instanceof OlympiadGameNonClassed) {
                this.writeD(1);
            } else if (game instanceof OlympiadGameClassed) {
                this.writeD(2);
            } else if (game instanceof OlympiadGameTeams) {
                this.writeD(-1);
            } else {
                this.writeD(0);
            }
            this.writeD(curGame.isRunning() ? 2 : 1);
            this.writeS(game.getPlayerNames()[0]);
            this.writeS(game.getPlayerNames()[1]);
        }
    }

    @Override
    public String getType() {
        return _S__FE_D4_OLYMPIADMATCHLIST;
    }
}

