/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.gameserverpackets.AuthRequest;
import com.l2jserver.gameserver.network.gameserverpackets.BlowFishKey;
import com.l2jserver.gameserver.network.gameserverpackets.ChangeAccessLevel;
import com.l2jserver.gameserver.network.gameserverpackets.PlayerAuthRequest;
import com.l2jserver.gameserver.network.gameserverpackets.PlayerInGame;
import com.l2jserver.gameserver.network.gameserverpackets.PlayerLogout;
import com.l2jserver.gameserver.network.gameserverpackets.PlayerTracert;
import com.l2jserver.gameserver.network.gameserverpackets.ReplyCharacters;
import com.l2jserver.gameserver.network.gameserverpackets.SendMail;
import com.l2jserver.gameserver.network.gameserverpackets.ServerStatus;
import com.l2jserver.gameserver.network.gameserverpackets.TempBan;
import com.l2jserver.gameserver.network.loginserverpackets.AuthResponse;
import com.l2jserver.gameserver.network.loginserverpackets.InitLS;
import com.l2jserver.gameserver.network.loginserverpackets.KickPlayer;
import com.l2jserver.gameserver.network.loginserverpackets.LoginServerFail;
import com.l2jserver.gameserver.network.loginserverpackets.PlayerAuthResponse;
import com.l2jserver.gameserver.network.loginserverpackets.RequestCharacters;
import com.l2jserver.gameserver.network.serverpackets.CharSelectionInfo;
import com.l2jserver.gameserver.network.serverpackets.LoginFail;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Util;
import com.l2jserver.util.crypt.NewCrypt;
import com.l2jserver.util.network.BaseSendablePacket;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.mmocore.network.SendablePacket;

public class LoginServerThread
extends Thread {
    protected static final Logger _log = Logger.getLogger(LoginServerThread.class.getName());
    protected static final Logger _logAccounting = Logger.getLogger("accounting");
    private static final int REVISION = 262;
    private RSAPublicKey _publicKey;
    private final String _hostname;
    private final int _port = Config.GAME_SERVER_LOGIN_PORT;
    private final int _gamePort = Config.PORT_GAME;
    private Socket _loginSocket;
    private InputStream _in;
    private OutputStream _out;
    private NewCrypt _blowfish;
    private byte[] _blowfishKey;
    private byte[] _hexID;
    private final boolean _acceptAlternate;
    private int _requestID;
    private int _serverID;
    private final boolean _reserveHost;
    private int _maxPlayer;
    private final List<WaitingClient> _waitingClients;
    private final Map<String, L2GameClient> _accountsInGameServer;
    private int _status;
    private String _serverName;
    private final String[] _subnets;
    private final String[] _hosts;

    private LoginServerThread() {
        super("LoginServerThread");
        this._hostname = Config.GAME_SERVER_LOGIN_HOST;
        this._hexID = Config.HEX_ID;
        if (this._hexID == null) {
            this._requestID = Config.REQUEST_ID;
            this._hexID = Util.generateHex(16);
        } else {
            this._requestID = Config.SERVER_ID;
        }
        this._acceptAlternate = Config.ACCEPT_ALTERNATE_ID;
        this._reserveHost = Config.RESERVE_HOST_ON_LOGIN;
        this._subnets = Config.GAME_SERVER_SUBNETS;
        this._hosts = Config.GAME_SERVER_HOSTS;
        this._waitingClients = new FastList();
        this._accountsInGameServer = new FastMap().shared();
        this._maxPlayer = Config.MAXIMUM_ONLINE_USERS;
    }

    public static LoginServerThread getInstance() {
        return SingletonHolder._instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            int lengthHi = 0;
            int lengthLo = 0;
            int length = 0;
            boolean checksumOk = false;
            long interval = 5000L;
            try {
                _log.info("Connecting to login on " + this._hostname + ":" + this._port);
                this._loginSocket = new Socket(this._hostname, this._port);
                this._in = this._loginSocket.getInputStream();
                this._out = new BufferedOutputStream(this._loginSocket.getOutputStream());
                this._blowfishKey = Util.generateHex(40);
                this._blowfish = new NewCrypt("_;v.]05-31!|+-%xT!^[$\u0000");
                while (!this.isInterrupted()) {
                    lengthLo = this._in.read();
                    lengthHi = this._in.read();
                    length = lengthHi * 256 + lengthLo;
                    if (lengthHi < 0) {
                        _log.finer("LoginServerThread: Login terminated the connection.");
                        break;
                    }
                    byte[] incoming = new byte[length - 2];
                    int receivedBytes = 0;
                    int newBytes = 0;
                    int left = length - 2;
                    while (newBytes != -1 && receivedBytes < length - 2) {
                        newBytes = this._in.read(incoming, receivedBytes, left);
                        receivedBytes += newBytes;
                        left -= newBytes;
                    }
                    if (receivedBytes != length - 2) {
                        _log.warning("Incomplete Packet is sent to the server, closing connection.(LS)");
                        break;
                    }
                    this._blowfish.decryptMe(incoming);
                    byte[] decrypt = incoming;
                    checksumOk = NewCrypt.verifyChecksum(decrypt);
                    if (!checksumOk) {
                        _log.warning("Incorrect packet checksum, ignoring packet (LS)");
                        break;
                    }
                    if (Config.DEBUG) {
                        _log.warning("[C]\n" + Util.printData(decrypt));
                    }
                    int packetType = decrypt[0] & 0xFF;
                    switch (packetType) {
                        case 0: {
                            int loginServerRevision;
                            InitLS init = new InitLS(decrypt);
                            if (Config.DEBUG) {
                                _log.info("Init received");
                            }
                            if ((loginServerRevision = init.getRevision()) != 262) {
                                _log.warning("<!> Revision mismatch between LS(" + Integer.toHexString(loginServerRevision) + ") and GS(" + Integer.toHexString(262) + ") <!>");
                                break;
                            }
                            try {
                                KeyFactory kfac = KeyFactory.getInstance("RSA");
                                BigInteger modulus = new BigInteger(init.getRSAKey());
                                RSAPublicKeySpec kspec1 = new RSAPublicKeySpec(modulus, RSAKeyGenParameterSpec.F4);
                                this._publicKey = (RSAPublicKey)kfac.generatePublic(kspec1);
                                if (Config.DEBUG) {
                                    _log.info("RSA key set up");
                                }
                            }
                            catch (GeneralSecurityException e) {
                                _log.warning("Troubles while init the public key send by login");
                                break;
                            }
                            BlowFishKey bfk = new BlowFishKey(this._blowfishKey, this._publicKey);
                            this.sendPacket(bfk);
                            if (Config.DEBUG) {
                                _log.info("Sent new blowfish key");
                            }
                            this._blowfish = new NewCrypt(this._blowfishKey);
                            if (Config.DEBUG) {
                                _log.info("Changed blowfish key");
                            }
                            AuthRequest ar = new AuthRequest(this._requestID, this._acceptAlternate, this._hexID, this._gamePort, this._reserveHost, this._maxPlayer, this._subnets, this._hosts);
                            this.sendPacket(ar);
                            if (!Config.DEBUG) break;
                            _log.info("Sent AuthRequest to login");
                            break;
                        }
                        case 1: {
                            LoginServerFail lsf = new LoginServerFail(decrypt);
                            _log.info("Damn! Registeration Failed: " + lsf.getReasonString());
                            break;
                        }
                        case 2: {
                            AuthResponse aresp = new AuthResponse(decrypt);
                            this._serverID = aresp.getServerId();
                            this._serverName = aresp.getServerName();
                            Config.saveHexid(this._serverID, this.hexToString(this._hexID));
                            _log.info("Registered on login as Server " + this._serverID + " : " + this._serverName);
                            if (System.getProperty("os.name").startsWith("Windows")) {
                                Process processA = null;
                                try {
                                    processA = Runtime.getRuntime().exec(new String[]{"msg.exe", "*", "/TIME:1", "L2J\u30b2\u30fc\u30e0\u30b5\u30fc\u30d0\u304c\u8d77\u52d5\u3057\u307e\u3057\u305f."});
                                    processA.waitFor();
                                }
                                catch (Exception e) {
                                }
                                finally {
                                    if (processA != null) {
                                        processA.destroy();
                                    }
                                }
                            }
                            ServerStatus st = new ServerStatus();
                            if (Config.SERVER_LIST_BRACKET) {
                                st.addAttribute(3, 1);
                            } else {
                                st.addAttribute(3, 0);
                            }
                            st.addAttribute(2, Config.SERVER_LIST_TYPE);
                            if (Config.SERVER_GMONLY) {
                                st.addAttribute(1, 5);
                            } else {
                                st.addAttribute(1, 0);
                            }
                            if (Config.SERVER_LIST_AGE == 15) {
                                st.addAttribute(5, 15);
                            } else if (Config.SERVER_LIST_AGE == 18) {
                                st.addAttribute(5, 18);
                            } else {
                                st.addAttribute(5, 0);
                            }
                            this.sendPacket(st);
                            if (L2World.getInstance().getAllPlayersCount() <= 0) break;
                            FastList playerList = new FastList();
                            for (L2PcInstance player : L2World.getInstance().getAllPlayersArray()) {
                                playerList.add((Object)player.getAccountName());
                            }
                            PlayerInGame pig = new PlayerInGame((FastList<String>)playerList);
                            this.sendPacket(pig);
                            break;
                        }
                        case 3: {
                            PlayerAuthResponse par = new PlayerAuthResponse(decrypt);
                            String account = par.getAccount();
                            WaitingClient wcToRemove = null;
                            List<WaitingClient> i$ = this._waitingClients;
                            synchronized (i$) {
                                for (WaitingClient wc : this._waitingClients) {
                                    if (!wc.account.equals(account)) continue;
                                    wcToRemove = wc;
                                }
                            }
                            if (wcToRemove == null) break;
                            if (par.isAuthed()) {
                                if (Config.DEBUG) {
                                    _log.info("Login accepted player " + wcToRemove.account + " waited(" + (GameTimeController.getGameTicks() - wcToRemove.timestamp) + "ms)");
                                }
                                PlayerInGame pig = new PlayerInGame(par.getAccount());
                                this.sendPacket(pig);
                                wcToRemove.gameClient.setState(L2GameClient.GameClientState.AUTHED);
                                wcToRemove.gameClient.setSessionId(wcToRemove.session);
                                CharSelectionInfo cl = new CharSelectionInfo(wcToRemove.account, wcToRemove.gameClient.getSessionId().playOkID1);
                                wcToRemove.gameClient.getConnection().sendPacket((SendablePacket)cl);
                                wcToRemove.gameClient.setCharSelection(cl.getCharInfo());
                            } else {
                                _log.warning("Session key is not correct. Closing connection for account " + wcToRemove.account + ".");
                                wcToRemove.gameClient.close(new LoginFail(1));
                                this._accountsInGameServer.remove(wcToRemove.account);
                            }
                            this._waitingClients.remove(wcToRemove);
                            break;
                        }
                        case 4: {
                            KickPlayer kp = new KickPlayer(decrypt);
                            this.doKickPlayer(kp.getAccount());
                            break;
                        }
                        case 5: {
                            RequestCharacters rc = new RequestCharacters(decrypt);
                            this.getCharsOnServer(rc.getAccount());
                        }
                    }
                }
            }
            catch (UnknownHostException e) {
                if (Config.DEBUG) {
                    _log.log(Level.WARNING, "", e);
                }
            }
            catch (ConnectException e) {
                _log.log(Level.WARNING, "Cannot connect LoginServer.");
                interval = 60000L;
            }
            catch (SocketException e) {
                _log.warning("LoginServer not avaible, trying to reconnect...");
                interval = 60000L;
            }
            catch (IOException e) {
                _log.log(Level.WARNING, "Disconnected from Login, Trying to reconnect: " + e.getMessage(), e);
            }
            finally {
                try {
                    this._loginSocket.close();
                    if (this.isInterrupted()) {
                        return;
                    }
                }
                catch (Exception e) {}
            }
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWaitingClientAndSendRequest(String acc, L2GameClient client, SessionKey key) {
        block6: {
            if (Config.DEBUG) {
                _log.info(String.valueOf(key));
            }
            WaitingClient wc = new WaitingClient(acc, client, key);
            List<WaitingClient> list = this._waitingClients;
            synchronized (list) {
                this._waitingClients.add(wc);
            }
            PlayerAuthRequest par = new PlayerAuthRequest(acc, key);
            try {
                this.sendPacket(par);
            }
            catch (IOException e) {
                _log.warning("Error while sending player auth request");
                if (!Config.DEBUG) break block6;
                _log.log(Level.WARNING, "", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWaitingClient(L2GameClient client) {
        WaitingClient toRemove = null;
        List<WaitingClient> list = this._waitingClients;
        synchronized (list) {
            for (WaitingClient c : this._waitingClients) {
                if (c.gameClient != client) continue;
                toRemove = c;
            }
            if (toRemove != null) {
                this._waitingClients.remove(toRemove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLogout(String account) {
        if (account == null) {
            return;
        }
        PlayerLogout pl = new PlayerLogout(account);
        try {
            this.sendPacket(pl);
        }
        catch (IOException e) {
            _log.warning("Error while sending logout packet to login");
            if (Config.DEBUG) {
                _log.log(Level.WARNING, "", e);
            }
        }
        finally {
            this._accountsInGameServer.remove(account);
        }
    }

    public void addGameServerLogin(String account, L2GameClient client) {
        this._accountsInGameServer.put(account, client);
    }

    public void sendAccessLevel(String account, int level) {
        block2: {
            ChangeAccessLevel cal = new ChangeAccessLevel(account, level);
            try {
                this.sendPacket(cal);
            }
            catch (IOException e) {
                if (!Config.DEBUG) break block2;
                _log.log(Level.WARNING, "", e);
            }
        }
    }

    public void sendClientTracert(String account, String[] adress) {
        block2: {
            PlayerTracert ptc = new PlayerTracert(account, adress[0], adress[1], adress[2], adress[3], adress[4]);
            try {
                this.sendPacket(ptc);
            }
            catch (IOException e) {
                if (!Config.DEBUG) break block2;
                _log.log(Level.WARNING, "", e);
            }
        }
    }

    public void sendMail(String account, String mailId, String ... args) {
        block2: {
            SendMail sem = new SendMail(account, mailId, args);
            try {
                this.sendPacket(sem);
            }
            catch (IOException e) {
                if (!Config.DEBUG) break block2;
                _log.log(Level.WARNING, "", e);
            }
        }
    }

    public void sendTempBan(String account, String ip, long time) {
        block2: {
            TempBan tbn = new TempBan(account, ip, time);
            try {
                this.sendPacket(tbn);
            }
            catch (IOException e) {
                if (!Config.DEBUG) break block2;
                _log.log(Level.WARNING, "", e);
            }
        }
    }

    private String hexToString(byte[] hex) {
        return new BigInteger(hex).toString(16);
    }

    public void doKickPlayer(String account) {
        L2GameClient client = this._accountsInGameServer.get(account);
        if (client != null) {
            LogRecord record = new LogRecord(Level.WARNING, "Kicked by login");
            record.setParameters(new Object[]{client});
            _logAccounting.log(record);
            client.setAditionalClosePacket(SystemMessage.getSystemMessage(SystemMessageId.ANOTHER_LOGIN_WITH_ACCOUNT));
            client.closeNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCharsOnServer(String account) {
        block9: {
            Connection con = null;
            int chars = 0;
            ArrayList<Long> charToDel = new ArrayList<Long>();
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("SELECT deletetime FROM characters WHERE account_name=?");
                statement.setString(1, account);
                ResultSet rset = statement.executeQuery();
                while (rset.next()) {
                    ++chars;
                    long delTime = rset.getLong("deletetime");
                    if (delTime == 0L) continue;
                    charToDel.add(delTime);
                }
                rset.close();
                statement.close();
            }
            catch (SQLException e) {
                _log.log(Level.WARNING, "Exception: getCharsOnServer: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
            ReplyCharacters rec = new ReplyCharacters(account, chars, charToDel);
            try {
                this.sendPacket(rec);
            }
            catch (IOException e) {
                if (!Config.DEBUG) break block9;
                _log.log(Level.WARNING, "", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacket(BaseSendablePacket sl) throws IOException {
        byte[] data = sl.getContent();
        NewCrypt.appendChecksum(data);
        if (Config.DEBUG) {
            _log.finest("[S]\n" + Util.printData(data));
        }
        this._blowfish.cryptMe(data);
        int len = data.length + 2;
        OutputStream outputStream = this._out;
        synchronized (outputStream) {
            this._out.write(len & 0xFF);
            this._out.write(len >> 8 & 0xFF);
            this._out.write(data);
            this._out.flush();
        }
    }

    public void setMaxPlayer(int maxPlayer) {
        this.sendServerStatus(4, maxPlayer);
        this._maxPlayer = maxPlayer;
    }

    public int getMaxPlayer() {
        return this._maxPlayer;
    }

    public void sendServerStatus(int id, int value) {
        block2: {
            ServerStatus ss = new ServerStatus();
            ss.addAttribute(id, value);
            try {
                this.sendPacket(ss);
            }
            catch (IOException e) {
                if (!Config.DEBUG) break block2;
                _log.log(Level.WARNING, "", e);
            }
        }
    }

    public void sendServerType() {
        block2: {
            ServerStatus ss = new ServerStatus();
            ss.addAttribute(2, Config.SERVER_LIST_TYPE);
            try {
                this.sendPacket(ss);
            }
            catch (IOException e) {
                if (!Config.DEBUG) break block2;
                _log.log(Level.WARNING, "", e);
            }
        }
    }

    public String getStatusString() {
        return ServerStatus.STATUS_STRING[this._status];
    }

    public boolean isBracketShown() {
        return Config.SERVER_LIST_BRACKET;
    }

    public String getServerName() {
        return this._serverName;
    }

    public void setServerStatus(int status) {
        switch (status) {
            case 0: {
                this.sendServerStatus(1, 0);
                this._status = status;
                break;
            }
            case 4: {
                this.sendServerStatus(1, 4);
                this._status = status;
                break;
            }
            case 3: {
                this.sendServerStatus(1, 3);
                this._status = status;
                break;
            }
            case 5: {
                this.sendServerStatus(1, 5);
                this._status = status;
                break;
            }
            case 1: {
                this.sendServerStatus(1, 1);
                this._status = status;
                break;
            }
            case 2: {
                this.sendServerStatus(1, 2);
                this._status = status;
                break;
            }
            default: {
                throw new IllegalArgumentException("Status does not exists:" + status);
            }
        }
    }

    private static class SingletonHolder {
        protected static final LoginServerThread _instance = new LoginServerThread();

        private SingletonHolder() {
        }
    }

    private static class WaitingClient {
        public int timestamp;
        public String account;
        public L2GameClient gameClient;
        public SessionKey session;

        public WaitingClient(String acc, L2GameClient client, SessionKey key) {
            this.account = acc;
            this.timestamp = GameTimeController.getGameTicks();
            this.gameClient = client;
            this.session = key;
        }
    }

    public static class SessionKey {
        public int playOkID1;
        public int playOkID2;
        public int loginOkID1;
        public int loginOkID2;

        public SessionKey(int loginOK1, int loginOK2, int playOK1, int playOK2) {
            this.playOkID1 = playOK1;
            this.playOkID2 = playOK2;
            this.loginOkID1 = loginOK1;
            this.loginOkID2 = loginOK2;
        }

        public String toString() {
            return "PlayOk: " + this.playOkID1 + " " + this.playOkID2 + " LoginOk:" + this.loginOkID1 + " " + this.loginOkID2;
        }
    }
}

