/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.Territory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FestivalMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FriendlyMobInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2RaidBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2RiftInvaderInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Future;
import java.util.logging.Level;

public class L2AttackableAI
extends L2CharacterAI
implements Runnable {
    private static final int RANDOM_WALK_RATE = 30;
    private static final int MAX_ATTACK_TIMEOUT = 1200;
    private Future<?> _aiTask;
    private int _attackTimeout;
    private int _globalAggro;
    private boolean _thinking;
    private int timepass = 0;
    private int chaostime = 0;
    private final L2NpcTemplate _skillrender;
    int lastBuffTick;

    public L2AttackableAI(L2Character.AIAccessor accessor) {
        super(accessor);
        this._skillrender = NpcTable.getInstance().getTemplate(this.getActiveChar().getTemplate().npcId);
        this._attackTimeout = Integer.MAX_VALUE;
        this._globalAggro = -10;
    }

    @Override
    public void run() {
        this.onEvtThink();
    }

    private boolean autoAttackCondition(L2Character target) {
        L2PcInstance owner;
        if (target == null || this.getActiveChar() == null) {
            return false;
        }
        L2Attackable me = this.getActiveChar();
        if (target.isInvul()) {
            if (target instanceof L2PcInstance && ((L2PcInstance)target).isGM()) {
                return false;
            }
            if (target instanceof L2Summon && ((L2Summon)target).getOwner().isGM()) {
                return false;
            }
        }
        if (target instanceof L2DoorInstance) {
            return false;
        }
        if (target.isAlikeDead() || target instanceof L2Playable && !me.isInsideRadius(target, me.getAggroRange(), true, false)) {
            return false;
        }
        if (target instanceof L2Playable && !me.isRaid() && !me.canSeeThroughSilentMove() && ((L2Playable)target).isSilentMoving()) {
            return false;
        }
        if (target instanceof L2PcInstance) {
            if (((L2PcInstance)target).isGM() && !((L2PcInstance)target).getAccessLevel().canTakeAggro()) {
                return false;
            }
            if ("varka_silenos_clan".equals(me.getFactionId()) && ((L2PcInstance)target).isAlliedWithVarka()) {
                return false;
            }
            if ("ketra_orc_clan".equals(me.getFactionId()) && ((L2PcInstance)target).isAlliedWithKetra()) {
                return false;
            }
            if (((L2PcInstance)target).isRecentFakeDeath()) {
                return false;
            }
            if (target.isInParty() && target.getParty().isInDimensionalRift()) {
                byte riftType = target.getParty().getDimensionalRift().getType();
                byte riftRoom = target.getParty().getDimensionalRift().getCurrentRoom();
                if (me instanceof L2RiftInvaderInstance && !DimensionalRiftManager.getInstance().getRoom(riftType, riftRoom).checkIfInZone(me.getX(), me.getY(), me.getZ())) {
                    return false;
                }
            }
        }
        if (target instanceof L2Summon && (owner = ((L2Summon)target).getOwner()) != null) {
            if (owner.isGM() && (owner.isInvul() || !owner.getAccessLevel().canTakeAggro())) {
                return false;
            }
            if ("varka_silenos_clan".equals(me.getFactionId()) && owner.isAlliedWithVarka()) {
                return false;
            }
            if ("ketra_orc_clan".equals(me.getFactionId()) && owner.isAlliedWithKetra()) {
                return false;
            }
        }
        if (this.getActiveChar() instanceof L2GuardInstance) {
            if (target instanceof L2PcInstance && ((L2PcInstance)target).getKarma() > 0) {
                return GeoData.getInstance().canSeeTarget((L2Object)me, target);
            }
            if (target instanceof L2MonsterInstance && Config.GUARD_ATTACK_AGGRO_MOB) {
                return ((L2MonsterInstance)target).isAggressive() && GeoData.getInstance().canSeeTarget((L2Object)me, target);
            }
            return false;
        }
        if (this.getActiveChar() instanceof L2FriendlyMobInstance) {
            if (target instanceof L2Npc) {
                return false;
            }
            if (target instanceof L2PcInstance && ((L2PcInstance)target).getKarma() > 0) {
                return GeoData.getInstance().canSeeTarget((L2Object)me, target);
            }
            return false;
        }
        if (target instanceof L2Attackable) {
            if (this.getActiveChar().getEnemyClan() == null || ((L2Attackable)target).getClan() == null) {
                return false;
            }
            if (!target.isAutoAttackable(this.getActiveChar())) {
                return false;
            }
            if (this.getActiveChar().getEnemyClan().equals(((L2Attackable)target).getClan())) {
                if (this.getActiveChar().isInsideRadius(target, this.getActiveChar().getEnemyRange(), false, false)) {
                    return GeoData.getInstance().canSeeTarget((L2Object)this.getActiveChar(), target);
                }
                return false;
            }
            if (this.getActiveChar().getIsChaos() > 0 && me.isInsideRadius(target, this.getActiveChar().getIsChaos(), false, false)) {
                if (this.getActiveChar().getFactionId() != null && this.getActiveChar().getFactionId().equals(((L2Attackable)target).getFactionId())) {
                    return false;
                }
                return GeoData.getInstance().canSeeTarget((L2Object)me, target);
            }
        }
        if (target instanceof L2Attackable || target instanceof L2Npc) {
            return false;
        }
        if (!Config.ALT_MOB_AGRO_IN_PEACEZONE && target.isInsideZone((byte)1)) {
            return false;
        }
        if (me.isChampion() && Config.L2JMOD_CHAMPION_PASSIVE) {
            return false;
        }
        return me.isAggressive() && GeoData.getInstance().canSeeTarget((L2Object)me, target);
    }

    public void startAITask() {
        if (this._aiTask == null) {
            this._aiTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(this, 1000L, 1000L);
        }
    }

    @Override
    public void stopAITask() {
        if (this._aiTask != null) {
            this._aiTask.cancel(false);
            this._aiTask = null;
        }
        super.stopAITask();
    }

    @Override
    synchronized void changeIntention(CtrlIntention intention, Object arg0, Object arg1) {
        if (intention == CtrlIntention.AI_INTENTION_IDLE || intention == CtrlIntention.AI_INTENTION_ACTIVE) {
            L2Attackable npc = this.getActiveChar();
            if (!npc.isAlikeDead()) {
                if (!npc.getKnownList().getKnownPlayers().isEmpty()) {
                    intention = CtrlIntention.AI_INTENTION_ACTIVE;
                } else if (npc.getSpawn() != null) {
                    int range = Config.MAX_DRIFT_RANGE;
                    if (!npc.isInsideRadius(npc.getSpawn().getLocx(), npc.getSpawn().getLocy(), npc.getSpawn().getLocz(), range + range, true, false)) {
                        intention = CtrlIntention.AI_INTENTION_ACTIVE;
                    }
                }
            }
            if (intention == CtrlIntention.AI_INTENTION_IDLE) {
                super.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
                if (this._aiTask != null) {
                    this._aiTask.cancel(true);
                    this._aiTask = null;
                }
                this._accessor.detachAI();
                return;
            }
        }
        super.changeIntention(intention, arg0, arg1);
        this.startAITask();
    }

    @Override
    protected void onIntentionAttack(L2Character target) {
        this._attackTimeout = 1200 + GameTimeController.getGameTicks();
        if (this.lastBuffTick + 30 < GameTimeController.getGameTicks()) {
            if (this._skillrender.hasBuffSkill()) {
                L2Skill sk;
                Iterator i$ = this._skillrender._buffskills.iterator();
                while (i$.hasNext() && !this.cast(sk = (L2Skill)i$.next())) {
                }
            }
            this.lastBuffTick = GameTimeController.getGameTicks();
        }
        super.onIntentionAttack(target);
    }

    private void thinkCast() {
        if (this.checkTargetLost(this.getCastTarget())) {
            this.setCastTarget(null);
            return;
        }
        if (this.maybeMoveToPawn(this.getCastTarget(), this._actor.getMagicalAttackRange(this._skill))) {
            return;
        }
        this.clientStopMoving(null);
        this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        this._accessor.doCast(this._skill);
    }

    private void thinkActive() {
        L2Attackable npc = this.getActiveChar();
        if (this._globalAggro != 0) {
            this._globalAggro = this._globalAggro < 0 ? ++this._globalAggro : --this._globalAggro;
        }
        if (this._globalAggro >= 0) {
            Collection<L2Object> objs = npc.getKnownList().getKnownObjects().values();
            for (L2Object obj : objs) {
                int hating;
                L2PcInstance targetPlayer;
                if (!(obj instanceof L2Character)) continue;
                L2Character target = (L2Character)obj;
                if (npc instanceof L2FestivalMonsterInstance && obj instanceof L2PcInstance && !(targetPlayer = (L2PcInstance)obj).isFestivalParticipant() || !this.autoAttackCondition(target) || (hating = npc.getHating(target)) != 0) continue;
                npc.addDamageHate(target, 0, 0);
            }
            L2Character hated = npc.isConfused() ? this.getAttackTarget() : npc.getMostHated();
            if (hated != null && !npc.isCoreAIDisabled()) {
                int aggro = npc.getHating(hated);
                if (aggro + this._globalAggro > 0) {
                    if (!npc.isRunning()) {
                        npc.setRunning();
                    }
                    this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, hated);
                }
                return;
            }
        }
        if (npc.getCurrentHp() == (double)npc.getMaxHp() && npc.getCurrentMp() == (double)npc.getMaxMp() && !npc.getAttackByList().isEmpty() && Rnd.nextInt(500) == 0) {
            npc.clearAggroList();
            npc.getAttackByList().clear();
            if (npc instanceof L2MonsterInstance && ((L2MonsterInstance)npc).hasMinions()) {
                ((L2MonsterInstance)npc).getMinionList().deleteReusedMinions();
            }
        }
        if (npc instanceof L2GuardInstance) {
            ((L2GuardInstance)npc).returnHome();
        }
        if (npc instanceof L2FestivalMonsterInstance) {
            return;
        }
        if (!npc.canReturnToSpawnPoint()) {
            return;
        }
        L2Attackable leader = npc.getLeader();
        if (leader != null && !leader.isAlikeDead()) {
            int minRadius = 30;
            int offset = npc.isRaidMinion() ? 500 : 200;
            if (leader.isRunning()) {
                npc.setRunning();
            } else {
                npc.setWalking();
            }
            if (npc.getPlanDistanceSq(leader) > (double)(offset * offset)) {
                int x1 = Rnd.get(60, offset * 2);
                int y1 = Rnd.get(x1, offset * 2);
                y1 = (int)Math.sqrt(y1 * y1 - x1 * x1);
                x1 = x1 > offset + 30 ? leader.getX() + x1 - offset : leader.getX() - x1 + 30;
                y1 = y1 > offset + 30 ? leader.getY() + y1 - offset : leader.getY() - y1 + 30;
                int z1 = leader.getZ();
                this.moveTo(x1, y1, z1);
                return;
            }
            if (Rnd.nextInt(30) == 0 && this._skillrender.hasBuffSkill()) {
                for (L2Skill sk : this._skillrender._buffskills) {
                    if (!this.cast(sk)) continue;
                    return;
                }
            }
        } else if (npc.getSpawn() != null && Rnd.nextInt(30) == 0 && !npc.isNoRndWalk()) {
            int z1;
            int y1;
            int x1;
            int range = Config.MAX_DRIFT_RANGE;
            if (this._skillrender.hasBuffSkill()) {
                for (L2Skill sk : this._skillrender._buffskills) {
                    if (!this.cast(sk)) continue;
                    return;
                }
            }
            if (npc.getSpawn().getLocx() == 0 && npc.getSpawn().getLocy() == 0) {
                int[] p = Territory.getInstance().getRandomPoint(npc.getSpawn().getLocation());
                x1 = p[0];
                y1 = p[1];
                z1 = p[2];
                double distance2 = npc.getPlanDistanceSq(x1, y1);
                if (distance2 > (double)((range + range) * (range + range))) {
                    npc.setisReturningToSpawnPoint(true);
                    float delay = (float)Math.sqrt(distance2) / (float)range;
                    x1 = npc.getX() + (int)((float)(x1 - npc.getX()) / delay);
                    y1 = npc.getY() + (int)((float)(y1 - npc.getY()) / delay);
                }
                if (Territory.getInstance().getProcMax(npc.getSpawn().getLocation()) > 0 && !npc.isReturningToSpawnPoint()) {
                    return;
                }
            } else {
                x1 = npc.getSpawn().getLocx();
                y1 = npc.getSpawn().getLocy();
                z1 = npc.getSpawn().getLocz();
                if (!npc.isInsideRadius(x1, y1, range, false)) {
                    npc.setisReturningToSpawnPoint(true);
                } else {
                    x1 = Rnd.nextInt(range * 2);
                    y1 = Rnd.get(x1, range * 2);
                    y1 = (int)Math.sqrt(y1 * y1 - x1 * x1);
                    x1 += npc.getSpawn().getLocx() - range;
                    y1 += npc.getSpawn().getLocy() - range;
                    z1 = npc.getZ();
                }
            }
            this.moveTo(x1, y1, z1);
        }
    }

    private void thinkAttack() {
        double distance2;
        L2Skill skill;
        L2Attackable npc = this.getActiveChar();
        if (npc.isCastingNow()) {
            return;
        }
        L2Character originalAttackTarget = this.getAttackTarget();
        if (originalAttackTarget == null || originalAttackTarget.isAlikeDead() || this._attackTimeout < GameTimeController.getGameTicks()) {
            if (originalAttackTarget != null) {
                npc.stopHating(originalAttackTarget);
            }
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            npc.setWalking();
            return;
        }
        int collision = npc.getTemplate().collisionRadius;
        String faction_id = this.getActiveChar().getFactionId();
        if (originalAttackTarget instanceof L2Npc && "victim".equals(((L2Npc)originalAttackTarget).getFactionId())) {
            faction_id = null;
        }
        if (faction_id != null && !faction_id.isEmpty()) {
            int factionRange = npc.getClanRange() + collision;
            Collection<L2Object> objs = npc.getWorldRegion().getVisibleObjects().values();
            try {
                for (L2Object obj : objs) {
                    L2Npc called;
                    String npcfaction;
                    if (!(obj instanceof L2Npc) || (npcfaction = (called = (L2Npc)obj).getFactionId()) == null || npcfaction.isEmpty() || npc == called || !Util.checkIfInShortRadius(npc.getFactionRange(), npc, called, false)) continue;
                    boolean sevenSignFaction = false;
                    if ("c_dungeon_clan".equals(faction_id) && ("c_dungeon_lilim".equals(npcfaction) || "c_dungeon_nephi".equals(npcfaction))) {
                        sevenSignFaction = true;
                    } else if ("c_dungeon_lilim".equals(faction_id) && "c_dungeon_clan".equals(npcfaction)) {
                        sevenSignFaction = true;
                    } else if ("c_dungeon_nephi".equals(faction_id) && "c_dungeon_clan".equals(npcfaction)) {
                        sevenSignFaction = true;
                    }
                    if (!faction_id.equals(npcfaction) && !sevenSignFaction || !npc.isInsideRadius(called, factionRange, true, false) || !called.hasAI() || Math.abs(originalAttackTarget.getZ() - called.getZ()) >= 600 || !npc.getAttackByList().contains(originalAttackTarget) || called.getAI()._intention != CtrlIntention.AI_INTENTION_IDLE && called.getAI()._intention != CtrlIntention.AI_INTENTION_ACTIVE || called.getInstanceId() != npc.getInstanceId()) continue;
                    if (originalAttackTarget instanceof L2Playable) {
                        Quest[] quests = called.getTemplate().getEventQuests(Quest.QuestEventType.ON_FACTION_CALL);
                        if (quests == null) continue;
                        L2PcInstance player = originalAttackTarget.getActingPlayer();
                        boolean isSummon = originalAttackTarget instanceof L2Summon;
                        for (Quest quest : quests) {
                            quest.notifyFactionCall(called, this.getActiveChar(), player, isSummon);
                        }
                        continue;
                    }
                    if (!(called instanceof L2Attackable) || this.getAttackTarget() == null || called.getAI()._intention == CtrlIntention.AI_INTENTION_ATTACK) continue;
                    ((L2Attackable)called).addDamageHate(this.getAttackTarget(), 0, npc.getHating(this.getAttackTarget()));
                    called.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this.getAttackTarget());
                }
            }
            catch (NullPointerException e) {
                _log.log(Level.WARNING, "L2AttackableAI: thinkAttack() faction call failed: " + e.getMessage(), e);
            }
        }
        if (npc.isCoreAIDisabled()) {
            return;
        }
        L2Character mostHate = npc.getMostHated();
        if (mostHate == null) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return;
        }
        this.setAttackTarget(mostHate);
        npc.setTarget(mostHate);
        int combinedCollision = collision + mostHate.getTemplate().collisionRadius;
        if (this._skillrender.hasSuicideSkill() && (int)(npc.getCurrentHp() / (double)npc.getMaxHp() * 100.0) < 30 && Util.checkIfInRange((skill = (L2Skill)this._skillrender.getSuicideSkills().get(Rnd.nextInt(this._skillrender.getSuicideSkills().size()))).getSkillRadius(), this.getActiveChar(), mostHate, false) && Rnd.get(100) < Rnd.get(npc.getMinSkillChance(), npc.getMaxSkillChance())) {
            if (this.cast(skill)) {
                return;
            }
            for (L2Skill sk : this._skillrender.getSuicideSkills()) {
                if (!this.cast(sk)) continue;
                return;
            }
        }
        if (!npc.isMovementDisabled() && Rnd.nextInt(100) <= 3) {
            for (L2Object nearby : npc.getKnownList().getKnownObjects().values()) {
                if (!(nearby instanceof L2Attackable) || !npc.isInsideRadius(nearby, collision, false, false) || nearby == mostHate) continue;
                int newX = combinedCollision + Rnd.get(40);
                newX = Rnd.nextBoolean() ? mostHate.getX() + newX : mostHate.getX() - newX;
                int newY = combinedCollision + Rnd.get(40);
                newY = Rnd.nextBoolean() ? mostHate.getY() + newY : mostHate.getY() - newY;
                if (!npc.isInsideRadius(newX, newY, collision, false)) {
                    int newZ = npc.getZ() + 30;
                    if (Config.GEODATA == 0 || GeoData.getInstance().canMoveFromToTarget(npc.getX(), npc.getY(), npc.getZ(), newX, newY, newZ, npc.getInstanceId())) {
                        this.moveTo(newX, newY, newZ);
                    }
                }
                return;
            }
        }
        if (!npc.isMovementDisabled() && npc.getCanDodge() > 0 && Rnd.get(100) <= npc.getCanDodge() && Math.sqrt(distance2 = npc.getPlanDistanceSq(mostHate.getX(), mostHate.getY())) <= (double)(60 + combinedCollision)) {
            int posX = this._actor.getX() + Rnd.get(-100, 100);
            int posY = this._actor.getY() + Rnd.get(-100, 100);
            int posZ = this._actor.getZ() + 30;
            if (Config.GEODATA == 0 || GeoData.getInstance().canMoveFromToTarget(npc.getX(), npc.getY(), npc.getZ(), posX, posY, posZ, npc.getInstanceId())) {
                this.setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(posX, posY, posZ, 0));
            }
            return;
        }
        if (npc.isRaid() || npc.isRaidMinion()) {
            ++this.chaostime;
            if (npc instanceof L2RaidBossInstance) {
                if (!((L2MonsterInstance)npc).hasMinions()) {
                    if (this.chaostime > Config.RAID_CHAOS_TIME && (double)Rnd.get(100) <= 100.0 - npc.getCurrentHp() * 100.0 / (double)npc.getMaxHp()) {
                        this.aggroReconsider();
                        this.chaostime = 0;
                        return;
                    }
                } else if (this.chaostime > Config.RAID_CHAOS_TIME && (double)Rnd.get(100) <= 100.0 - npc.getCurrentHp() * 200.0 / (double)npc.getMaxHp()) {
                    this.aggroReconsider();
                    this.chaostime = 0;
                    return;
                }
            } else if (npc instanceof L2GrandBossInstance) {
                double chaosRate;
                if (this.chaostime > Config.GRAND_CHAOS_TIME && ((chaosRate = 100.0 - npc.getCurrentHp() * 300.0 / (double)npc.getMaxHp()) <= 10.0 && Rnd.get(100) <= 10 || chaosRate > 10.0 && (double)Rnd.get(100) <= chaosRate)) {
                    this.aggroReconsider();
                    this.chaostime = 0;
                    return;
                }
            } else if (this.chaostime > Config.MINION_CHAOS_TIME && (double)Rnd.get(100) <= 100.0 - npc.getCurrentHp() * 200.0 / (double)npc.getMaxHp()) {
                this.aggroReconsider();
                this.chaostime = 0;
                return;
            }
        }
        if (this._skillrender.hasSkill()) {
            if (this._skillrender.hasHealSkill() && this._skillrender._healskills != null) {
                L2Attackable leader;
                double percentage = npc.getCurrentHp() / (double)npc.getMaxHp() * 100.0;
                if (npc.isMinion() && (leader = npc.getLeader()) != null && !leader.isDead() && (double)Rnd.get(100) > leader.getCurrentHp() / (double)leader.getMaxHp() * 100.0) {
                    for (L2Skill sk : this._skillrender._healskills) {
                        if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_SELF || (double)sk.getMpConsume() >= npc.getCurrentMp() || npc.isSkillDisabled(sk) || sk.isMagic() && npc.isMuted() || !sk.isMagic() && npc.isPhysicalMuted()) continue;
                        if (!(Util.checkIfInRange(sk.getCastRange() + collision + ((L2Character)leader).getTemplate().collisionRadius, npc, leader, false) || this.isParty(sk) || npc.isMovementDisabled())) {
                            this.moveToPawn(leader, sk.getCastRange() + collision + ((L2Character)leader).getTemplate().collisionRadius);
                            return;
                        }
                        if (!GeoData.getInstance().canSeeTarget((L2Object)npc, leader)) continue;
                        this.clientStopMoving(null);
                        npc.setTarget(leader);
                        this.clientStopMoving(null);
                        npc.doCast(sk);
                        return;
                    }
                }
                if ((double)Rnd.get(100) < (100.0 - percentage) / 3.0) {
                    for (L2Skill sk : this._skillrender._healskills) {
                        if ((double)sk.getMpConsume() >= npc.getCurrentMp() || npc.isSkillDisabled(sk) || sk.isMagic() && npc.isMuted() || !sk.isMagic() && npc.isPhysicalMuted()) continue;
                        this.clientStopMoving(null);
                        npc.setTarget(npc);
                        npc.doCast(sk);
                        return;
                    }
                }
                for (L2Skill sk : this._skillrender._healskills) {
                    if ((double)sk.getMpConsume() >= npc.getCurrentMp() || npc.isSkillDisabled(sk) || sk.isMagic() && npc.isMuted() || !sk.isMagic() && npc.isPhysicalMuted()) continue;
                    if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_ONE) {
                        for (L2Character obj : npc.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + collision)) {
                            if (!(obj instanceof L2Attackable) || obj.isDead()) continue;
                            L2Attackable targets = (L2Attackable)obj;
                            if (npc.getFactionId() != null && !npc.getFactionId().equals(targets.getFactionId())) continue;
                            percentage = targets.getCurrentHp() / (double)targets.getMaxHp() * 100.0;
                            if (!((double)Rnd.get(100) < (100.0 - percentage) / 10.0) || !GeoData.getInstance().canSeeTarget((L2Object)npc, targets)) continue;
                            this.clientStopMoving(null);
                            npc.setTarget(obj);
                            npc.doCast(sk);
                            return;
                        }
                    }
                    if (!this.isParty(sk)) continue;
                    this.clientStopMoving(null);
                    npc.doCast(sk);
                    return;
                }
            }
            if (this._skillrender.hasResSkill()) {
                L2Attackable leader;
                if (npc.isMinion() && (leader = npc.getLeader()) != null && leader.isDead()) {
                    for (L2Skill sk : this._skillrender._resskills) {
                        if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_SELF || (double)sk.getMpConsume() >= npc.getCurrentMp() || npc.isSkillDisabled(sk) || sk.isMagic() && npc.isMuted() || !sk.isMagic() && npc.isPhysicalMuted()) continue;
                        if (!(Util.checkIfInRange(sk.getCastRange() + collision + ((L2Character)leader).getTemplate().collisionRadius, npc, leader, false) || this.isParty(sk) || npc.isMovementDisabled())) {
                            this.moveToPawn(leader, sk.getCastRange() + collision + ((L2Character)leader).getTemplate().collisionRadius);
                            return;
                        }
                        if (!GeoData.getInstance().canSeeTarget((L2Object)npc, leader)) continue;
                        this.clientStopMoving(null);
                        npc.setTarget(leader);
                        npc.doCast(sk);
                        return;
                    }
                }
                for (L2Skill sk : this._skillrender._resskills) {
                    if ((double)sk.getMpConsume() >= npc.getCurrentMp() || npc.isSkillDisabled(sk) || sk.isMagic() && npc.isMuted() || !sk.isMagic() && npc.isPhysicalMuted()) continue;
                    if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_ONE) {
                        for (L2Character obj : npc.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + collision)) {
                            if (!(obj instanceof L2Attackable) || !obj.isDead()) continue;
                            L2Attackable targets = (L2Attackable)obj;
                            if (npc.getFactionId() != null && !npc.getFactionId().equals(targets.getFactionId()) || Rnd.get(100) >= 10 || !GeoData.getInstance().canSeeTarget((L2Object)npc, targets)) continue;
                            this.clientStopMoving(null);
                            npc.setTarget(obj);
                            npc.doCast(sk);
                            return;
                        }
                    }
                    if (!this.isParty(sk)) continue;
                    this.clientStopMoving(null);
                    L2Character target = this.getAttackTarget();
                    npc.setTarget(npc);
                    npc.doCast(sk);
                    npc.setTarget(target);
                    return;
                }
            }
        }
        double dist = Math.sqrt(npc.getPlanDistanceSq(mostHate.getX(), mostHate.getY()));
        int dist2 = (int)dist - collision;
        int range = npc.getPhysicalAttackRange() + combinedCollision;
        if (mostHate.isMoving()) {
            range += 50;
            if (npc.isMoving()) {
                range += 50;
            }
        }
        if (npc.isMovementDisabled() && (dist > (double)range || mostHate.isMoving()) || dist > (double)range && mostHate.isMoving()) {
            this.movementDisable();
            return;
        }
        this.setTimepass(0);
        if (this._skillrender.hasSkill()) {
            if (Rnd.get(100) < Rnd.get(npc.getMinSkillChance(), npc.getMaxSkillChance())) {
                L2Skill skills = (L2Skill)this._skillrender._generalskills.get(Rnd.nextInt(this._skillrender._generalskills.size()));
                if (this.cast(skills)) {
                    return;
                }
                for (L2Skill sk : this._skillrender._generalskills) {
                    if (!this.cast(sk)) continue;
                    return;
                }
            }
            if (npc.hasLSkill() || npc.hasSSkill()) {
                if (npc.hasSSkill() && dist2 <= 150 && Rnd.get(100) <= npc.getSSkillChance()) {
                    this.sSkillRender();
                    if (this._skillrender._Srangeskills != null) {
                        L2Skill skills = (L2Skill)this._skillrender._Srangeskills.get(Rnd.nextInt(this._skillrender._Srangeskills.size()));
                        if (this.cast(skills)) {
                            return;
                        }
                        for (L2Skill sk : this._skillrender._Srangeskills) {
                            if (!this.cast(sk)) continue;
                            return;
                        }
                    }
                }
                if (npc.hasLSkill() && dist2 > 150 && Rnd.get(100) <= npc.getLSkillChance()) {
                    this.lSkillRender();
                    if (this._skillrender._Lrangeskills != null) {
                        L2Skill skills = (L2Skill)this._skillrender._Lrangeskills.get(Rnd.nextInt(this._skillrender._Lrangeskills.size()));
                        if (this.cast(skills)) {
                            return;
                        }
                        for (L2Skill sk : this._skillrender._Lrangeskills) {
                            if (!this.cast(sk)) continue;
                            return;
                        }
                    }
                }
            }
        }
        if (dist2 > range || !GeoData.getInstance().canSeeTarget((L2Object)npc, mostHate)) {
            if (npc.isMovementDisabled()) {
                this.targetReconsider();
                return;
            }
            if (this.getAttackTarget().isMoving()) {
                range -= 100;
            }
            if (range < 5) {
                range = 5;
            }
            this.moveToPawn(this.getAttackTarget(), range);
            return;
        }
        this.melee(npc.getPrimarySkillId());
    }

    private void melee(int type) {
        if (type != 0) {
            switch (type) {
                case -1: {
                    if (this._skillrender._generalskills == null) break;
                    for (L2Skill sk : this._skillrender._generalskills) {
                        if (!this.cast(sk)) continue;
                        return;
                    }
                    break;
                }
                case 1: {
                    if (!this._skillrender.hasAtkSkill()) break;
                    for (L2Skill sk : this._skillrender._atkskills) {
                        if (!this.cast(sk)) continue;
                        return;
                    }
                    break;
                }
                default: {
                    if (this._skillrender._generalskills == null) break;
                    for (L2Skill sk : this._skillrender._generalskills) {
                        if (sk.getId() != this.getActiveChar().getPrimarySkillId() || !this.cast(sk)) continue;
                        return;
                    }
                }
            }
        }
        this._accessor.doAttack(this.getAttackTarget());
    }

    private boolean cast(L2Skill sk) {
        L2Character attackTarget;
        if (sk == null) {
            return false;
        }
        L2Attackable caster = this.getActiveChar();
        if (caster.isCastingNow() && !sk.isSimultaneousCast()) {
            return false;
        }
        if ((double)sk.getMpConsume() >= caster.getCurrentMp() || caster.isSkillDisabled(sk) || sk.isMagic() && caster.isMuted() || !sk.isMagic() && caster.isPhysicalMuted()) {
            return false;
        }
        if (this.getAttackTarget() == null && caster.getMostHated() != null) {
            this.setAttackTarget(caster.getMostHated());
        }
        if ((attackTarget = this.getAttackTarget()) == null) {
            return false;
        }
        double dist = Math.sqrt(caster.getPlanDistanceSq(attackTarget.getX(), attackTarget.getY()));
        double dist2 = dist - (double)attackTarget.getTemplate().collisionRadius;
        double range = caster.getPhysicalAttackRange() + caster.getTemplate().collisionRadius + attackTarget.getTemplate().collisionRadius;
        double srange = sk.getCastRange() + caster.getTemplate().collisionRadius;
        if (attackTarget.isMoving()) {
            dist2 -= 30.0;
        }
        switch (sk.getSkillType()) {
            case BUFF: {
                L2Character target;
                if (caster.getFirstEffect(sk) == null) {
                    this.clientStopMoving(null);
                    caster.setTarget(caster);
                    caster.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_SELF) {
                    return false;
                }
                if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_ONE && (target = this.effectTargetReconsider(sk, true)) != null) {
                    this.clientStopMoving(null);
                    L2Character targets = attackTarget;
                    caster.setTarget(target);
                    caster.doCast(sk);
                    caster.setTarget(targets);
                    return true;
                }
                if (!this.canParty(sk)) break;
                this.clientStopMoving(null);
                L2Character targets = attackTarget;
                caster.setTarget(caster);
                caster.doCast(sk);
                caster.setTarget(targets);
                return true;
            }
            case HEAL: 
            case HOT: 
            case HEAL_PERCENT: 
            case HEAL_STATIC: 
            case BALANCE_LIFE: {
                L2Npc targets;
                L2Attackable leader;
                double percentage = caster.getCurrentHp() / (double)caster.getMaxHp() * 100.0;
                if (caster.isMinion() && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_SELF && (leader = caster.getLeader()) != null && !leader.isDead() && (double)Rnd.get(100) > leader.getCurrentHp() / (double)leader.getMaxHp() * 100.0) {
                    if (!(Util.checkIfInRange(sk.getCastRange() + caster.getTemplate().collisionRadius + ((L2Character)leader).getTemplate().collisionRadius, caster, leader, false) || this.isParty(sk) || caster.isMovementDisabled())) {
                        this.moveToPawn(leader, sk.getCastRange() + caster.getTemplate().collisionRadius + ((L2Character)leader).getTemplate().collisionRadius);
                    }
                    if (GeoData.getInstance().canSeeTarget((L2Object)caster, leader)) {
                        this.clientStopMoving(null);
                        caster.setTarget(leader);
                        caster.doCast(sk);
                        return true;
                    }
                }
                if ((double)Rnd.get(100) < (100.0 - percentage) / 3.0) {
                    this.clientStopMoving(null);
                    caster.setTarget(caster);
                    caster.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_ONE) {
                    for (L2Character obj : caster.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + caster.getTemplate().collisionRadius)) {
                        if (!(obj instanceof L2Attackable) || obj.isDead()) continue;
                        targets = (L2Attackable)obj;
                        if (caster.getFactionId() != null && !caster.getFactionId().equals(targets.getFactionId())) continue;
                        percentage = targets.getCurrentHp() / (double)targets.getMaxHp() * 100.0;
                        if (!((double)Rnd.get(100) < (100.0 - percentage) / 10.0) || !GeoData.getInstance().canSeeTarget((L2Object)caster, targets)) continue;
                        this.clientStopMoving(null);
                        caster.setTarget(obj);
                        caster.doCast(sk);
                        return true;
                    }
                }
                if (!this.isParty(sk)) break;
                for (L2Character obj : caster.getKnownList().getKnownCharactersInRadius(sk.getSkillRadius() + caster.getTemplate().collisionRadius)) {
                    if (!(obj instanceof L2Attackable)) continue;
                    targets = (L2Npc)obj;
                    if (caster.getFactionId() == null || !targets.getFactionId().equals(caster.getFactionId()) || !(obj.getCurrentHp() < (double)obj.getMaxHp()) || Rnd.get(100) > 20) continue;
                    this.clientStopMoving(null);
                    caster.setTarget(caster);
                    caster.doCast(sk);
                    return true;
                }
                break;
            }
            case RESURRECT: {
                if (!this.isParty(sk)) {
                    if (caster.isMinion() && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_SELF) {
                        L2Attackable leader = caster.getLeader();
                        if (leader != null && leader.isDead() && !Util.checkIfInRange(sk.getCastRange() + caster.getTemplate().collisionRadius + ((L2Character)leader).getTemplate().collisionRadius, caster, leader, false) && !this.isParty(sk) && !caster.isMovementDisabled()) {
                            this.moveToPawn(leader, sk.getCastRange() + caster.getTemplate().collisionRadius + ((L2Character)leader).getTemplate().collisionRadius);
                        }
                        if (GeoData.getInstance().canSeeTarget((L2Object)caster, leader)) {
                            this.clientStopMoving(null);
                            caster.setTarget(leader);
                            caster.doCast(sk);
                            return true;
                        }
                    }
                    for (L2Character obj : caster.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + caster.getTemplate().collisionRadius)) {
                        if (!(obj instanceof L2Attackable) || !obj.isDead()) continue;
                        L2Attackable targets = (L2Attackable)obj;
                        if (caster.getFactionId() != null && !caster.getFactionId().equals(targets.getFactionId()) || Rnd.get(100) >= 10 || !GeoData.getInstance().canSeeTarget((L2Object)caster, targets)) continue;
                        this.clientStopMoving(null);
                        caster.setTarget(obj);
                        caster.doCast(sk);
                        return true;
                    }
                } else {
                    if (!this.isParty(sk)) break;
                    for (L2Character obj : caster.getKnownList().getKnownCharactersInRadius(sk.getSkillRadius() + caster.getTemplate().collisionRadius)) {
                        if (!(obj instanceof L2Attackable)) continue;
                        L2Npc targets = (L2Npc)obj;
                        if (caster.getFactionId() == null || !caster.getFactionId().equals(targets.getFactionId()) || !(obj.getCurrentHp() < (double)obj.getMaxHp()) || Rnd.get(100) > 20) continue;
                        this.clientStopMoving(null);
                        caster.setTarget(caster);
                        caster.doCast(sk);
                        return true;
                    }
                }
                break;
            }
            case DEBUFF: 
            case POISON: 
            case DOT: 
            case MDOT: 
            case BLEED: {
                L2Character target;
                if (GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !this.canAOE(sk) && !attackTarget.isDead() && dist2 <= srange) {
                    if (attackTarget.getFirstEffect(sk) != null) break;
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                if (this.canAOE(sk)) {
                    if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA_CORPSE_MOB) {
                        this.clientStopMoving(null);
                        caster.doCast(sk);
                        return true;
                    }
                    if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_BEHIND_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_FRONT_AREA || !GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) || attackTarget.isDead() || !(dist2 <= srange)) break;
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_ONE || (target = this.effectTargetReconsider(sk, false)) == null) break;
                this.clientStopMoving(null);
                caster.doCast(sk);
                return true;
            }
            case SLEEP: {
                if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_ONE) {
                    if (!attackTarget.isDead() && dist2 <= srange && (dist2 > range || attackTarget.isMoving()) && attackTarget.getFirstEffect(sk) == null) {
                        this.clientStopMoving(null);
                        caster.doCast(sk);
                        return true;
                    }
                    L2Character target = this.effectTargetReconsider(sk, false);
                    if (target == null) break;
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                if (!this.canAOE(sk)) break;
                if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AURA) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_BEHIND_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_FRONT_AREA || !GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) || attackTarget.isDead() || !(dist2 <= srange)) break;
                this.clientStopMoving(null);
                caster.doCast(sk);
                return true;
            }
            case ROOT: 
            case STUN: 
            case PARALYZE: {
                L2Character target;
                if (GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !this.canAOE(sk) && dist2 <= srange) {
                    if (attackTarget.getFirstEffect(sk) != null) break;
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                if (this.canAOE(sk)) {
                    if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AURA) {
                        this.clientStopMoving(null);
                        caster.doCast(sk);
                        return true;
                    }
                    if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_BEHIND_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_FRONT_AREA || !GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) || attackTarget.isDead() || !(dist2 <= srange)) break;
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_ONE || (target = this.effectTargetReconsider(sk, false)) == null) break;
                this.clientStopMoving(null);
                caster.doCast(sk);
                return true;
            }
            case MUTE: 
            case FEAR: {
                L2Character target;
                if (GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !this.canAOE(sk) && dist2 <= srange) {
                    if (attackTarget.getFirstEffect(sk) != null) break;
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                if (this.canAOE(sk)) {
                    if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AURA) {
                        this.clientStopMoving(null);
                        caster.doCast(sk);
                        return true;
                    }
                    if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_BEHIND_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_FRONT_AREA || !GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) || attackTarget.isDead() || !(dist2 <= srange)) break;
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_ONE || (target = this.effectTargetReconsider(sk, false)) == null) break;
                this.clientStopMoving(null);
                caster.doCast(sk);
                return true;
            }
            case CANCEL: 
            case NEGATE: {
                if (Rnd.get(50) != 0) {
                    return true;
                }
                if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_ONE) {
                    if (attackTarget.getFirstEffect(L2EffectType.BUFF) != null && GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                        this.clientStopMoving(null);
                        caster.doCast(sk);
                        return true;
                    }
                    L2Character target = this.effectTargetReconsider(sk, false);
                    if (target == null) break;
                    this.clientStopMoving(null);
                    L2Character targets = attackTarget;
                    caster.setTarget(target);
                    caster.doCast(sk);
                    caster.setTarget(targets);
                    return true;
                }
                if (!this.canAOE(sk)) break;
                if ((sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AURA) && GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget)) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() != L2Skill.SkillTargetType.TARGET_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_BEHIND_AREA && sk.getTargetType() != L2Skill.SkillTargetType.TARGET_FRONT_AREA || !GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) || attackTarget.isDead() || !(dist2 <= srange)) break;
                this.clientStopMoving(null);
                caster.doCast(sk);
                return true;
            }
            case PDAM: 
            case MDAM: 
            case BLOW: 
            case DRAIN: 
            case CHARGEDAM: 
            case FATAL: 
            case DEATHLINK: 
            case CPDAM: 
            case MANADAM: 
            case CPDAMPERCENT: {
                if (!this.canAura(sk)) {
                    if (GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                        this.clientStopMoving(null);
                        caster.doCast(sk);
                        return true;
                    }
                    L2Character target = this.skillTargetReconsider(sk);
                    if (target == null) break;
                    this.clientStopMoving(null);
                    L2Character targets = attackTarget;
                    caster.setTarget(target);
                    caster.doCast(sk);
                    caster.setTarget(targets);
                    return true;
                }
                this.clientStopMoving(null);
                caster.doCast(sk);
                return true;
            }
            default: {
                if (!this.canAura(sk)) {
                    if (GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                        this.clientStopMoving(null);
                        caster.doCast(sk);
                        return true;
                    }
                    L2Character target = this.skillTargetReconsider(sk);
                    if (target == null) break;
                    this.clientStopMoving(null);
                    L2Character targets = attackTarget;
                    caster.setTarget(target);
                    caster.doCast(sk);
                    caster.setTarget(targets);
                    return true;
                }
                this.clientStopMoving(null);
                caster.doCast(sk);
                return true;
            }
        }
        return false;
    }

    private void movementDisable() {
        L2Attackable npc = this.getActiveChar();
        double dist = 0.0;
        double dist2 = 0.0;
        int range = 0;
        try {
            if (npc.getTarget() == null) {
                npc.setTarget(this.getAttackTarget());
            }
            dist = Math.sqrt(npc.getPlanDistanceSq(this.getAttackTarget().getX(), this.getAttackTarget().getY()));
            dist2 = dist - (double)npc.getTemplate().collisionRadius;
            range = npc.getPhysicalAttackRange() + npc.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius;
            if (this.getAttackTarget().isMoving()) {
                dist -= 30.0;
                if (npc.isMoving()) {
                    dist -= 50.0;
                }
            }
            if (this._skillrender.hasSkill()) {
                int random = Rnd.get(100);
                if (this._skillrender.hasImmobiliseSkill() && !this.getAttackTarget().isImmobilized() && random < 2) {
                    for (L2Skill sk : this._skillrender._immobiliseskills) {
                        if ((double)sk.getMpConsume() >= npc.getCurrentMp() || npc.isSkillDisabled(sk) || (double)(sk.getCastRange() + npc.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius) <= dist2 && !this.canAura(sk) || sk.isMagic() && npc.isMuted() || !sk.isMagic() && npc.isPhysicalMuted() || !GeoData.getInstance().canSeeTarget((L2Object)npc, this.getAttackTarget()) || this.getAttackTarget().getFirstEffect(sk) != null) continue;
                        this.clientStopMoving(null);
                        npc.doCast(sk);
                        return;
                    }
                }
                if (this._skillrender.hasCOTSkill() && random < 5) {
                    for (L2Skill sk : this._skillrender._cotskills) {
                        if ((double)sk.getMpConsume() >= npc.getCurrentMp() || npc.isSkillDisabled(sk) || (double)(sk.getCastRange() + npc.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius) <= dist2 && !this.canAura(sk) || sk.isMagic() && npc.isMuted() || !sk.isMagic() && npc.isPhysicalMuted() || !GeoData.getInstance().canSeeTarget((L2Object)npc, this.getAttackTarget()) || this.getAttackTarget().getFirstEffect(sk) != null) continue;
                        this.clientStopMoving(null);
                        npc.doCast(sk);
                        return;
                    }
                }
                if (this._skillrender.hasDebuffSkill() && random < 8) {
                    for (L2Skill sk : this._skillrender._debuffskills) {
                        if ((double)sk.getMpConsume() >= npc.getCurrentMp() || npc.isSkillDisabled(sk) || (double)(sk.getCastRange() + npc.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius) <= dist2 && !this.canAura(sk) || sk.isMagic() && npc.isMuted() || !sk.isMagic() && npc.isPhysicalMuted() || !GeoData.getInstance().canSeeTarget((L2Object)npc, this.getAttackTarget()) || this.getAttackTarget().getFirstEffect(sk) != null) continue;
                        this.clientStopMoving(null);
                        npc.doCast(sk);
                        return;
                    }
                }
                if (this._skillrender.hasNegativeSkill() && random < 9) {
                    for (L2Skill sk : this._skillrender._negativeskills) {
                        if ((double)sk.getMpConsume() >= npc.getCurrentMp() || npc.isSkillDisabled(sk) || (double)(sk.getCastRange() + npc.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius) <= dist2 && !this.canAura(sk) || sk.isMagic() && npc.isMuted() || !sk.isMagic() && npc.isPhysicalMuted() || !GeoData.getInstance().canSeeTarget((L2Object)npc, this.getAttackTarget()) || this.getAttackTarget().getFirstEffect(L2EffectType.BUFF) == null) continue;
                        this.clientStopMoving(null);
                        npc.doCast(sk);
                        return;
                    }
                }
                if (this._skillrender.hasAtkSkill() && (npc.isMovementDisabled() || npc.getAiType() == L2NpcTemplate.AIType.MAGE || npc.getAiType() == L2NpcTemplate.AIType.HEALER)) {
                    for (L2Skill sk : this._skillrender._atkskills) {
                        if ((double)sk.getMpConsume() >= npc.getCurrentMp() || npc.isSkillDisabled(sk) || (double)(sk.getCastRange() + npc.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius) <= dist2 && !this.canAura(sk) || sk.isMagic() && npc.isMuted() || !sk.isMagic() && npc.isPhysicalMuted() || !GeoData.getInstance().canSeeTarget((L2Object)npc, this.getAttackTarget())) continue;
                        this.clientStopMoving(null);
                        npc.doCast(sk);
                        return;
                    }
                }
            }
            if (npc.isMovementDisabled()) {
                this.targetReconsider();
                return;
            }
            if (dist > (double)range || !GeoData.getInstance().canSeeTarget((L2Object)npc, this.getAttackTarget())) {
                if (this.getAttackTarget().isMoving()) {
                    range -= 100;
                }
                if (range < 5) {
                    range = 5;
                }
                this.moveToPawn(this.getAttackTarget(), range);
                return;
            }
            this.melee(npc.getPrimarySkillId());
        }
        catch (NullPointerException e) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            _log.log(Level.WARNING, this + " - failed executing movementDisable(): " + e.getMessage(), e);
            return;
        }
    }

    private L2Character effectTargetReconsider(L2Skill sk, boolean positive) {
        if (sk == null) {
            return null;
        }
        L2Attackable actor = this.getActiveChar();
        if (sk.getSkillType() != L2SkillType.NEGATE || sk.getSkillType() != L2SkillType.CANCEL) {
            if (!positive) {
                double dist = 0.0;
                double dist2 = 0.0;
                int range = 0;
                for (L2Character obj : actor.getAttackByList()) {
                    block19: {
                        if (obj == null || obj.isDead() || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj == this.getAttackTarget()) continue;
                        try {
                            actor.setTarget(this.getAttackTarget());
                            dist = Math.sqrt(actor.getPlanDistanceSq(obj.getX(), obj.getY()));
                            dist2 = dist - (double)actor.getTemplate().collisionRadius;
                            range = sk.getCastRange() + actor.getTemplate().collisionRadius + obj.getTemplate().collisionRadius;
                            if (!obj.isMoving()) break block19;
                            dist2 -= 70.0;
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                    }
                    if (!(dist2 <= (double)range) || this.getAttackTarget().getFirstEffect(sk) != null) continue;
                    return obj;
                }
                for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(range)) {
                    block20: {
                        if (obj.isDead() || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj)) continue;
                        try {
                            actor.setTarget(this.getAttackTarget());
                            dist2 = dist = Math.sqrt(actor.getPlanDistanceSq(obj.getX(), obj.getY()));
                            range = sk.getCastRange() + actor.getTemplate().collisionRadius + obj.getTemplate().collisionRadius;
                            if (!obj.isMoving()) break block20;
                            dist2 -= 70.0;
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                    }
                    if (obj instanceof L2Attackable && actor.getEnemyClan() != null && actor.getEnemyClan().equals(((L2Attackable)obj).getClan()) && dist2 <= (double)range && this.getAttackTarget().getFirstEffect(sk) == null) {
                        return obj;
                    }
                    if (!(obj instanceof L2PcInstance) && !(obj instanceof L2Summon) || !(dist2 <= (double)range) || this.getAttackTarget().getFirstEffect(sk) != null) continue;
                    return obj;
                }
            } else if (positive) {
                double dist = 0.0;
                double dist2 = 0.0;
                int range = 0;
                for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(range)) {
                    block21: {
                        if (!(obj instanceof L2Attackable) || obj.isDead() || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj)) continue;
                        L2Attackable targets = (L2Attackable)obj;
                        if (actor.getFactionId() != null && !actor.getFactionId().equals(targets.getFactionId())) continue;
                        try {
                            actor.setTarget(this.getAttackTarget());
                            dist = Math.sqrt(actor.getPlanDistanceSq(obj.getX(), obj.getY()));
                            dist2 = dist - (double)actor.getTemplate().collisionRadius;
                            range = sk.getCastRange() + actor.getTemplate().collisionRadius + obj.getTemplate().collisionRadius;
                            if (!obj.isMoving()) break block21;
                            dist2 -= 70.0;
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                    }
                    if (!(dist2 <= (double)range) || obj.getFirstEffect(sk) != null) continue;
                    return obj;
                }
            }
            return null;
        }
        double dist = 0.0;
        double dist2 = 0.0;
        int range = 0;
        range = sk.getCastRange() + actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius;
        for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(range)) {
            block22: {
                if (obj == null || obj.isDead() || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj)) continue;
                try {
                    actor.setTarget(this.getAttackTarget());
                    dist = Math.sqrt(actor.getPlanDistanceSq(obj.getX(), obj.getY()));
                    dist2 = dist - (double)actor.getTemplate().collisionRadius;
                    range = sk.getCastRange() + actor.getTemplate().collisionRadius + obj.getTemplate().collisionRadius;
                    if (!obj.isMoving()) break block22;
                    dist2 -= 70.0;
                }
                catch (NullPointerException e) {
                    continue;
                }
            }
            if (obj instanceof L2Attackable && actor.getEnemyClan() != null && actor.getEnemyClan().equals(((L2Attackable)obj).getClan()) && dist2 <= (double)range && this.getAttackTarget().getFirstEffect(L2EffectType.BUFF) != null) {
                return obj;
            }
            if (!(obj instanceof L2PcInstance) && !(obj instanceof L2Summon) || !(dist2 <= (double)range) || this.getAttackTarget().getFirstEffect(L2EffectType.BUFF) == null) continue;
            return obj;
        }
        return null;
    }

    private L2Character skillTargetReconsider(L2Skill sk) {
        double dist = 0.0;
        double dist2 = 0.0;
        int range = 0;
        L2Attackable actor = this.getActiveChar();
        if (actor.getHateList() != null) {
            for (L2Character obj : actor.getHateList()) {
                if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj.isDead()) continue;
                try {
                    actor.setTarget(this.getAttackTarget());
                    dist = Math.sqrt(actor.getPlanDistanceSq(obj.getX(), obj.getY()));
                    dist2 = dist - (double)actor.getTemplate().collisionRadius;
                    range = sk.getCastRange() + actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius;
                }
                catch (NullPointerException e) {
                    continue;
                }
                if (!(dist2 <= (double)range)) continue;
                return obj;
            }
        }
        if (!(actor instanceof L2GuardInstance)) {
            Collection<L2Object> objs = actor.getKnownList().getKnownObjects().values();
            for (L2Object target : objs) {
                try {
                    actor.setTarget(this.getAttackTarget());
                    dist2 = dist = Math.sqrt(actor.getPlanDistanceSq(target.getX(), target.getY()));
                    range = sk.getCastRange() + actor.getTemplate().collisionRadius + this.getAttackTarget().getTemplate().collisionRadius;
                }
                catch (NullPointerException e) {
                    continue;
                }
                L2Character obj = null;
                if (target instanceof L2Character) {
                    obj = (L2Character)target;
                }
                if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || dist2 > (double)range) continue;
                if (obj instanceof L2PcInstance) {
                    return obj;
                }
                if (obj instanceof L2Attackable) {
                    if (actor.getEnemyClan() != null && actor.getEnemyClan().equals(((L2Attackable)obj).getClan())) {
                        return obj;
                    }
                    if (actor.getIsChaos() != 0) {
                        if (((L2Attackable)obj).getFactionId() != null && ((L2Attackable)obj).getFactionId().equals(actor.getFactionId())) continue;
                        return obj;
                    }
                }
                if (!(obj instanceof L2Summon)) continue;
                return obj;
            }
        }
        return null;
    }

    private void targetReconsider() {
        double dist = 0.0;
        double dist2 = 0.0;
        int range = 0;
        L2Attackable actor = this.getActiveChar();
        L2Character MostHate = actor.getMostHated();
        if (actor.getHateList() != null) {
            for (L2Character obj : actor.getHateList()) {
                block18: {
                    if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj.isDead() || obj != MostHate || obj == actor) continue;
                    try {
                        dist = Math.sqrt(actor.getPlanDistanceSq(obj.getX(), obj.getY()));
                        dist2 = dist - (double)actor.getTemplate().collisionRadius;
                        range = actor.getPhysicalAttackRange() + actor.getTemplate().collisionRadius + obj.getTemplate().collisionRadius;
                        if (!obj.isMoving()) break block18;
                        dist2 -= 70.0;
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                }
                if (!(dist2 <= (double)range)) continue;
                if (MostHate != null) {
                    actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                } else {
                    actor.addDamageHate(obj, 0, 2000);
                }
                actor.setTarget(obj);
                this.setAttackTarget(obj);
                return;
            }
        }
        if (!(actor instanceof L2GuardInstance)) {
            Collection<L2Object> objs = actor.getKnownList().getKnownObjects().values();
            for (L2Object target : objs) {
                L2Character obj = null;
                if (target instanceof L2Character) {
                    obj = (L2Character)target;
                }
                if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj.isDead() || obj != MostHate || obj == actor || obj == this.getAttackTarget()) continue;
                if (obj instanceof L2PcInstance) {
                    if (MostHate != null) {
                        actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                    } else {
                        actor.addDamageHate(obj, 0, 2000);
                    }
                    actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (obj instanceof L2Attackable) {
                    if (actor.getEnemyClan() != null && actor.getEnemyClan().equals(((L2Attackable)obj).getClan())) {
                        actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                        actor.setTarget(obj);
                    }
                    if (actor.getIsChaos() == 0 || ((L2Attackable)obj).getFactionId() != null && ((L2Attackable)obj).getFactionId().equals(actor.getFactionId())) continue;
                    if (MostHate != null) {
                        actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                    } else {
                        actor.addDamageHate(obj, 0, 2000);
                    }
                    actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (!(obj instanceof L2Summon)) continue;
                if (MostHate != null) {
                    actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                } else {
                    actor.addDamageHate(obj, 0, 2000);
                }
                actor.setTarget(obj);
                this.setAttackTarget(obj);
            }
        }
    }

    private void aggroReconsider() {
        L2Attackable actor = this.getActiveChar();
        L2Character MostHate = actor.getMostHated();
        if (actor.getHateList() != null) {
            int rand = Rnd.get(actor.getHateList().size());
            int count = 0;
            for (L2Character obj : actor.getHateList()) {
                if (count < rand) {
                    ++count;
                    continue;
                }
                if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj.isDead() || obj == this.getAttackTarget() || obj == actor) continue;
                try {
                    actor.setTarget(this.getAttackTarget());
                }
                catch (NullPointerException e) {
                    continue;
                }
                if (MostHate != null) {
                    actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                } else {
                    actor.addDamageHate(obj, 0, 2000);
                }
                actor.setTarget(obj);
                this.setAttackTarget(obj);
                return;
            }
        }
        if (!(actor instanceof L2GuardInstance)) {
            Collection<L2Object> objs = actor.getKnownList().getKnownObjects().values();
            for (L2Object target : objs) {
                L2Character obj;
                obj = null;
                if (!(target instanceof L2Character) || (obj = (L2Character)target) == null || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj.isDead() || obj != MostHate || obj == actor) continue;
                if (obj instanceof L2PcInstance) {
                    if (MostHate != null && !MostHate.isDead()) {
                        actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                    } else {
                        actor.addDamageHate(obj, 0, 2000);
                    }
                    actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (obj instanceof L2Attackable) {
                    if (actor.getEnemyClan() != null && actor.getEnemyClan().equals(((L2Attackable)obj).getClan())) {
                        if (MostHate != null) {
                            actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                        } else {
                            actor.addDamageHate(obj, 0, 2000);
                        }
                        actor.setTarget(obj);
                    }
                    if (actor.getIsChaos() == 0 || ((L2Attackable)obj).getFactionId() != null && ((L2Attackable)obj).getFactionId().equals(actor.getFactionId())) continue;
                    if (MostHate != null) {
                        actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                    } else {
                        actor.addDamageHate(obj, 0, 2000);
                    }
                    actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (!(obj instanceof L2Summon)) continue;
                if (MostHate != null) {
                    actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                } else {
                    actor.addDamageHate(obj, 0, 2000);
                }
                actor.setTarget(obj);
                this.setAttackTarget(obj);
            }
        }
    }

    private void lSkillRender() {
        if (this._skillrender._Lrangeskills == null) {
            this._skillrender._Lrangeskills = this.getActiveChar().getLrangeSkill();
        }
    }

    private void sSkillRender() {
        if (this._skillrender._Srangeskills == null) {
            this._skillrender._Srangeskills = this.getActiveChar().getSrangeSkill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onEvtThink() {
        if (this._thinking) return;
        if (this.getActiveChar().isAllSkillsDisabled()) {
            return;
        }
        this._thinking = true;
        try {
            switch (this.getIntention()) {
                case AI_INTENTION_ACTIVE: {
                    this.thinkActive();
                    return;
                }
                case AI_INTENTION_ATTACK: {
                    this.thinkAttack();
                    return;
                }
                case AI_INTENTION_CAST: {
                    this.thinkCast();
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this + " -  onEvtThink() failed: " + e.getMessage(), e);
            return;
        }
        finally {
            this._thinking = false;
        }
    }

    @Override
    protected void onEvtAttacked(L2Character attacker) {
        L2Attackable me = this.getActiveChar();
        this._attackTimeout = 1200 + GameTimeController.getGameTicks();
        if (this._globalAggro < 0) {
            this._globalAggro = 0;
        }
        me.addDamageHate(attacker, 0, 1);
        if (!me.isRunning()) {
            me.setRunning();
        }
        if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, attacker);
        } else if (me.getMostHated() != this.getAttackTarget()) {
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, attacker);
        }
        if (me instanceof L2MonsterInstance) {
            L2MonsterInstance master = (L2MonsterInstance)me;
            if (master.hasMinions()) {
                master.getMinionList().onAssist(me, attacker);
            }
            if ((master = master.getLeader()) != null && master.hasMinions()) {
                master.getMinionList().onAssist(me, attacker);
            }
        }
        super.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtAggression(L2Character target, int aggro) {
        L2Attackable me = this.getActiveChar();
        if (me.isDead()) {
            return;
        }
        if (target != null) {
            me.addDamageHate(target, 0, aggro);
            if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
                if (!me.isRunning()) {
                    me.setRunning();
                }
                this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
            }
            if (me instanceof L2MonsterInstance) {
                L2MonsterInstance master = (L2MonsterInstance)me;
                if (master.hasMinions()) {
                    master.getMinionList().onAssist(me, target);
                }
                if ((master = master.getLeader()) != null && master.hasMinions()) {
                    master.getMinionList().onAssist(me, target);
                }
            }
        }
    }

    @Override
    protected void onIntentionActive() {
        this._attackTimeout = Integer.MAX_VALUE;
        super.onIntentionActive();
    }

    public void setGlobalAggro(int value) {
        this._globalAggro = value;
    }

    public void setTimepass(int TP) {
        this.timepass = TP;
    }

    public int getTimepass() {
        return this.timepass;
    }

    public L2Attackable getActiveChar() {
        return (L2Attackable)this._actor;
    }
}

