/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.communitybbs.Manager.favorite;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.communitybbs.Manager.favorite.BaseFavoriteManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2MapRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.type.L2JailZone;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.logging.Logger;

public class RepairChar
extends BaseFavoriteManager {
    private static Logger _log = Logger.getLogger(RepairChar.class.getName());
    private static RepairChar _instance = new RepairChar();
    private static final boolean CUSTOM_CHARA_REPAIR_NEAREST_TOWN = true;

    public static RepairChar getInstance() {
        return _instance;
    }

    @Override
    public void parsecmd(String command, L2PcInstance activeChar) {
        String arg = this.getArgs(command);
        if (arg.equals("_menu")) {
            this.showRepairCharList(activeChar);
        } else if (arg.matches("\\d+")) {
            int obj_id = Integer.parseInt(arg);
            this.doRepairChar(activeChar, obj_id);
        }
    }

    @Override
    public void parsewrite(String ar1, String ar2, String ar3, String ar4, String ar5, L2PcInstance activeChar) {
    }

    private void showRepairCharList(L2PcInstance activeChar) {
        String html = HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/CommunityBoard/repair_char/repairCharList.htm");
        StringBuilder charList = new StringBuilder(256);
        if (activeChar.getAccountChars().size() == 0) {
            charList.append("\u5fa9\u65e7\u53ef\u80fd\u306a\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        } else {
            charList.append("\u5fa9\u65e7\u3057\u305f\u3044\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044\u3002<br1>");
            charList.append("\uff1c\u6ce8\u610f\uff1e\u5fa9\u65e7\u5834\u6240\u306f\u3001\u6700\u5bc4\u306e\u6751\u3068\u306a\u3063\u3066\u3044\u307e\u3059\u3002<br>");
            for (Map.Entry<Integer, String> chars : activeChar.getAccountChars().entrySet()) {
                int obj_Id = chars.getKey();
                String char_name = chars.getValue();
                charList.append("<a action=\"bypass _bbsgetfav;repair_char;").append(obj_Id).append("\">");
                charList.append(char_name);
                charList.append("</a>&nbsp;");
            }
        }
        html = html.replace("%charList%", charList.toString());
        this.separateAndSend(html, activeChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRepairChar(L2PcInstance activeChar, int obj_id) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            int nx = Config.CUSTOM_CHARA_REPAIR_LOC[0];
            int ny = Config.CUSTOM_CHARA_REPAIR_LOC[1];
            int nz = Config.CUSTOM_CHARA_REPAIR_LOC[2];
            PreparedStatement statement = con.prepareStatement("SELECT x,y,z,pkkills,accesslevel FROM characters WHERE charId=?");
            statement.setInt(1, obj_id);
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                if (rs.getInt("accesslevel") < 0) {
                    this.showMessage(activeChar, "\u5fa9\u65e7\u3067\u304d\u306a\u3044\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u3067\u3059\u3002");
                    return;
                }
                int x = rs.getInt("x");
                int y = rs.getInt("y");
                int z = rs.getInt("z");
                L2MapRegion mr = MapRegionManager.getInstance().getClosestTown(x, y);
                if (mr == null) {
                    mr = MapRegionManager.getInstance().getMapRegion(146494, 30584);
                }
                Location loc = mr.getSpawnLoc();
                nx = loc.getX();
                ny = loc.getY();
                nz = loc.getZ();
                if (rs.getInt("pkkills") > 5) {
                    nx = 17817;
                    ny = 170079;
                    nz = -3530;
                }
                for (L2ZoneType zone : ZoneManager.getInstance().getAllZones()) {
                    if (!(zone instanceof L2JailZone) || !zone.isInsideZone(x, y, z)) continue;
                    nx = x;
                    ny = y;
                    nz = z;
                    break;
                }
            }
            rs.close();
            statement.close();
            statement = con.prepareStatement("UPDATE characters SET x=?,y=?,z=? WHERE charId=?");
            statement.setInt(1, nx);
            statement.setInt(2, ny);
            statement.setInt(3, nz);
            statement.setInt(4, obj_id);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM character_skills_save WHERE charId=?");
            statement.setInt(1, obj_id);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("UPDATE items SET loc='INVENTORY', loc_data=0 WHERE owner_id=? AND loc='PAPERDOLL'");
            statement.setInt(1, obj_id);
            statement.execute();
            statement.close();
            this.showMessage(activeChar, "\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u5fa9\u65e7\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            _log.info(activeChar.getAccountName() + " \u304c\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u3092\u5fa9\u65e7\u3057\u307e\u3057\u305f\u3002");
        }
        catch (Exception e) {
            this.showMessage(activeChar, "\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u5fa9\u65e7\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            _log.info("Error could not repair char: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }
}

