/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ExperienceTable {
    private static Logger _log = Logger.getLogger(ExperienceTable.class.getName());
    private byte MAX_LEVEL;
    private byte MAX_PET_LEVEL;
    private long[] _expTable;

    public static ExperienceTable getInstance() {
        return SingletonHolder._instance;
    }

    private ExperienceTable() {
        this.loadTable();
    }

    private void loadTable() {
        File xml = new File(Config.DATAPACK_ROOT, "data/stats/experience.xml");
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        if (xml.exists()) {
            try {
                doc = factory.newDocumentBuilder().parse(xml);
            }
            catch (IOException e) {
                _log.log(Level.WARNING, "Could not read experience.xml table: " + e.getMessage(), e);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not parse experience.xml table: " + e.getMessage(), e);
            }
            Node table = doc.getFirstChild();
            NamedNodeMap tableAttr = table.getAttributes();
            this.MAX_LEVEL = (byte)(Byte.parseByte(tableAttr.getNamedItem("maxLevel").getNodeValue()) + 1);
            this.MAX_PET_LEVEL = (byte)(Byte.parseByte(tableAttr.getNamedItem("maxPetLevel").getNodeValue()) + 1);
            this._expTable = new long[Math.max(this.MAX_LEVEL, this.MAX_PET_LEVEL) + 1];
            int count = 0;
            for (Node experience = table.getFirstChild(); experience != null; experience = experience.getNextSibling()) {
                long exp;
                if (!experience.getNodeName().equals("experience")) continue;
                NamedNodeMap attrs = experience.getAttributes();
                int level = Integer.parseInt(attrs.getNamedItem("level").getNodeValue());
                this._expTable[level] = exp = Long.parseLong(attrs.getNamedItem("tolevel").getNodeValue());
                ++count;
            }
            _log.info("ExperienceTable: Loaded " + count + " levels");
            _log.info("ExperienceTable: Max Player Level is: " + (this.MAX_LEVEL - 1));
            _log.info("ExperienceTable: Max Pet Level is: " + (this.MAX_PET_LEVEL - 1));
        } else {
            _log.warning("ExperienceTable: experience.xml not found!");
        }
    }

    public long getExpForLevel(int level) {
        return this._expTable[level];
    }

    public byte getMaxLevel() {
        return this.MAX_LEVEL;
    }

    public byte getMaxPetLevel() {
        return this.MAX_PET_LEVEL;
    }

    private static class SingletonHolder {
        protected static final ExperienceTable _instance = new ExperienceTable();

        private SingletonHolder() {
        }
    }
}

