/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import gnu.trove.TObjectProcedure;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class L2CastleTeleporterInstance
extends L2Npc {
    public static final Logger _log = Logger.getLogger(L2CastleTeleporterInstance.class.getName());
    private boolean _currentTask = false;

    public L2CastleTeleporterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2CastleTeleporterInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        StringTokenizer st = new StringTokenizer(command, " ");
        String actualCommand = st.nextToken();
        if (actualCommand.equalsIgnoreCase("tele")) {
            if (!this.getTask()) {
                int delay = this.getCastle().getSiege().getIsInProgress() && this.getCastle().getSiege().getControlTowerCount() == 0 ? 480000 : 30000;
                this.setTask(true);
                ThreadPoolManager.getInstance().scheduleGeneral(new oustAllPlayers(), delay);
            }
            String filename = "data/html/castleteleporter/MassGK-1.htm";
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(player.getHtmlPrefix(), filename);
            player.sendPacket(html);
            return;
        }
        super.onBypassFeedback(player, command);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        String filename = !this.getTask() ? (this.getCastle().getSiege().getIsInProgress() && this.getCastle().getSiege().getControlTowerCount() == 0 ? "data/html/castleteleporter/MassGK-2.htm" : "data/html/castleteleporter/MassGK.htm") : "data/html/castleteleporter/MassGK-1.htm";
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(html);
    }

    void oustAllPlayers() {
        this.getCastle().oustAllPlayers();
    }

    public boolean getTask() {
        return this._currentTask;
    }

    public void setTask(boolean state) {
        this._currentTask = state;
    }

    private final class ForEachPlayerInRegionSendPacket
    implements TObjectProcedure<L2PcInstance> {
        int _region;
        NpcSay _cs;

        private ForEachPlayerInRegionSendPacket(int region, NpcSay cs) {
            this._region = region;
            this._cs = cs;
        }

        public final boolean execute(L2PcInstance player) {
            if (this._region == MapRegionManager.getInstance().getMapRegionLocId(player.getX(), player.getY())) {
                player.sendPacket(this._cs);
            }
            return true;
        }
    }

    class oustAllPlayers
    implements Runnable {
        oustAllPlayers() {
        }

        @Override
        public void run() {
            try {
                NpcSay cs = new NpcSay(L2CastleTeleporterInstance.this.getObjectId(), 1, L2CastleTeleporterInstance.this.getNpcId(), NpcStringId.THE_DEFENDERS_OF_S1_CASTLE_WILL_BE_TELEPORTED_TO_THE_INNER_CASTLE).addString(L2CastleTeleporterInstance.this.getCastle().getName());
                int region = MapRegionManager.getInstance().getMapRegionLocId(L2CastleTeleporterInstance.this.getX(), L2CastleTeleporterInstance.this.getY());
                L2World.getInstance().forEachPlayer(new ForEachPlayerInRegionSendPacket(region, cs));
                L2CastleTeleporterInstance.this.oustAllPlayers();
                L2CastleTeleporterInstance.this.setTask(false);
            }
            catch (NullPointerException e) {
                _log.log(Level.WARNING, "" + e.getMessage(), e);
            }
        }
    }
}

