/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.Race;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.ShowCalculator;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.SkillHolder;
import com.l2jserver.gameserver.templates.item.L2ArmorType;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class UseItem
extends L2GameClientPacket {
    private static final String _C__19_USEITEM = "[C] 19 UseItem";
    private static Logger _log = Logger.getLogger(UseItem.class.getName());
    private int _objectId;
    private boolean _ctrlPressed;
    private int _itemId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._ctrlPressed = this.readD() != 0;
    }

    @Override
    protected void runImpl() {
        SkillHolder[] sHolders;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getUseItem().tryPerformAction("use item")) {
            return;
        }
        if (activeChar.getActiveTradeList() != null) {
            activeChar.cancelActiveTrade();
        }
        if (activeChar.getPrivateStoreType() != 0) {
            activeChar.sendPacket(SystemMessageId.CANNOT_TRADE_DISCARD_DROP_ITEM_WHILE_IN_SHOPMODE);
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2ItemInstance item = activeChar.getInventory().getItemByObjectId(this._objectId);
        if (item == null) {
            return;
        }
        if (item.getItem().getType2() == 3) {
            activeChar.sendPacket(SystemMessageId.CANNOT_USE_QUEST_ITEMS);
            return;
        }
        if (activeChar.isStunned() || activeChar.isParalyzed() || activeChar.isSleeping() || activeChar.isAfraid() || activeChar.isAlikeDead()) {
            return;
        }
        if (activeChar.isDead()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addItemName(item);
            activeChar.sendPacket(sm);
            return;
        }
        if (!item.isEquipped() && !item.getItem().checkCondition(activeChar, activeChar, true)) {
            return;
        }
        if (!activeChar.getInventory().canManipulateWithItemId(item.getItemId())) {
            activeChar.sendMessage("Cannot use this item.");
            return;
        }
        this._itemId = item.getItemId();
        if (activeChar.isFishing() && (this._itemId < 6535 || this._itemId > 6540)) {
            activeChar.sendPacket(SystemMessageId.CANNOT_DO_WHILE_FISHING_3);
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_TELEPORT && activeChar.getKarma() > 0 && (sHolders = item.getItem().getSkills()) != null) {
            for (SkillHolder sHolder : sHolders) {
                L2Skill skill = sHolder.getSkill();
                if (skill == null || skill.getSkillType() != L2SkillType.TELEPORT && skill.getSkillType() != L2SkillType.RECALL) continue;
                return;
            }
        }
        if (Config.DEBUG) {
            _log.log(Level.INFO, activeChar.getObjectId() + ": use item " + this._objectId);
        }
        if (item.isEquipable()) {
            if (activeChar.isInOlympiadMode() && (item.isHeroItem() || item.isOlyRestrictedItem())) {
                activeChar.sendPacket(SystemMessageId.THIS_ITEM_CANT_BE_EQUIPPED_FOR_THE_OLYMPIAD_EVENT);
                return;
            }
            if (activeChar.isCursedWeaponEquipped() && this._itemId == 6408) {
                return;
            }
            if (FortSiegeManager.getInstance().isCombat(item.getItemId())) {
                return;
            }
            if (activeChar.isCombatFlagEquipped()) {
                return;
            }
            switch (item.getItem().getBodyPart()) {
                case 128: 
                case 256: 
                case 16384: {
                    if (activeChar.getActiveWeaponItem() != null && activeChar.getActiveWeaponItem().getItemId() == 9819) {
                        activeChar.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                        return;
                    }
                    if (activeChar.isCastingNow() || activeChar.isCastingSimultaneouslyNow()) {
                        activeChar.sendPacket(SystemMessageId.CANNOT_CHANGE_WEAPON_DURING_AN_ATTACK);
                        return;
                    }
                    if (activeChar.isMounted()) {
                        activeChar.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                        return;
                    }
                    if (activeChar.isDisarmed()) {
                        activeChar.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                        return;
                    }
                    if (activeChar.isCursedWeaponEquipped()) {
                        return;
                    }
                    if (item.isEquipped() || !(item.getItem() instanceof L2Weapon) || activeChar.isGM()) break;
                    L2Weapon wpn = (L2Weapon)item.getItem();
                    switch (activeChar.getRace()) {
                        case Kamael: {
                            switch (wpn.getItemType()) {
                                case NONE: {
                                    activeChar.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                                    return;
                                }
                            }
                            break;
                        }
                        case Human: 
                        case Dwarf: 
                        case Elf: 
                        case DarkElf: 
                        case Orc: {
                            switch (wpn.getItemType()) {
                                case RAPIER: 
                                case CROSSBOW: 
                                case ANCIENTSWORD: {
                                    activeChar.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                                    return;
                                }
                            }
                        }
                    }
                    break;
                }
                case 64: 
                case 512: 
                case 1024: 
                case 2048: 
                case 4096: 
                case 8192: 
                case 32768: {
                    if (activeChar.getRace() != Race.Kamael || item.getItem().getItemType() != L2ArmorType.HEAVY && item.getItem().getItemType() != L2ArmorType.MAGIC) break;
                    activeChar.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                    return;
                }
                case 0x400000: {
                    if (item.isEquipped() || activeChar.getInventory().getMaxTalismanCount() != 0) break;
                    activeChar.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
                    return;
                }
            }
            if (activeChar.isAttackingNow()) {
                ThreadPoolManager.getInstance().scheduleGeneral(new WeaponEquipTask(item, activeChar), (activeChar.getAttackEndTime() - GameTimeController.getGameTicks()) * 100);
                return;
            }
            activeChar.useEquippableItem(item, true);
        } else {
            if (activeChar.isCastingNow() && !item.isPotion() && !item.isElixir()) {
                return;
            }
            L2Weapon weaponItem = activeChar.getActiveWeaponItem();
            int itemid = item.getItemId();
            if (itemid == 4393) {
                activeChar.sendPacket(new ShowCalculator(4393));
            } else {
                if (weaponItem != null && weaponItem.getItemType() == L2WeaponType.FISHINGROD && (itemid >= 6519 && itemid <= 6527 || itemid >= 7610 && itemid <= 7613 || itemid >= 7807 && itemid <= 7809 || itemid >= 8484 && itemid <= 8486 || itemid >= 8505 && itemid <= 8513)) {
                    activeChar.getInventory().setPaperdollItem(7, item);
                    activeChar.broadcastUserInfo();
                    this.sendPacket(new ItemList(activeChar, false));
                    return;
                }
                IItemHandler handler = ItemHandler.getInstance().getItemHandler(item.getEtcItem());
                if (handler != null) {
                    handler.useItem(activeChar, item, this._ctrlPressed);
                } else if (Config.DEBUG) {
                    _log.log(Level.WARNING, "No item handler registered for item ID " + item.getItemId() + ".");
                }
            }
        }
    }

    @Override
    public String getType() {
        return _C__19_USEITEM;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return !Config.SPAWN_PROTECTION_ALLOWED_ITEMS.contains(this._itemId);
    }

    public static class WeaponEquipTask
    implements Runnable {
        L2ItemInstance item;
        L2PcInstance activeChar;

        public WeaponEquipTask(L2ItemInstance it, L2PcInstance character) {
            this.item = it;
            this.activeChar = character;
        }

        @Override
        public void run() {
            if (this.activeChar.isAttackingNow()) {
                return;
            }
            this.activeChar.useEquippableItem(this.item, false);
        }
    }
}

