/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2EffectPointInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;

public class EffectSignetAntiSummon
extends L2Effect {
    private L2EffectPointInstance _actor;

    public EffectSignetAntiSummon(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.SIGNET_GROUND;
    }

    @Override
    public boolean onStart() {
        this._actor = (L2EffectPointInstance)this.getEffected();
        return true;
    }

    @Override
    public boolean onActionTime() {
        if (this.getCount() == this.getTotalCount() - 1) {
            return true;
        }
        int mpConsume = this.getSkill().getMpConsume();
        L2PcInstance caster = (L2PcInstance)this.getEffector();
        for (L2Character cha : this._actor.getKnownList().getKnownCharactersInRadius(this.getSkill().getSkillRadius())) {
            if (cha == null || !(cha instanceof L2Playable) || !caster.canAttackCharacter(cha)) continue;
            L2PcInstance owner = null;
            owner = cha instanceof L2Summon ? ((L2Summon)cha).getOwner() : (L2PcInstance)cha;
            if (owner == null || owner.getPet() == null) continue;
            if ((double)mpConsume > this.getEffector().getCurrentMp()) {
                this.getEffector().sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SKILL_REMOVED_DUE_LACK_MP));
                return false;
            }
            this.getEffector().reduceCurrentMp(mpConsume);
            owner.getPet().unSummon(owner);
            owner.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, this.getEffector());
        }
        return true;
    }

    @Override
    public void onExit() {
        if (this._actor != null) {
            this._actor.deleteMe();
        }
    }
}

