/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.l2skills;

import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeFlagInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.templates.StatsSet;
import java.util.logging.Level;

public class L2SkillSiegeFlag
extends L2Skill {
    private final boolean _isAdvanced;
    private final boolean _isOutpost;

    public L2SkillSiegeFlag(StatsSet set) {
        super(set);
        this._isAdvanced = set.getBool("isAdvanced", false);
        this._isOutpost = set.getBool("isOutpost", false);
    }

    @Override
    public void useSkill(L2Character activeChar, L2Object[] targets) {
        if (!(activeChar instanceof L2PcInstance)) {
            return;
        }
        L2PcInstance player = (L2PcInstance)activeChar;
        if (player.getClan() == null || player.getClan().getLeaderId() != player.getObjectId()) {
            return;
        }
        if (!L2SkillSiegeFlag.checkIfOkToPlaceFlag((L2Character)player, true, this._isOutpost)) {
            return;
        }
        if (TerritoryWarManager.getInstance().isTWInProgress()) {
            try {
                L2SiegeFlagInstance flag = new L2SiegeFlagInstance(player, IdFactory.getInstance().getNextId(), NpcTable.getInstance().getTemplate(this._isOutpost ? 36590 : 35062), this._isAdvanced, this._isOutpost);
                flag.setTitle(player.getClan().getName());
                flag.setCurrentHpMp(flag.getMaxHp(), flag.getMaxMp());
                flag.setHeading(player.getHeading());
                flag.spawnMe(player.getX(), player.getY(), player.getZ() + 50);
                if (this._isOutpost) {
                    TerritoryWarManager.getInstance().setHQForClan(player.getClan(), flag);
                } else {
                    TerritoryWarManager.getInstance().addClanFlag(player.getClan(), flag);
                }
            }
            catch (Exception e) {
                player.sendMessage("Error placing flag: " + e);
                _log.log(Level.WARNING, "Error placing flag: " + e.getMessage(), e);
            }
            return;
        }
        try {
            L2SiegeFlagInstance flag = new L2SiegeFlagInstance(player, IdFactory.getInstance().getNextId(), NpcTable.getInstance().getTemplate(35062), this._isAdvanced, false);
            flag.setTitle(player.getClan().getName());
            flag.setCurrentHpMp(flag.getMaxHp(), flag.getMaxMp());
            flag.setHeading(player.getHeading());
            flag.spawnMe(player.getX(), player.getY(), player.getZ() + 50);
            Castle castle = CastleManager.getInstance().getCastle(activeChar);
            Fort fort = FortManager.getInstance().getFort(activeChar);
            if (castle != null) {
                castle.getSiege().getFlag(player.getClan()).add(flag);
            } else {
                fort.getSiege().getFlag(player.getClan()).add(flag);
            }
        }
        catch (Exception e) {
            player.sendMessage("Error placing flag:" + e);
            _log.log(Level.WARNING, "Error placing flag: " + e.getMessage(), e);
        }
    }

    public static boolean checkIfOkToPlaceFlag(L2Character activeChar, boolean isCheckOnly, boolean isOutPost) {
        if (TerritoryWarManager.getInstance().isTWInProgress()) {
            return L2SkillSiegeFlag.checkIfOkToPlaceHQ(activeChar, isCheckOnly, isOutPost);
        }
        if (isOutPost) {
            return false;
        }
        Castle castle = CastleManager.getInstance().getCastle(activeChar);
        Fort fort = FortManager.getInstance().getFort(activeChar);
        if (castle == null && fort == null) {
            return false;
        }
        if (castle != null) {
            return L2SkillSiegeFlag.checkIfOkToPlaceFlag(activeChar, castle, isCheckOnly);
        }
        return L2SkillSiegeFlag.checkIfOkToPlaceFlag(activeChar, fort, isCheckOnly);
    }

    public static boolean checkIfOkToPlaceFlag(L2Character activeChar, Castle castle, boolean isCheckOnly) {
        if (!(activeChar instanceof L2PcInstance)) {
            return false;
        }
        String text = "";
        L2PcInstance player = (L2PcInstance)activeChar;
        if (castle == null || castle.getCastleId() <= 0) {
            text = "You must be on castle ground to place a flag.";
        } else if (!castle.getSiege().getIsInProgress()) {
            text = "You can only place a flag during a siege.";
        } else if (castle.getSiege().getAttackerClan(player.getClan()) == null) {
            text = "You must be an attacker to place a flag.";
        } else if (!player.isClanLeader()) {
            text = "You must be a clan leader to place a flag.";
        } else if (castle.getSiege().getAttackerClan(player.getClan()).getNumFlags() >= SiegeManager.getInstance().getFlagMaxCount()) {
            text = "You have already placed the maximum number of flags possible.";
        } else if (player.isInsideZone((byte)17)) {
            text = "You cannot place flag here.";
        } else {
            return true;
        }
        if (!isCheckOnly) {
            player.sendMessage(text);
        }
        return false;
    }

    public static boolean checkIfOkToPlaceFlag(L2Character activeChar, Fort fort, boolean isCheckOnly) {
        if (!(activeChar instanceof L2PcInstance)) {
            return false;
        }
        String text = "";
        L2PcInstance player = (L2PcInstance)activeChar;
        if (fort == null || fort.getFortId() <= 0) {
            text = "You must be on fort ground to place a flag.";
        } else if (!fort.getSiege().getIsInProgress()) {
            text = "You can only place a flag during a siege.";
        } else if (fort.getSiege().getAttackerClan(player.getClan()) == null) {
            text = "You must be an attacker to place a flag.";
        } else if (!player.isClanLeader()) {
            text = "You must be a clan leader to place a flag.";
        } else if (fort.getSiege().getAttackerClan(player.getClan()).getNumFlags() >= FortSiegeManager.getInstance().getFlagMaxCount()) {
            text = "You have already placed the maximum number of flags possible.";
        } else if (player.isInsideZone((byte)17)) {
            text = "You cannot place flag here.";
        } else {
            return true;
        }
        if (!isCheckOnly) {
            player.sendMessage(text);
        }
        return false;
    }

    public static boolean checkIfOkToPlaceHQ(L2Character activeChar, boolean isCheckOnly, boolean isOutPost) {
        Castle castle = CastleManager.getInstance().getCastle(activeChar);
        Fort fort = FortManager.getInstance().getFort(activeChar);
        if (castle == null && fort == null) {
            return false;
        }
        String text = "";
        L2PcInstance player = (L2PcInstance)activeChar;
        if (fort != null && fort.getFortId() == 0 || castle != null && castle.getCastleId() == 0) {
            text = "You must be on fort or castle ground to construct an outpost or flag.";
        } else if (fort != null && !fort.getZone().isActive() || castle != null && !castle.getZone().isActive()) {
            text = "You can only construct an outpost or flag on siege field.";
        } else if (!player.isClanLeader()) {
            text = "You must be a clan leader to construct an outpost or flag.";
        } else if (TerritoryWarManager.getInstance().getHQForClan(player.getClan()) != null && isOutPost) {
            text = "You can have only one outpost.";
        } else if (TerritoryWarManager.getInstance().getFlagForClan(player.getClan()) != null && !isOutPost) {
            text = "You can have only one flag.";
        } else if (player.isInsideZone((byte)17)) {
            text = "You cannot construct outpost or flag here.";
        } else {
            return true;
        }
        if (!isCheckOnly) {
            player.sendMessage(text);
        }
        return false;
    }
}

