/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.l2skills;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ExperienceTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantSummonInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeSummonInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2SkillSummon
extends L2Skill {
    public static final int SKILL_CUBIC_MASTERY = 143;
    private int _npcId;
    private float _expPenalty;
    private final boolean _isCubic;
    private final int _activationtime;
    private final int _activationchance;
    private final int _maxcount;
    private final int _summonTotalLifeTime;
    private final int _summonTimeLostIdle;
    private final int _summonTimeLostActive;
    private final int _itemConsumeTime;
    private final int _itemConsumeOT;
    private final int _itemConsumeIdOT;
    private final int _itemConsumeSteps;

    public L2SkillSummon(StatsSet set) {
        super(set);
        this._npcId = set.getInteger("npcId", 0);
        this._expPenalty = set.getFloat("expPenalty", 0.0f);
        this._isCubic = set.getBool("isCubic", false);
        this._activationtime = set.getInteger("activationtime", 8);
        this._activationchance = set.getInteger("activationchance", 30);
        this._maxcount = set.getInteger("maxcount", -1);
        this._summonTotalLifeTime = set.getInteger("summonTotalLifeTime", 1200000);
        this._summonTimeLostIdle = set.getInteger("summonTimeLostIdle", 0);
        this._summonTimeLostActive = set.getInteger("summonTimeLostActive", 0);
        this._itemConsumeOT = set.getInteger("itemConsumeCountOT", 0);
        this._itemConsumeIdOT = set.getInteger("itemConsumeIdOT", 0);
        this._itemConsumeTime = set.getInteger("itemConsumeTime", 0);
        this._itemConsumeSteps = set.getInteger("itemConsumeSteps", 0);
    }

    public boolean checkCondition(L2Character activeChar) {
        if (activeChar instanceof L2PcInstance) {
            L2PcInstance player = (L2PcInstance)activeChar;
            if (this.isCubic()) {
                int count;
                if (this.getTargetType() != L2Skill.SkillTargetType.TARGET_SELF) {
                    return true;
                }
                int mastery = player.getSkillLevel(143);
                if (mastery < 0) {
                    mastery = 0;
                }
                if ((count = player.getCubics().size()) > mastery) {
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CUBIC_SUMMONING_FAILED));
                    return false;
                }
            } else {
                if (player.inObserverMode()) {
                    return false;
                }
                if (player.getPet() != null) {
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_ALREADY_HAVE_A_PET));
                    return false;
                }
            }
        }
        return super.checkCondition(activeChar, null, false);
    }

    @Override
    public void useSkill(L2Character caster, L2Object[] targets) {
        if (caster.isAlikeDead() || !(caster instanceof L2PcInstance)) {
            return;
        }
        L2PcInstance activeChar = (L2PcInstance)caster;
        if (this._npcId == 0) {
            activeChar.sendMessage("Summon skill " + this.getId() + " not described yet");
            return;
        }
        if (this._isCubic) {
            int _cubicSkillLevel = this.getLevel();
            if (_cubicSkillLevel > 100) {
                _cubicSkillLevel = Math.round((this.getLevel() - 100) / 7 + 8);
            }
            if (targets.length > 1) {
                for (L2Object obj : targets) {
                    if (!(obj instanceof L2PcInstance)) continue;
                    L2PcInstance player = (L2PcInstance)obj;
                    int mastery = player.getSkillLevel(143);
                    if (mastery < 0) {
                        mastery = 0;
                    }
                    if (mastery == 0 && !player.getCubics().isEmpty()) {
                        for (L2CubicInstance c : player.getCubics().getValues(new L2CubicInstance[player.getCubics().size()])) {
                            c.stopAction();
                            c = null;
                        }
                        player.getCubics().clear();
                    }
                    if (player.getCubics().containsKey(this._npcId)) {
                        L2CubicInstance cubic = player.getCubic(this._npcId);
                        cubic.stopAction();
                        cubic.cancelDisappear();
                        player.delCubic(this._npcId);
                    }
                    if (player.getCubics().size() > mastery) continue;
                    if (player == activeChar) {
                        player.addCubic(this._npcId, _cubicSkillLevel, this.getPower(), this._activationtime, this._activationchance, this._maxcount, this._summonTotalLifeTime, false);
                    } else {
                        player.addCubic(this._npcId, _cubicSkillLevel, this.getPower(), this._activationtime, this._activationchance, this._maxcount, this._summonTotalLifeTime, true);
                    }
                    player.broadcastUserInfo();
                }
                return;
            }
            int mastery = activeChar.getSkillLevel(143);
            if (mastery < 0) {
                mastery = 0;
            }
            if (activeChar.getCubics().containsKey(this._npcId)) {
                L2CubicInstance cubic = activeChar.getCubic(this._npcId);
                cubic.stopAction();
                cubic.cancelDisappear();
                activeChar.delCubic(this._npcId);
            }
            if (activeChar.getCubics().size() > mastery) {
                if (Config.DEBUG) {
                    _log.fine("player can't summon any more cubics. ignore summon skill");
                }
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CUBIC_SUMMONING_FAILED));
                return;
            }
            activeChar.addCubic(this._npcId, _cubicSkillLevel, this.getPower(), this._activationtime, this._activationchance, this._maxcount, this._summonTotalLifeTime, false);
            activeChar.broadcastUserInfo();
            return;
        }
        if (activeChar.getPet() != null || activeChar.isMounted()) {
            if (Config.DEBUG) {
                _log.fine("player has a pet already. ignore summon skill");
            }
            return;
        }
        L2NpcTemplate summonTemplate = NpcTable.getInstance().getTemplate(this._npcId);
        if (summonTemplate == null) {
            _log.warning("Summon attempt for nonexisting NPC ID:" + this._npcId + ", skill ID:" + this.getId());
            return;
        }
        L2SummonInstance summon = summonTemplate.type.equalsIgnoreCase("L2SiegeSummon") ? new L2SiegeSummonInstance(IdFactory.getInstance().getNextId(), summonTemplate, activeChar, this) : (summonTemplate.type.equalsIgnoreCase("L2MerchantSummon") ? new L2MerchantSummonInstance(IdFactory.getInstance().getNextId(), summonTemplate, activeChar, this) : new L2SummonInstance(IdFactory.getInstance().getNextId(), summonTemplate, activeChar, this));
        summon.setName(summonTemplate.name);
        summon.setTitle(activeChar.getName());
        summon.setExpPenalty(this._expPenalty);
        if (summon.getLevel() >= ExperienceTable.getInstance().getMaxPetLevel()) {
            summon.getStat().setExp(ExperienceTable.getInstance().getExpForLevel(ExperienceTable.getInstance().getMaxPetLevel() - 1));
            _log.warning("Summon (" + summon.getName() + ") NpcID: " + summon.getNpcId() + " has a level above " + ExperienceTable.getInstance().getMaxPetLevel() + ". Please rectify.");
        } else {
            summon.getStat().setExp(ExperienceTable.getInstance().getExpForLevel(summon.getLevel() % ExperienceTable.getInstance().getMaxPetLevel()));
        }
        summon.setCurrentHp(summon.getMaxHp());
        summon.setCurrentMp(summon.getMaxMp());
        summon.setHeading(activeChar.getHeading());
        summon.setRunning();
        if (!(summon instanceof L2MerchantSummonInstance)) {
            activeChar.setPet(summon);
        }
        summon.spawnMe(activeChar.getX() + 20, activeChar.getY() + 20, activeChar.getZ());
    }

    public final boolean isCubic() {
        return this._isCubic;
    }

    public final int getTotalLifeTime() {
        return this._summonTotalLifeTime;
    }

    public final int getTimeLostIdle() {
        return this._summonTimeLostIdle;
    }

    public final int getTimeLostActive() {
        return this._summonTimeLostActive;
    }

    public final int getItemConsumeOT() {
        return this._itemConsumeOT;
    }

    public final int getItemConsumeIdOT() {
        return this._itemConsumeIdOT;
    }

    public final int getItemConsumeSteps() {
        return this._itemConsumeSteps;
    }

    public final int getItemConsumeTime() {
        return this._itemConsumeTime;
    }

    public final int getNpcId() {
        return this._npcId;
    }

    public final float getExpPenalty() {
        return this._expPenalty;
    }
}

