/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.util.L2ObjectMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class L2ObjectHashMap<T extends L2Object>
extends L2ObjectMap<T> {
    private static final boolean TRACE = false;
    private static final boolean DEBUG = false;
    private static final int[] PRIMES = new int[]{5, 7, 11, 17, 23, 29, 37, 47, 59, 71, 89, 107, 131, 163, 197, 239, 293, 353, 431, 521, 631, 761, 919, 1103, 1327, 1597, 1931, 2333, 2801, 3371, 4049, 4861, 5839, 7013, 8419, 10103, 12143, 14591, 17519, 21023, 25229, 30293, 36353, 43627, 52361, 62851, 75431, 90523, 108631, 130363, 156437, 187751, 225307, 270371, 324449, 389357, 467237, 560689, 672827, 807403, 968897, 1162687, 1395263, 1674319, 2009191, 2411033, 2893249, 3471899, 4166287, 4999559, 5999471, 7199369};
    private T[] _table;
    private int[] _keys;
    private int _count;

    private static int getPrime(int min) {
        for (int i = 0; i < PRIMES.length; ++i) {
            if (PRIMES[i] < min) continue;
            return PRIMES[i];
        }
        throw new OutOfMemoryError();
    }

    public L2ObjectHashMap() {
        int size = PRIMES[0];
        this._table = new L2Object[size];
        this._keys = new int[size];
    }

    @Override
    public int size() {
        return this._count;
    }

    @Override
    public boolean isEmpty() {
        return this._count == 0;
    }

    @Override
    public synchronized void clear() {
        int size = PRIMES[0];
        this._table = new L2Object[size];
        this._keys = new int[size];
        this._count = 0;
    }

    private void check() {
    }

    @Override
    public synchronized void put(T obj) {
        if (this._count >= this._table.length / 2) {
            this.expand();
        }
        int hashcode = ((L2Object)obj).getObjectId();
        assert (hashcode > 0);
        int seed = hashcode;
        int incr = 1 + ((seed >> 5) + 1) % (this._table.length - 1);
        int ntry = 0;
        int slot = -1;
        do {
            int pos;
            if (this._table[pos = seed % this._table.length & Integer.MAX_VALUE] == null) {
                if (slot < 0) {
                    slot = pos;
                }
                if (this._keys[pos] >= 0) {
                    this._keys[slot] = hashcode;
                    this._table[slot] = obj;
                    ++this._count;
                    return;
                }
            } else {
                if (this._table[pos] == obj) {
                    return;
                }
                assert (((L2Object)obj).getObjectId() != ((L2Object)this._table[pos]).getObjectId());
                if (slot >= 0 && this._keys[pos] > 0) {
                    int n = slot;
                    this._keys[n] = this._keys[n] | hashcode;
                    this._table[slot] = obj;
                    ++this._count;
                    return;
                }
            }
            int n = pos;
            this._keys[n] = this._keys[n] | Integer.MIN_VALUE;
            seed += incr;
        } while (++ntry < this._table.length);
        throw new IllegalStateException();
    }

    @Override
    public synchronized void remove(T obj) {
        int hashcode = ((L2Object)obj).getObjectId();
        assert (hashcode > 0);
        int seed = hashcode;
        int incr = 1 + ((seed >> 5) + 1) % (this._table.length - 1);
        int ntry = 0;
        do {
            int pos;
            if (this._table[pos = seed % this._table.length & Integer.MAX_VALUE] == obj) {
                int n = pos;
                this._keys[n] = this._keys[n] & Integer.MIN_VALUE;
                this._table[pos] = null;
                --this._count;
                return;
            }
            if (this._table[pos] == null && this._keys[pos] >= 0) {
                return;
            }
            seed += incr;
        } while (++ntry < this._table.length);
        throw new IllegalStateException();
    }

    @Override
    public T get(int id) {
        int size = this._table.length;
        if (id <= 0) {
            return null;
        }
        if (size <= 11) {
            for (int i = 0; i < size; ++i) {
                if ((this._keys[i] & Integer.MAX_VALUE) != id) continue;
                return this._table[i];
            }
            return null;
        }
        int seed = id;
        int incr = 1 + ((seed >> 5) + 1) % (size - 1);
        int ntry = 0;
        do {
            int pos;
            if ((this._keys[pos = seed % size & Integer.MAX_VALUE] & Integer.MAX_VALUE) == id) {
                return this._table[pos];
            }
            if (this._table[pos] == null && this._keys[pos] >= 0) {
                return null;
            }
            seed += incr;
        } while (++ntry < size);
        return null;
    }

    @Override
    public boolean contains(T obj) {
        return this.get(((L2Object)obj).getObjectId()) != null;
    }

    private void expand() {
        int newSize = L2ObjectHashMap.getPrime(this._table.length + 1);
        L2Object[] newTable = new L2Object[newSize];
        int[] newKeys = new int[newSize];
        block0: for (int i = 0; i < this._table.length; ++i) {
            T obj = this._table[i];
            if (obj == null) continue;
            int hashcode = this._keys[i] & Integer.MAX_VALUE;
            assert (hashcode == ((L2Object)obj).getObjectId());
            int seed = hashcode;
            int incr = 1 + ((seed >> 5) + 1) % (newSize - 1);
            int ntry = 0;
            do {
                int pos;
                if (newTable[pos = seed % newSize & Integer.MAX_VALUE] == null) {
                    assert (newKeys[pos] == 0 && hashcode != 0);
                    newKeys[pos] = hashcode;
                    newTable[pos] = obj;
                    continue block0;
                }
                int n = pos;
                newKeys[n] = newKeys[n] | Integer.MIN_VALUE;
                seed += incr;
            } while (++ntry < newSize);
            throw new IllegalStateException();
        }
        this._table = newTable;
        this._keys = newKeys;
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr(this, this._table);
    }

    static class Itr
    implements Iterator<T> {
        private final T[] _array;
        private int _nextIdx;
        private T _nextObj;
        private T _lastRet;
        final /* synthetic */ L2ObjectHashMap this$0;

        Itr(T[] pArray) {
            this.this$0 = var1_1;
            this._array = pArray;
            while (this._nextIdx < this._array.length) {
                this._nextObj = this._array[this._nextIdx];
                if (this._nextObj != null) {
                    return;
                }
                ++this._nextIdx;
            }
        }

        @Override
        public boolean hasNext() {
            return this._nextObj != null;
        }

        @Override
        public T next() {
            if (this._nextObj == null) {
                throw new NoSuchElementException();
            }
            this._lastRet = this._nextObj;
            ++this._nextIdx;
            while (this._nextIdx < this._array.length) {
                this._nextObj = this._array[this._nextIdx];
                if (this._nextObj != null) break;
                ++this._nextIdx;
            }
            if (this._nextIdx >= this._array.length) {
                this._nextObj = null;
            }
            return this._lastRet;
        }

        @Override
        public void remove() {
            if (this._lastRet == null) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this._lastRet);
        }
    }
}

