/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.network;

import com.l2jserver.loginserver.network.L2LoginClient;
import com.l2jserver.loginserver.network.clientpackets.AuthGameGuard;
import com.l2jserver.loginserver.network.clientpackets.L2LoginClientPacket;
import com.l2jserver.loginserver.network.clientpackets.RequestAuthLogin;
import com.l2jserver.loginserver.network.clientpackets.RequestServerList;
import com.l2jserver.loginserver.network.clientpackets.RequestServerLogin;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.mmocore.network.IPacketHandler;
import org.mmocore.network.ReceivablePacket;

public final class L2LoginPacketHandler
implements IPacketHandler<L2LoginClient> {
    protected static final Logger _log = Logger.getLogger(L2LoginPacketHandler.class.getName());

    public ReceivablePacket<L2LoginClient> handlePacket(ByteBuffer buf, L2LoginClient client) {
        int opcode = buf.get() & 0xFF;
        L2LoginClientPacket packet = null;
        L2LoginClient.LoginClientState state = client.getState();
        block0 : switch (state) {
            case CONNECTED: {
                switch (opcode) {
                    case 7: {
                        packet = new AuthGameGuard();
                        break block0;
                    }
                }
                this.debugOpcode(opcode, state);
                break;
            }
            case AUTHED_GG: {
                switch (opcode) {
                    case 0: {
                        packet = new RequestAuthLogin();
                        break block0;
                    }
                }
                this.debugOpcode(opcode, state);
                break;
            }
            case AUTHED_LOGIN: {
                switch (opcode) {
                    case 2: {
                        packet = new RequestServerLogin();
                        break block0;
                    }
                    case 5: {
                        packet = new RequestServerList();
                        break block0;
                    }
                }
                this.debugOpcode(opcode, state);
            }
        }
        return packet;
    }

    private void debugOpcode(int opcode, L2LoginClient.LoginClientState state) {
        _log.info("Unknown Opcode: " + opcode + " for state: " + state.name());
    }
}

