/*
 * Decompiled with CFR 0.152.
 */
package org.netcon;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netcon.NetConnection;
import org.netcon.NetConnectionConfig;

public abstract class NetConnectionListener
extends Thread {
    private static final Logger _log = Logger.getLogger(NetConnectionListener.class.getName());
    private final NetConnectionConfig _config;
    private final ServerSocket _serverSocket;
    private final Map<String, ForeignConnection> _floodProtection;
    private final List<String> _ipBanns;

    protected NetConnectionListener(NetConnectionConfig config) throws IOException {
        this._config = config;
        if (this._config.TCP_IP_BANN_ENABLED) {
            this._ipBanns = new ArrayList<String>();
            for (String ip : this._config.TCP_IP_BANN_LIST) {
                this._ipBanns.add(ip);
            }
        } else {
            this._ipBanns = null;
        }
        this._floodProtection = this._config.TCP_FLOOD_PROTECTION_ENABLED ? new HashMap<String, ForeignConnection>() : null;
        this._serverSocket = this._config.TCP_EXTERNAL_HOST_ADDRESS.equals("*") ? new ServerSocket(this._config.TCP_EXTERNAL_PORT, this._config.TCP_CONNECTION_QUEUE) : new ServerSocket(this._config.TCP_EXTERNAL_PORT, this._config.TCP_CONNECTION_QUEUE, InetAddress.getByName(this._config.TCP_EXTERNAL_HOST_ADDRESS));
    }

    @Override
    public final void run() {
        Socket connection = null;
        while (true) {
            try {
                while (true) {
                    connection = this._serverSocket.accept();
                    String connectionAddress = connection.getInetAddress().getHostAddress();
                    _log.log(Level.INFO, "Received connection: " + connectionAddress);
                    if (this._config.TCP_IP_BANN_ENABLED && this._ipBanns.contains(connectionAddress)) {
                        throw new IOException("IP: " + connectionAddress + " is on TCP_IP_BANN_LIST. Closing connection...");
                    }
                    if (this._config.TCP_FLOOD_PROTECTION_ENABLED) {
                        ForeignConnection fConnection = this._floodProtection.get(connectionAddress);
                        if (fConnection != null) {
                            fConnection.connectionNumber += 1;
                            if (fConnection.connectionNumber > this._config.TCP_FAST_CONNECTION_LIMIT && System.currentTimeMillis() - fConnection.lastConnection < (long)this._config.TCP_NORMAL_CONNECTION_TIME || System.currentTimeMillis() - fConnection.lastConnection < (long)this._config.TCP_FAST_CONNECTION_TIME || fConnection.connectionNumber > this._config.TCP_MAX_CONNECTION_PER_IP) {
                                fConnection.lastConnection = System.currentTimeMillis();
                                fConnection.connectionNumber -= 1;
                                fConnection.isFlooding = true;
                                throw new IOException("IP: " + connectionAddress + " is marked as Flooding. Closing connection...");
                            }
                            fConnection.lastConnection = System.currentTimeMillis();
                            if (fConnection.isFlooding) {
                                fConnection.isFlooding = false;
                            }
                            _log.log(Level.FINE, "IP: " + connectionAddress + " is no longer marked as Flooding.");
                        } else {
                            fConnection = new ForeignConnection(System.currentTimeMillis());
                            this._floodProtection.put(connectionAddress, fConnection);
                        }
                    }
                    this.buildTCPNetConnection(this._config, connection);
                }
            }
            catch (IOException e) {
                _log.log(Level.WARNING, "", e);
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (IOException e1) {
                        _log.log(Level.WARNING, "Failed closing connection.", e1);
                    }
                }
                try {
                    if (!this.isInterrupted()) continue;
                    this.close();
                    continue;
                }
                catch (IOException e1) {
                    _log.log(Level.WARNING, "Failed closing listener.", e1);
                    continue;
                }
            }
            break;
        }
    }

    public final void close() throws IOException {
        this._serverSocket.close();
    }

    public final void removeTCPNetConnection(NetConnection connection) throws IOException {
        if (!this._config.TCP_FLOOD_PROTECTION_ENABLED) {
            return;
        }
        String connectionAddress = connection.getConnectionAddress();
        ForeignConnection fConnection = this._floodProtection.get(connectionAddress);
        if (fConnection != null) {
            fConnection.connectionNumber -= 1;
            if (fConnection.connectionNumber == 0) {
                this._floodProtection.remove(connectionAddress);
            }
        }
    }

    protected abstract void buildTCPNetConnection(NetConnectionConfig var1, Socket var2) throws IOException;

    private final class ForeignConnection {
        private int connectionNumber;
        private long lastConnection;
        private boolean isFlooding = false;

        private ForeignConnection(long paramLong) {
            this.lastConnection = paramLong;
            this.connectionNumber = 1;
        }
    }
}

