/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.asm;

import de.loskutov.bco.asm.Index;
import java.util.BitSet;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.AbstractVisitor;
import org.objectweb.asm.util.TraceAnnotationVisitor;
import org.objectweb.asm.util.TraceClassVisitor;
import org.objectweb.asm.util.TraceFieldVisitor;
import org.objectweb.asm.util.TraceMethodVisitor;

public class CommentedClassVisitor
extends TraceClassVisitor {
    protected boolean raw;
    protected BitSet modes;
    protected boolean showLines;
    protected boolean showLocals;
    protected boolean showStackMap;
    protected boolean showHex;
    private static final String[] CHAR_NAMES = new String[]{"NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL", "BS", "HT", "LF", "VT", "FF", "CR", "SO", "SI", "DLE", "DC1", "DC2", "DC3", "DC4", "NAK", "SYN", "ETB", "CAN", "EM", "SUB", "ESC", "FS", "GS", "RS", "US"};

    public CommentedClassVisitor(BitSet modes) {
        super(null);
        this.modes = modes;
        this.raw = !modes.get(3);
        this.showLines = modes.get(4);
        this.showLocals = modes.get(5);
        this.showStackMap = modes.get(9);
        this.showHex = modes.get(10);
    }

    public void visitEnd() {
        this.text.add("}\n");
    }

    protected TraceAnnotationVisitor createTraceAnnotationVisitor() {
        return new CommentedAnnotationVisitor();
    }

    protected TraceFieldVisitor createTraceFieldVisitor() {
        return new CommentedFieldVisitor();
    }

    protected TraceMethodVisitor createTraceMethodVisitor() {
        return new CommentedMethodVisitor();
    }

    protected void appendDescriptor(int type, String desc) {
        this.appendDescriptor(this.buf, type, desc, this.raw);
    }

    protected void appendDescriptor(StringBuffer buf1, int type, String desc, boolean raw1) {
        if (desc == null) {
            return;
        }
        if (raw1) {
            if (type == 5 || type == 2 || type == 4) {
                buf1.append("// signature ").append(desc).append('\n');
            } else {
                buf1.append(desc);
            }
        } else {
            switch (type) {
                case 0: {
                    buf1.append(CommentedClassVisitor.eatPackageNames(desc, '/'));
                    break;
                }
                case 1: {
                    if ("T".equals(desc)) {
                        buf1.append("top");
                        break;
                    }
                    if ("N".equals(desc)) {
                        buf1.append("null");
                        break;
                    }
                    if ("U".equals(desc)) {
                        buf1.append("uninitialized_this");
                        break;
                    }
                    buf1.append(CommentedClassVisitor.getSimpleName(Type.getType((String)desc)));
                    break;
                }
                case 3: {
                    Type[] args = Type.getArgumentTypes((String)desc);
                    Type res = Type.getReturnType((String)desc);
                    buf1.append('(');
                    for (int i = 0; i < args.length; ++i) {
                        if (i > 0) {
                            buf1.append(',');
                        }
                        buf1.append(CommentedClassVisitor.getSimpleName(args[i]));
                    }
                    buf1.append(") : ");
                    buf1.append(CommentedClassVisitor.getSimpleName(res));
                    break;
                }
                case 2: 
                case 4: {
                    if (this.buf.lastIndexOf(this.tab) != this.buf.length() - this.tab.length()) break;
                    this.buf.delete(this.buf.lastIndexOf(this.tab), this.buf.length());
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    buf1.append(CommentedClassVisitor.eatPackageNames(desc, '.'));
                    break;
                }
                case 7: {
                    buf1.append(CommentedClassVisitor.eatPackageNames(desc, '.'));
                    break;
                }
                case 8: {
                    buf1.append(CommentedClassVisitor.eatPackageNames(desc, '.'));
                    break;
                }
                default: {
                    buf1.append(desc);
                }
            }
        }
    }

    public static String getSimpleName(Type t) {
        String name = t.getClassName();
        return CommentedClassVisitor.eatPackageNames(name, '.');
    }

    private static String eatPackageNames(String name, char separator) {
        int start;
        int lastPoint = name.lastIndexOf(separator);
        if (lastPoint < 0) {
            return name;
        }
        StringBuffer sb = new StringBuffer(name);
        do {
            start = CommentedClassVisitor.getPackageStartIndex(sb, separator, lastPoint);
            sb.delete(start, lastPoint + 1);
        } while ((lastPoint = CommentedClassVisitor.lastIndexOf(sb, separator, start)) > 0);
        return sb.toString();
    }

    private static int lastIndexOf(StringBuffer chars, char c, int lastPoint) {
        for (int i = lastPoint - 1; i > 0; --i) {
            if (chars.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private static int getPackageStartIndex(StringBuffer chars, char c, int firstPoint) {
        for (int i = firstPoint - 1; i >= 0; --i) {
            char curr = chars.charAt(i);
            if (curr == c || Character.isJavaIdentifierPart(curr)) continue;
            return i + 1;
        }
        return 0;
    }

    class CommentedMethodVisitor
    extends TraceMethodVisitor {
        CommentedMethodVisitor() {
        }

        private Index getIndex(Label label) {
            for (int i = 0; i < this.text.size(); ++i) {
                Object o = this.text.get(i);
                if (!(o instanceof Index)) continue;
                Index index = (Index)o;
                if (index.labelNode == null || index.labelNode.getLabel() != label) continue;
                return index;
            }
            return null;
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            if (CommentedClassVisitor.this.showStackMap) {
                super.visitFrame(type, nLocal, local, nStack, stack);
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.buf.setLength(0);
            this.buf.append(this.tab2).append(OPCODES[opcode]).append(' ');
            this.appendDescriptor(0, owner);
            this.buf.append('.').append(name);
            this.appendDescriptor(3, desc);
            this.buf.append('\n');
            this.text.add(this.buf.toString());
        }

        public void visitVarInsn(int opcode, int var) {
            this.text.add(this.tab2 + OPCODES[opcode] + " " + var);
            if (!CommentedClassVisitor.this.raw) {
                this.text.add(new Integer(var));
            }
            this.text.add("\n");
        }

        public void visitLabel(Label label) {
            this.buf.setLength(0);
            this.buf.append(this.ltab);
            this.appendLabel(label);
            Index index = this.getIndex(label);
            if (index != null) {
                this.buf.append(" (").append(index.insn).append(")");
            }
            this.buf.append('\n');
            this.text.add(this.buf.toString());
        }

        public void visitIincInsn(int var, int increment) {
            this.text.add(this.tab2 + "IINC " + var);
            if (!CommentedClassVisitor.this.raw) {
                this.text.add(new Integer(var));
            }
            this.text.add(" " + increment + "\n");
        }

        public void visitIntInsn(int opcode, int operand) {
            this.buf.setLength(0);
            this.buf.append(this.tab2).append(OPCODES[opcode]).append(' ').append(opcode == 188 ? TYPES[operand] : this.formatValue(operand)).append('\n');
            this.text.add(this.buf.toString());
            if (this.mv != null) {
                this.mv.visitIntInsn(opcode, operand);
            }
        }

        private String formatValue(int operand) {
            if (CommentedClassVisitor.this.showHex) {
                String intStr = Integer.toHexString(operand).toUpperCase();
                return intStr + this.getAsCharComment(operand);
            }
            return Integer.toString(operand);
        }

        private String getAsCharComment(int value) {
            if (65535 < value || 0 > value) {
                return "";
            }
            StringBuffer sb = new StringBuffer("    // '");
            switch (value) {
                case 9: {
                    sb.append("\\t");
                    break;
                }
                case 13: {
                    sb.append("\\r");
                    break;
                }
                case 10: {
                    sb.append("\\n");
                    break;
                }
                case 12: {
                    sb.append("\\f");
                    break;
                }
                default: {
                    sb.append((char)value);
                }
            }
            if (value >= CHAR_NAMES.length) {
                if (value == 127) {
                    return sb.append("' (DEL)").toString();
                }
                return sb.append("'").toString();
            }
            return sb.append("' (").append(CHAR_NAMES[value]).append(")").toString();
        }

        private String formatValue(Object operand) {
            if (operand == null) {
                return "null";
            }
            if (CommentedClassVisitor.this.showHex) {
                if (operand instanceof Integer) {
                    String intStr = Integer.toHexString((Integer)operand).toUpperCase();
                    return intStr + this.getAsCharComment((Integer)operand);
                }
                if (operand instanceof Long) {
                    return Long.toHexString((Long)operand).toUpperCase();
                }
                if (operand instanceof Double) {
                    return Double.toHexString((Double)operand);
                }
                if (operand instanceof Float) {
                    return Float.toHexString(((Float)operand).floatValue());
                }
            }
            return operand.toString();
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (CommentedClassVisitor.this.showLocals) {
                super.visitLocalVariable(name, desc, signature, start, end, index);
            }
        }

        public void visitLdcInsn(Object cst) {
            this.buf.setLength(0);
            this.buf.append(this.tab2).append("LDC ");
            if (cst instanceof String) {
                AbstractVisitor.appendString((StringBuffer)this.buf, (String)((String)cst));
            } else if (cst instanceof Type) {
                this.buf.append(((Type)cst).getDescriptor() + ".class");
            } else {
                this.buf.append(this.formatValue(cst));
            }
            this.buf.append('\n');
            this.text.add(this.buf.toString());
            if (this.mv != null) {
                this.mv.visitLdcInsn(cst);
            }
        }

        public void visitLineNumber(int line, Label start) {
            if (CommentedClassVisitor.this.showLines) {
                super.visitLineNumber(line, start);
            }
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            if (CommentedClassVisitor.this.showLocals) {
                super.visitMaxs(maxStack, maxLocals);
            }
        }

        protected TraceAnnotationVisitor createTraceAnnotationVisitor() {
            return new CommentedAnnotationVisitor();
        }

        protected void appendDescriptor(int type, String desc) {
            CommentedClassVisitor.this.appendDescriptor(this.buf, type, desc, CommentedClassVisitor.this.raw);
        }
    }

    class CommentedFieldVisitor
    extends TraceFieldVisitor {
        CommentedFieldVisitor() {
        }

        public void setFieldVisitor(FieldVisitor fv) {
            this.fv = fv;
        }

        protected void appendDescriptor(int type, String desc) {
            CommentedClassVisitor.this.appendDescriptor(this.buf, type, desc, CommentedClassVisitor.this.raw);
        }

        protected TraceAnnotationVisitor createTraceAnnotationVisitor() {
            return new CommentedAnnotationVisitor();
        }
    }

    class CommentedAnnotationVisitor
    extends TraceAnnotationVisitor {
        CommentedAnnotationVisitor() {
        }

        public void setAnnotationVisitor(AnnotationVisitor av) {
            this.av = av;
        }

        protected TraceAnnotationVisitor createTraceAnnotationVisitor() {
            return new CommentedAnnotationVisitor();
        }

        protected void appendDescriptor(int type, String desc) {
            CommentedClassVisitor.this.appendDescriptor(this.buf, type, desc, CommentedClassVisitor.this.raw);
        }
    }
}

