/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.compare;

import de.loskutov.bco.BytecodeOutlinePlugin;
import de.loskutov.bco.compare.TypedElement;
import de.loskutov.bco.ui.actions.DefaultToggleAction;
import java.lang.reflect.Field;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IReusableEditor;

public class BytecodeCompare
extends CompareEditorInput {
    protected TypedElement left;
    protected TypedElement right;
    protected Action toggleAsmifierModeAction;
    protected Action hideLineInfoAction;
    protected Action hideLocalsAction;
    protected Action hideStackMapAction;
    protected Action expandStackMapAction;
    protected IReusableEditor myEditor;
    static /* synthetic */ Class class$org$eclipse$compare$CompareEditorInput;

    public BytecodeCompare(TypedElement left, TypedElement right) {
        super(new CompareConfiguration());
        this.left = left;
        this.right = right;
        this.toggleAsmifierModeAction = new DefaultToggleAction("diff_showASMifierCode", false){

            public void run(boolean newState) {
                BytecodeCompare.this.toggleMode(2, newState, newState);
            }
        };
        this.hideLineInfoAction = new DefaultToggleAction("diff_showLineInfo", false){

            public void run(boolean newState) {
                BytecodeCompare.this.toggleMode(4, newState, BytecodeCompare.this.toggleAsmifierModeAction.isChecked());
            }
        };
        this.hideLocalsAction = new DefaultToggleAction("diff_showVariables", false){

            public void run(boolean newState) {
                BytecodeCompare.this.toggleMode(5, newState, BytecodeCompare.this.toggleAsmifierModeAction.isChecked());
            }
        };
        this.hideStackMapAction = new DefaultToggleAction("diff_showStackmap", false){

            public void run(boolean newState) {
                BytecodeCompare.this.toggleMode(9, newState, BytecodeCompare.this.toggleAsmifierModeAction.isChecked());
            }
        };
        this.expandStackMapAction = new DefaultToggleAction("diff_expandStackmap", false){

            public void run(boolean newState) {
                BytecodeCompare.this.toggleMode(7, newState, BytecodeCompare.this.toggleAsmifierModeAction.isChecked());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object prepareInput(IProgressMonitor monitor) throws InterruptedException {
        if (this.right == null || this.left == null) {
            return null;
        }
        try {
            Object object;
            this.initLabels();
            Differencer differencer = new Differencer();
            monitor.beginTask("Bytecode Outline: comparing...", 30);
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 10);
            try {
                sub.beginTask("Bytecode Outline: comparing...", 100);
                object = differencer.findDifferences(false, (IProgressMonitor)sub, null, null, (Object)this.left, (Object)this.right);
            }
            catch (Throwable throwable) {
                try {
                    sub.done();
                    throw throwable;
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
            sub.done();
            return object;
        }
        finally {
            monitor.done();
        }
    }

    private void initLabels() {
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftLabel(this.left.getName());
        cc.setLeftImage(this.left.getImage());
        cc.setRightLabel(this.right.getName());
        cc.setRightImage(this.right.getImage());
        this.setTitle("Bytecode compare: " + this.left.getElementName() + " - " + this.right.getElementName());
    }

    public CompareViewerSwitchingPane getInputPane() {
        try {
            Field field = (class$org$eclipse$compare$CompareEditorInput == null ? (class$org$eclipse$compare$CompareEditorInput = BytecodeCompare.class$("org.eclipse.compare.CompareEditorInput")) : class$org$eclipse$compare$CompareEditorInput).getDeclaredField("fContentInputPane");
            field.setAccessible(true);
            Object object = field.get((Object)this);
            if (object instanceof CompareViewerSwitchingPane) {
                return (CompareViewerSwitchingPane)object;
            }
        }
        catch (Exception e) {
            BytecodeOutlinePlugin.log(e, 4);
        }
        return null;
    }

    public Control createContents(Composite parent) {
        Object obj = parent.getData();
        if (obj == null) {
            obj = parent.getParent().getData();
        }
        if (obj instanceof IReusableEditor) {
            this.myEditor = (IReusableEditor)obj;
        }
        Control control = super.createContents(parent);
        CompareViewerSwitchingPane inputPane = this.getInputPane();
        if (inputPane != null) {
            ToolBarManager toolBarManager2 = CompareViewerPane.getToolBarManager((Composite)inputPane);
            if (toolBarManager2 == null) {
                return control;
            }
            boolean separatorExist = false;
            if (toolBarManager2.find(this.hideLineInfoAction.getId()) == null) {
                if (!separatorExist) {
                    separatorExist = true;
                    toolBarManager2.insert(0, (IContributionItem)new Separator("bco"));
                }
                toolBarManager2.insertBefore("bco", (IAction)this.hideLineInfoAction);
            }
            if (toolBarManager2.find(this.hideLocalsAction.getId()) == null) {
                if (!separatorExist) {
                    separatorExist = true;
                    toolBarManager2.insert(0, (IContributionItem)new Separator("bco"));
                }
                toolBarManager2.insertBefore("bco", (IAction)this.hideLocalsAction);
            }
            if (toolBarManager2.find(this.hideStackMapAction.getId()) == null) {
                if (!separatorExist) {
                    separatorExist = true;
                    toolBarManager2.insert(0, (IContributionItem)new Separator("bco"));
                }
                toolBarManager2.insertBefore("bco", (IAction)this.hideStackMapAction);
            }
            if (toolBarManager2.find(this.expandStackMapAction.getId()) == null) {
                if (!separatorExist) {
                    separatorExist = true;
                    toolBarManager2.insert(0, (IContributionItem)new Separator("bco"));
                }
                toolBarManager2.insertBefore("bco", (IAction)this.expandStackMapAction);
            }
            if (toolBarManager2.find(this.toggleAsmifierModeAction.getId()) == null) {
                if (!separatorExist) {
                    toolBarManager2.insert(0, (IContributionItem)new Separator("bco"));
                    separatorExist = true;
                }
                toolBarManager2.insertBefore("bco", (IAction)this.toggleAsmifierModeAction);
            }
            try {
                toolBarManager2.update(true);
                toolBarManager2.getControl().getParent().layout(true);
                toolBarManager2.getControl().getParent().update();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        return control;
    }

    protected void toggleMode(int mode, boolean value, boolean isASMifierMode) {
        String contentType = isASMifierMode ? "java" : "bytecode";
        this.left.setMode(mode, value);
        this.left.setMode(2, isASMifierMode);
        this.left.setType(contentType);
        this.right.setMode(mode, value);
        this.right.setMode(2, isASMifierMode);
        this.right.setType(contentType);
        CompareUI.reuseCompareEditor((CompareEditorInput)new BytecodeCompare(this.left, this.right), (IReusableEditor)this.myEditor);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

