/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.compare;

import de.loskutov.bco.BytecodeOutlinePlugin;
import de.loskutov.bco.asm.DecompiledClass;
import de.loskutov.bco.asm.DecompilerClassVisitor;
import de.loskutov.bco.ui.JdtUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class TypedElement
extends BufferedContent
implements ITypedElement,
IStructureComparator {
    private final String name;
    private String type;
    private final String methodName;
    private final IJavaElement element;
    public static final String TYPE_BYTECODE = "bytecode";
    public static final String TYPE_ASM_IFIER = "java";
    private final BitSet modes;

    public TypedElement(String name, String methodName, String type, IJavaElement element, BitSet modes) {
        this.name = name;
        this.methodName = methodName;
        this.type = type;
        this.element = element;
        this.modes = modes;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    public String getElementName() {
        return JdtUtils.getElementName(this.element);
    }

    public Image getImage() {
        return CompareUI.getImage((String)"class");
    }

    public Object[] getChildren() {
        return new TypedElement[0];
    }

    protected InputStream createStream() throws CoreException {
        InputStream stream = JdtUtils.createInputStream(this.element);
        if (stream == null) {
            throw new CoreException((IStatus)new Status(4, "de.loskutov.bco", -1, "cannot get bytecode from class file", null));
        }
        DecompiledClass decompiledClass = null;
        try {
            decompiledClass = DecompilerClassVisitor.getDecompiledClass(stream, null, this.methodName, this.modes, null);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "de.loskutov.bco", -1, "cannot get bytecode dump", (Throwable)e));
        }
        catch (UnsupportedClassVersionError e) {
            throw new CoreException((IStatus)new Status(4, "de.loskutov.bco", -1, "Error caused by attempt to load class compiled with Java version which is not supported by current JVM", (Throwable)e));
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                BytecodeOutlinePlugin.log(e, 2);
            }
        }
        final byte[] bytes = decompiledClass.getText().getBytes();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TypedElement.this.setContent(bytes);
            }
        });
        return new ByteArrayInputStream(bytes);
    }

    public void setMode(int mode, boolean value) {
        this.modes.set(mode, value);
        this.discardBuffer();
    }
}

