/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.editors;

import de.loskutov.bco.BytecodeOutlinePlugin;
import de.loskutov.bco.asm.DecompiledClass;
import de.loskutov.bco.asm.DecompilerClassVisitor;
import de.loskutov.bco.ui.JdtUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.WeakHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class BytecodeSourceMapper
implements IDebugContextListener {
    private WeakHashMap classToDecompiled = new WeakHashMap();
    private IJavaReferenceType lastTypeInDebugger;
    private String lastMethodInDebugger;

    public BytecodeSourceMapper() {
        DebugContextManager.getDefault().addDebugContextListener((IDebugContextListener)this);
    }

    public char[] getSource(IClassFile classFile, BitSet decompilerFlags) {
        IType type = classFile.getType();
        if (type == null || !type.isBinary()) {
            return null;
        }
        IBinaryType info = null;
        try {
            info = (IBinaryType)((BinaryType)type).getElementInfo();
        }
        catch (JavaModelException e) {
            BytecodeOutlinePlugin.log(e, 4);
            return null;
        }
        if (info == null) {
            return null;
        }
        return this.findSource(type, info, classFile, decompilerFlags);
    }

    public char[] getSource(IFile file, IClassFile cf, BitSet decompilerFlags) {
        StringBuffer source = new StringBuffer();
        DecompiledClass decompiledClass = this.decompile(source, file.getLocation().toOSString(), decompilerFlags);
        this.classToDecompiled.put(cf, decompiledClass);
        return source.toString().toCharArray();
    }

    protected char[] findSource(IType type, IBinaryType info, IClassFile cf, BitSet decompilerFlags) {
        IPackageFragment pkgFrag = type.getPackageFragment();
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkgFrag.getParent();
        String pkg = type.getPackageFragment().getElementName().replace('.', '/');
        String classFile = new String(info.getFileName());
        int p = classFile.lastIndexOf(47);
        classFile = classFile.substring(p + 1);
        StringBuffer source = new StringBuffer();
        String location = null;
        String className = pkg + "/" + classFile;
        if (root.isArchive()) {
            location = this.getArchivePath(root);
            DecompiledClass decompiledClass = this.decompileFromArchive(source, location, className, decompilerFlags);
            this.classToDecompiled.put(cf, decompiledClass);
        } else {
            try {
                location = root.getUnderlyingResource().getLocation().toOSString() + "/" + className;
                DecompiledClass decompiledClass = this.decompile(source, location, decompilerFlags);
                this.classToDecompiled.put(cf, decompiledClass);
            }
            catch (JavaModelException e) {
                BytecodeOutlinePlugin.log(e, 4);
            }
        }
        source.append("\n\n// DECOMPILED FROM: ");
        source.append(location).append("\n");
        return source.toString().toCharArray();
    }

    public int getDecompiledLine(IMember elt, IClassFile cf) {
        String signature;
        DecompiledClass dc = (DecompiledClass)this.classToDecompiled.get(cf);
        if (dc != null && (signature = JdtUtils.getMethodSignature((IJavaElement)elt)) != null) {
            return dc.getDecompiledLine(signature);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DecompiledClass decompile(StringBuffer source, String filePath, BitSet decompilerFlags) {
        FileInputStream inputStream = null;
        DecompiledClass dc = null;
        try {
            inputStream = new FileInputStream(filePath);
            dc = this.decompile(source, inputStream, decompilerFlags);
        }
        catch (IOException e) {
            source.append(e.toString());
            BytecodeOutlinePlugin.log(e, 4);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    BytecodeOutlinePlugin.log(e, 4);
                }
            }
        }
        return dc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DecompiledClass decompileFromArchive(StringBuffer source, String archivePath, String className, BitSet decompilerFlags) {
        if (archivePath == null) {
            return null;
        }
        InputStream inputStream = null;
        DecompiledClass decompiledClass = null;
        try {
            ZipFile zf = new ZipFile(archivePath);
            ZipEntry ze = zf.getEntry(className);
            inputStream = zf.getInputStream(ze);
            decompiledClass = this.decompile(source, inputStream, decompilerFlags);
        }
        catch (IOException e) {
            source.append(e.toString());
            BytecodeOutlinePlugin.log(e, 4);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    BytecodeOutlinePlugin.log(e, 4);
                }
            }
        }
        return decompiledClass;
    }

    private DecompiledClass decompile(StringBuffer source, InputStream is, BitSet decompilerFlags) throws IOException {
        DecompiledClass decompiledClass = DecompilerClassVisitor.getDecompiledClass(is, null, null, decompilerFlags, null);
        source.append(decompiledClass.getText());
        return decompiledClass;
    }

    private String getArchivePath(IPackageFragmentRoot root) {
        String archivePath = null;
        try {
            IResource resource = root.getUnderlyingResource();
            archivePath = resource != null ? resource.getLocation().toOSString() : root.getPath().toOSString();
        }
        catch (JavaModelException e) {
            BytecodeOutlinePlugin.log(e, 4);
        }
        return archivePath;
    }

    protected IJavaElement findElement(IClassFile cf, int decompiledLine) {
        DecompiledClass dc = (DecompiledClass)this.classToDecompiled.get(cf);
        if (dc != null) {
            return dc.getJavaElement(decompiledLine, cf);
        }
        return cf;
    }

    public int mapToSource(int decompiledLine, IClassFile cf) {
        if (cf == null) {
            return 0;
        }
        DecompiledClass dc = (DecompiledClass)this.classToDecompiled.get(cf);
        if (dc != null) {
            return dc.getSourceLine(decompiledLine);
        }
        return 0;
    }

    public DecompiledClass getDecompiledClass(IClassFile cf) {
        if (cf == null) {
            return null;
        }
        return (DecompiledClass)this.classToDecompiled.get(cf);
    }

    public int mapToDecompiled(int sourceLine, IClassFile cf) {
        if (cf == null) {
            return 0;
        }
        DecompiledClass dc = (DecompiledClass)this.classToDecompiled.get(cf);
        if (dc != null) {
            return dc.getDecompiledLine(sourceLine);
        }
        return 0;
    }

    public IJavaReferenceType getLastTypeInDebugger() {
        return this.lastTypeInDebugger;
    }

    public int mapDebuggerToDecompiled(IClassFile cf) {
        if (cf == null || this.lastMethodInDebugger == null) {
            return -1;
        }
        DecompiledClass dc = (DecompiledClass)this.classToDecompiled.get(cf);
        if (dc != null) {
            return dc.getDecompiledLine(this.lastMethodInDebugger);
        }
        return -1;
    }

    public void debugContextChanged(DebugContextEvent event) {
        ISelection selection = event.getContext();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            if (sSelection.isEmpty()) {
                return;
            }
            Object element = sSelection.getFirstElement();
            if (element instanceof JDIStackFrame) {
                JDIStackFrame frame = (JDIStackFrame)element;
                try {
                    this.lastTypeInDebugger = frame.getReferenceType();
                    this.lastMethodInDebugger = frame.getMethodName() + frame.getSignature();
                }
                catch (DebugException e) {
                    BytecodeOutlinePlugin.log(e, 4);
                }
            }
        }
    }
}

