/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction.java;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.correction.java.FindClassResolutionsOperation;
import org.eclipse.pde.internal.ui.correction.java.JavaResolutionFactory;

public class QuickFixProcessor
implements IQuickFixProcessor {
    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ArrayList results = new ArrayList();
        int i = 0;
        while (i < locations.length) {
            int id = locations[i].getProblemId();
            switch (id) {
                case 0x1000133: {
                    this.handleAccessRestrictionProblem(context, locations[i], results);
                }
                case 268435846: {
                    this.handleImportNotFound(context, locations[i], results);
                }
            }
            ++i;
        }
        return results.toArray(new IJavaCompletionProposal[results.size()]);
    }

    private void handleAccessRestrictionProblem(IInvocationContext context, IProblemLocation location, Collection results) {
        IJavaProject referencedJavaProject;
        ITypeBinding referencedElement = null;
        ASTNode node = location.getCoveredNode(context.getASTRoot());
        if (node instanceof Type) {
            referencedElement = ((Type)node).resolveBinding();
        } else if (node instanceof Name) {
            referencedElement = ((Name)node).resolveBinding();
        }
        if (referencedElement != null && (referencedJavaProject = referencedElement.getJavaElement().getJavaProject()) != null && WorkspaceModelManager.isPluginProject((IProject)referencedJavaProject.getProject())) {
            IPackageFragment referencedPackage = (IPackageFragment)referencedElement.getJavaElement().getAncestor(4);
            IJavaProject currentProject = context.getCompilationUnit().getJavaProject();
            if (!WorkspaceModelManager.isPluginProject((IProject)currentProject.getProject())) {
                return;
            }
            if (!referencedJavaProject.equals(currentProject)) {
                IPluginModelBase referencedModel = PluginRegistry.findModel((IProject)referencedJavaProject.getProject());
                ExportPackageDescription[] exportPackages = referencedModel.getBundleDescription().getExportPackages();
                boolean packageExported = false;
                if (referencedPackage != null) {
                    Object proposal;
                    int i = 0;
                    while (i < exportPackages.length) {
                        if (exportPackages[i].getName().equals(referencedPackage.getElementName())) {
                            packageExported = true;
                            this.handleAccessRestrictionByImportPackage(context.getCompilationUnit().getJavaProject().getProject(), exportPackages[i], results);
                            break;
                        }
                        ++i;
                    }
                    if (!packageExported && (proposal = JavaResolutionFactory.createExportPackageProposal(referencedJavaProject.getProject(), referencedPackage, 1, 100)) != null) {
                        results.add(proposal);
                    }
                }
            } else {
                this.handleAccessRestrictionByImportPackage(referencedPackage, results);
            }
        }
    }

    private void handleAccessRestrictionByImportPackage(IPackageFragment fragment, Collection results) {
        HashSet<String> set = new HashSet<String>();
        IProject project = fragment.getJavaProject().getProject();
        String pkgName = fragment.getElementName();
        IPluginModelBase base = PluginRegistry.findModel((IProject)project);
        ExportPackageDescription[] descs = base.getBundleDescription().getResolvedImports();
        int i = 0;
        while (i < descs.length) {
            BundleDescription exporter = descs[i].getExporter();
            if (set.add(exporter.getSymbolicName())) {
                ExportPackageDescription[] exportedPkgs = exporter.getExportPackages();
                int j = 0;
                while (j < exportedPkgs.length) {
                    Object proposal;
                    if (exportedPkgs[j].getName().equals(pkgName) && (proposal = JavaResolutionFactory.createRequireBundleProposal(project, exportedPkgs[j], 1, 16)) != null) {
                        results.add(proposal);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void handleAccessRestrictionByImportPackage(IProject currentProject, ExportPackageDescription desc, Collection results) {
        BundleDescription supplier = desc.getSupplier();
        String supplierId = supplier.getSymbolicName();
        if (supplier != null) {
            Object proposal;
            IPluginModelBase base = PluginRegistry.findModel((IProject)currentProject);
            BundleDescription bd = base.getBundleDescription();
            BundleSpecification[] imports = bd.getRequiredBundles();
            boolean supplierImported = false;
            int j = 0;
            while (j < imports.length) {
                BundleDescription importSupplier = (BundleDescription)imports[j].getSupplier();
                if (importSupplier != null && importSupplier.getSymbolicName().equals(supplierId)) {
                    supplierImported = true;
                    break;
                }
                ++j;
            }
            if (!supplierImported && (proposal = JavaResolutionFactory.createRequireBundleProposal(currentProject, desc, 1, 16)) != null) {
                results.add(proposal);
            }
        }
    }

    private void handleImportNotFound(IInvocationContext context, IProblemLocation problemLocation, Collection result) {
        CompilationUnit cu = context.getASTRoot();
        ASTNode selectedNode = problemLocation.getCoveringNode(cu);
        if (selectedNode != null) {
            ASTNode node = QuickFixProcessor.getParent(selectedNode);
            String className = null;
            String packageName = null;
            if (node == null) {
                if (selectedNode instanceof SimpleName) {
                    ITypeBinding typeBinding = ((SimpleName)selectedNode).resolveTypeBinding();
                    className = typeBinding.getBinaryName();
                    packageName = typeBinding.getPackage().getName();
                }
            } else if (node instanceof ImportDeclaration) {
                int lastPeriod = (className = ((ImportDeclaration)node).getName().getFullyQualifiedName()).lastIndexOf(46);
                packageName = className.substring(0, lastPeriod >= 0 ? lastPeriod : className.length());
                result.add(JavaResolutionFactory.createSearchRepositoriesProposal(packageName));
            }
            if (className != null && packageName != null) {
                IProject project = cu.getJavaElement().getJavaProject().getProject();
                if (!WorkspaceModelManager.isPluginProject((IProject)project)) {
                    return;
                }
                FindClassResolutionsOperation.AbstractClassResolutionCollector collector = this.createCollector(result);
                FindClassResolutionsOperation findOperation = new FindClassResolutionsOperation(project, className, collector);
                try {
                    findOperation.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private FindClassResolutionsOperation.AbstractClassResolutionCollector createCollector(final Collection result) {
        return new FindClassResolutionsOperation.AbstractClassResolutionCollector(){
            boolean isDone = false;

            public void addResolutionModification(IProject project, ExportPackageDescription desc) {
                Object proposal = JavaResolutionFactory.createImportPackageProposal(project, desc, 1, 17);
                if (proposal != null) {
                    result.add(proposal);
                    this.isDone = true;
                }
            }

            public boolean isDone() {
                return this.isDone;
            }
        };
    }

    private static ASTNode getParent(ASTNode node) {
        while ((node = node.getParent()) != null && node.getNodeType() != 26) {
        }
        return node;
    }

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        switch (problemId) {
            case 0x1000133: 
            case 268435846: {
                IJavaProject project;
                IJavaElement parent = unit.getParent();
                if (parent == null || (project = parent.getJavaProject()) == null) break;
                return WorkspaceModelManager.isPluginProject((IProject)project.getProject());
            }
        }
        return false;
    }
}

