/*
 * Decompiled with CFR 0.152.
 */
package org.sf.easyexplore.actions;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.sf.easyexplore.EasyExplorePlugin;

public abstract class EasyBaseAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    private Object selected = null;
    private Class selectedClass = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        this.runAction(action);
    }

    public abstract void runAction(IAction var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(IAction action, String target) {
        try {
            if (this.selected == null) {
                return;
            }
            if ("unknown".equals(this.selected)) {
                MessageDialog.openInformation((Shell)new Shell(), (String)"EasyExplore", (String)("Unable to run command " + this.selectedClass.getName()));
                EasyExplorePlugin.log("Unable to run command " + this.selectedClass);
                return;
            }
            File file = null;
            if (this.selected instanceof IResource) {
                file = new File(((IResource)this.selected).getLocation().toOSString());
            } else if (this.selected instanceof File) {
                file = (File)this.selected;
            }
            if (!EasyExplorePlugin.getDefault().isSupported()) {
                MessageDialog.openInformation((Shell)new Shell(), (String)"EasyExplore", (String)("This platform (" + System.getProperty("os.name") + ") is currently unsupported.\n" + "You can try to provide the correct explorer and command to execute in the Preference dialog.\n" + "If you succeed, please be kind to post your discovery on EasyExplore website http://sourceforge.net/projects/easystruts,\n" + "or by email farialima@users.sourceforge.net. Thanks !"));
            }
            String arg0 = null;
            String[] targets = target.split("<>");
            if (targets.length == 1) {
                if (file.isDirectory()) {
                    arg0 = file.toString();
                } else {
                    if (!file.isFile()) return;
                    arg0 = file.getParent().toString();
                }
            } else {
                if (targets.length != 2) return;
                if (file.isDirectory()) {
                    target = targets[0];
                    arg0 = file.toString();
                } else {
                    if (!file.isFile()) return;
                    target = targets[1];
                    arg0 = file.toString();
                }
            }
            if (target.trim().isEmpty()) {
                return;
            }
            boolean done = false;
            if (target.contains("${resource_loc}")) {
                target = target.replace("${resource_loc}", file.toString());
                done = true;
            }
            if (target.contains("${resource_name}")) {
                target = target.replace("${resource_name}", file.getName());
                done = true;
            }
            if (target.contains("${.}")) {
                target = file.isDirectory() ? target.replace("${.}", file.toString()) : target.replace("${.}", file.getParent().toString());
                done = true;
            }
            if (target.contains("${env_var:ProgramFiles}")) {
                target = target.replace("${env_var:ProgramFiles}", System.getenv("ProgramFiles"));
                done = true;
            }
            StringBuffer sb = new StringBuffer(target.length() * 2);
            Pattern p = Pattern.compile("\\$\\{env_var:(.+?)\\}");
            Matcher m = p.matcher(target);
            while (m.find()) {
                String envKey = m.group();
                String envVal = System.getenv(envKey);
                if (envVal != null) {
                    m.appendReplacement(sb, envVal);
                    done = true;
                    continue;
                }
                MessageDialog.openInformation((Shell)new Shell(), (String)"EasyExplore", (String)("Unable " + target.substring(m.start(), m.end())));
                return;
            }
            target = m.appendTail(sb).toString();
            if (target.contains("{0}")) {
                target = target.replace("{0}", arg0);
                done = true;
            }
            if (!done) {
                target = String.valueOf(target) + " " + arg0;
            }
            try {
                EasyExplorePlugin.log("running: " + target);
                Runtime.getRuntime().exec(target);
                return;
            }
            catch (Throwable t) {
                MessageDialog.openInformation((Shell)new Shell(), (String)"EasyExplore", (String)("Unable to execute " + target));
                EasyExplorePlugin.log(t);
            }
            return;
        }
        catch (Throwable e) {
            EasyExplorePlugin.log(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        try {
            IAdaptable adaptable = null;
            this.selected = "unknown";
            if (selection instanceof IStructuredSelection) {
                adaptable = (IAdaptable)((IStructuredSelection)selection).getFirstElement();
                if (adaptable == null) {
                    System.out.println("\u3013adaptable == null");
                    return;
                }
                this.selectedClass = adaptable.getClass();
                this.selected = adaptable instanceof IResource ? (IResource)adaptable : (adaptable instanceof PackageFragment && ((PackageFragment)adaptable).getPackageFragmentRoot() instanceof JarPackageFragmentRoot ? this.getJarFile((IAdaptable)((PackageFragment)adaptable).getPackageFragmentRoot()) : (adaptable instanceof JarPackageFragmentRoot ? this.getJarFile(adaptable) : (IResource)adaptable.getAdapter(IResource.class)));
            }
        }
        catch (Throwable e) {
            EasyExplorePlugin.log(e);
        }
    }

    protected File getJarFile(IAdaptable adaptable) {
        JarPackageFragmentRoot jpfr = (JarPackageFragmentRoot)adaptable;
        File selected = jpfr.getPath().makeAbsolute().toFile();
        if (!selected.exists()) {
            File projectFile = new File(jpfr.getJavaProject().getProject().getLocation().toOSString());
            selected = new File(String.valueOf(projectFile.getParent()) + selected.toString());
        }
        return selected;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow arg0) {
    }
}

