/*
 * Decompiled with CFR 0.152.
 */
package org.sf.easyexplore.actions;

import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.sf.easyexplore.CopyFullyQualifiedClassNameCore;
import org.sf.easyexplore.Messages;

public abstract class EasyCopyLocationAction
implements IActionDelegate {
    private IWorkbenchPart activePart;
    private Clipboard clipboard;

    protected final void setActivePart(IWorkbenchPart activePart) {
        this.activePart = activePart;
    }

    public final void run(IAction action) {
        String fullyQualifiedClassName;
        try {
            fullyQualifiedClassName = CopyFullyQualifiedClassNameCore.getFullyQualifiedClassName(this.getSelectedObject());
        }
        catch (JavaModelException javaModelException) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("CopyFullyQualifiedClassNameAction.error.dialog.title"), (String)Messages.getString("CopyFullyQualifiedClassNameAction.error.dialog.unable.to.retrieve.classname.message"));
            return;
        }
        if (fullyQualifiedClassName == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("CopyFullyQualifiedClassNameAction.error.dialog.title"), (String)Messages.getString("CopyFullyQualifiedClassNameAction.error.dialog.select.java.type.message"));
            return;
        }
        this.copyToClipboard(fullyQualifiedClassName);
    }

    private void copyToClipboard(String text) {
        block3: {
            Clipboard clipboard = this.getClipboard();
            try {
                clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.getString("CopyToClipboardProblemDialog.title"), (String)Messages.getString("CopyToClipboardProblemDialog.message"))) break block3;
                this.copyToClipboard(text);
            }
        }
    }

    private synchronized Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new Clipboard(this.getShell().getDisplay());
        }
        return this.clipboard;
    }

    protected abstract Object getSelectedObject() throws JavaModelException;

    protected Shell getShell() {
        return this.activePart.getSite().getShell();
    }
}

