/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.tigris.subversion.subclipse.graph.cache.Node;
import org.tigris.subversion.subclipse.graph.cache.Path;

public class Branch
extends Path
implements Serializable {
    private static final long serialVersionUID = -1236475833029223413L;
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object a, Object b) {
            long rb;
            long ra;
            if (a instanceof Long) {
                ra = (Long)a;
            } else if (a instanceof Node) {
                ra = ((Node)a).getRevision();
            } else {
                throw new RuntimeException();
            }
            if (b instanceof Long) {
                rb = (Long)b;
            } else if (b instanceof Node) {
                rb = ((Node)b).getRevision();
            } else {
                throw new RuntimeException();
            }
            if (ra < rb) {
                return -1;
            }
            if (ra > rb) {
                return 1;
            }
            return 0;
        }
    };
    private List nodes = new ArrayList();
    private Node lastNode;
    private transient Object view;

    public Object getView() {
        return this.view;
    }

    public void setView(Object view) {
        this.view = view;
    }

    public Branch(String path) {
        super(path);
    }

    public void addNode(Node n) {
        this.nodes.add(n);
        this.lastNode = n;
    }

    public Node getLastNode() {
        return this.lastNode;
    }

    public List getNodes() {
        return this.nodes;
    }

    public void end() {
        this.lastNode = null;
    }

    public Node getSource(long revision) {
        int index = Collections.binarySearch(this.nodes, new Long(revision), COMPARATOR);
        if (index < 0 && (index = -index - 2) < 0) {
            return null;
        }
        Node previous = (Node)this.nodes.get(index);
        if (previous.getAction() == 'D' && previous.getRevision() < revision) {
            return null;
        }
        return previous;
    }

    public boolean isEnded() {
        return this.lastNode == null && !this.nodes.isEmpty();
    }
}

