/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tigris.subversion.subclipse.graph.cache.Branch;
import org.tigris.subversion.subclipse.graph.cache.Node;

public class Graph
implements Serializable {
    private static final String[] EMPTY_STRING = new String[0];
    private static final long serialVersionUID = -5285462558875510455L;
    private String rootPath;
    private Map branches = new HashMap();
    private List paths = new ArrayList();
    private transient String[] pathsArray = null;
    private transient String selectedPath;
    private transient long selectedRevision;
    private transient Node selectedNode;

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(Node selectedNode) {
        this.selectedNode = selectedNode;
    }

    public Graph(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    public void setSelectedPath(String selectedPath) {
        this.selectedPath = selectedPath;
    }

    public long getSelectedRevision() {
        return this.selectedRevision;
    }

    public void setSelectedRevision(long selectedRevision) {
        this.selectedRevision = selectedRevision;
    }

    public Branch addBranch(String path) {
        Branch b = new Branch(path);
        this.branches.put(path, b);
        this.paths.add(path);
        this.pathsArray = null;
        return b;
    }

    public List getPaths() {
        return this.paths;
    }

    public Branch getBranch(String path) {
        return (Branch)this.branches.get(path);
    }

    public Node[] getNodes() {
        ArrayList nodes = new ArrayList();
        Set keySet = this.branches.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            Branch branch = (Branch)this.branches.get(iter.next());
            List branchNodes = branch.getNodes();
            Iterator nodeIter = branchNodes.iterator();
            while (nodeIter.hasNext()) {
                nodes.add(nodeIter.next());
            }
        }
        Node[] nodeArray = new Node[nodes.size()];
        nodes.toArray(nodeArray);
        return nodeArray;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String[] getPathsAsArray() {
        if (this.pathsArray == null) {
            this.pathsArray = this.paths.toArray(EMPTY_STRING);
        }
        return this.pathsArray;
    }
}

