/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.colorer.FileType;
import net.sf.colorer.Group;
import net.sf.colorer.Region;
import net.sf.colorer.impl.Logger;

public class HRCParser {
    private long iptr;
    private boolean disposed = false;
    private static int counter;
    Group[] rootGroups;
    Hashtable allGroups = new Hashtable();

    HRCParser(long _iptr) {
        this.iptr = _iptr;
        Logger.trace("HRCParser", "init: " + ++counter + " iptr:" + this.iptr);
    }

    void checkActive() {
        if (this.disposed) {
            throw new RuntimeException("checkActive");
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        this.checkActive();
        this.disposed = true;
        this.finalize(this.iptr);
        Logger.trace("HRCParser", "disposed");
    }

    protected void finalize() throws Throwable {
        Logger.trace("HRCParser", "finalize:" + --counter);
        if (this.disposed) {
            return;
        }
        this.dispose();
    }

    native void finalize(long var1);

    public Region getRegion(String qname) {
        return this.getRegion(this.iptr, qname);
    }

    native Region getRegion(long var1, String var3);

    public Region getRegion(int index) {
        return this.getRegionByIndex(this.iptr, index);
    }

    native Region getRegionByIndex(long var1, int var3);

    public synchronized Group[] getGroups() {
        if (this.rootGroups != null) {
            return this.rootGroups;
        }
        Vector<Group> rg = new Vector<Group>();
        Enumeration e = this.enumerateFileTypes();
        while (e.hasMoreElements()) {
            FileType ft = (FileType)e.nextElement();
            String ft_group = ft.getGroup();
            int idx = ft_group.lastIndexOf(46);
            Group gr = (Group)this.allGroups.get(ft_group);
            if (gr == null) {
                gr = new Group(ft_group);
                this.allGroups.put(ft_group, gr);
                if (idx == -1) {
                    rg.addElement(gr);
                } else {
                    String parent_name = ft_group.substring(0, idx);
                    Group parent_gr = (Group)this.allGroups.get(parent_name);
                    if (parent_gr == null) {
                        parent_gr = new Group(parent_name);
                        this.allGroups.put(parent_name, parent_gr);
                        rg.addElement(parent_gr);
                    }
                    parent_gr.groups.addElement(gr);
                }
            }
            gr.filetypes.addElement(ft);
        }
        this.rootGroups = rg.toArray(new Group[0]);
        return this.rootGroups;
    }

    public Enumeration enumerateFileTypes() {
        return new Enumeration(){
            int idx = 0;

            public boolean hasMoreElements() {
                FileType cls = HRCParser.this.enumerateFileTypes(HRCParser.this.iptr, this.idx);
                return cls != null;
            }

            public Object nextElement() {
                FileType cls = HRCParser.this.enumerateFileTypes(HRCParser.this.iptr, this.idx);
                if (cls == null) {
                    return null;
                }
                ++this.idx;
                return cls;
            }
        };
    }

    native FileType enumerateFileTypes(long var1, int var3);
}

