/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse;

import java.net.URL;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import net.sf.colorer.FileType;
import net.sf.colorer.ParserFactory;
import net.sf.colorer.eclipse.IColorerReloadListener;
import net.sf.colorer.eclipse.Messages;
import net.sf.colorer.impl.Logger;
import net.sf.colorer.swt.ColorManager;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.framework.BundleContext;

public class ColorerPlugin
extends AbstractUIPlugin {
    private static ColorerPlugin plugin;
    private ResourceBundle resourceBundle;
    private String catalogPath;
    private ParserFactory parserFactory;
    private ColorManager colorManager = new ColorManager();
    private Vector reloadListeners = new Vector();
    private Vector hrdSetsList;
    private IPreferenceStore fCombinedPreferenceStore;
    public static final String WORD_WRAP_SIGNATURE = "@@WORD_WRAP@@";
    public static final String HRD_SIGNATURE = "@@HRD@@";

    public ColorerPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Logger.trace("ColorerPlugin", "Loaded");
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault("SPACES_FOR_TABS", false);
        store.setDefault("WORD_WRAP", false);
        store.setDefault("WordWrapPatch", true);
        store.setDefault("FULL_BACK", true);
        store.setDefault("USE_BACK", true);
        store.setDefault("VERT_CROSS", false);
        store.setDefault("HORZ_CROSS", true);
        store.setDefault("PAIRS_MATCH", "PAIRS_OUTLINE");
        store.setDefault("HRD_SET", "default");
        store.setDefault("PROJECTION", true);
        store.setDefault("BACK_SCALE", 1);
        store.setDefault("Outline.Hierarchy", true);
        store.setDefault("Outline.Sort", false);
        store.setDefault("RegionsTree.Link", false);
        store.setDefault("g.Prefix", "");
        store.setDefault("g.Suffix", ".html");
        store.setDefault("g.HRDSchema", store.getString("HRD_SET"));
        store.setDefault("g.HtmlHeaderFooter", true);
        store.setDefault("g.InfoHeader", true);
        store.setDefault("g.UseLineNumbers", true);
        store.setDefault("g.OutputEncoding", "default");
        store.setDefault("g.TargetDirectory", "/");
        store.setDefault("g.LinkSource", "");
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }

    public static ColorerPlugin getDefault() {
        return plugin;
    }

    public static ParserFactory getDefaultPF() {
        return ColorerPlugin.getDefault().getParserFactory();
    }

    public synchronized ParserFactory getParserFactory() {
        block7: {
            if (this.parserFactory != null) {
                return this.parserFactory;
            }
            try {
                this.catalogPath = new URL(Platform.resolve((URL)this.getBundle().getEntry("/")), "colorer/catalog.xml").toExternalForm();
                Logger.trace("EclipsecolorerPlugin", "Catalog: " + this.catalogPath);
                this.parserFactory = new ParserFactory(this.catalogPath);
            }
            catch (Throwable e) {
                Logger.trace("EclipsecolorerPlugin", "Fault in getting parser factory, (will try default location)", e);
                boolean error = true;
                Throwable exc = e;
                try {
                    this.parserFactory = new ParserFactory();
                    error = false;
                }
                catch (Throwable e1) {
                    error = true;
                    exc = e1;
                }
                if (!error) break block7;
                MessageDialog.openError(null, (String)Messages.get("init.error.title"), (String)(Messages.get("init.error.pf") + "\n" + exc.getMessage()));
            }
        }
        if (this.parserFactory != null) {
            this.hrdSetsList = new Vector();
            Enumeration hrds = this.parserFactory.enumerateHRDInstances("rgb");
            while (hrds.hasMoreElements()) {
                String hrd_name = (String)hrds.nextElement();
                String hrd_descr = this.parserFactory.getHRDescription("rgb", hrd_name);
                this.hrdSetsList.add(hrd_name);
            }
            this.initHRCParameters();
        }
        return this.parserFactory;
    }

    void initHRCParameters() {
        Enumeration fte = this.parserFactory.getHRCParser().enumerateFileTypes();
        while (fte.hasMoreElements()) {
            FileType type = (FileType)fte.nextElement();
            this.getPreferenceStore().setDefault(HRD_SIGNATURE + type.getName(), "");
            this.getPreferenceStore().setDefault(WORD_WRAP_SIGNATURE + type.getName(), -1);
            String[] parameters = type.getParameters();
            for (int pindex = 0; parameters != null && pindex < parameters.length; ++pindex) {
                String propname = this.getParameterPropertyName(type, parameters[pindex]);
                this.getPreferenceStore().setDefault(propname, type.getParameterDefaultValue(parameters[pindex]));
                if (!this.getPreferenceStore().contains(propname)) continue;
                type.setParameterValue(parameters[pindex], this.getPreferenceStore().getString(propname));
            }
        }
    }

    String getParameterPropertyName(FileType type, String parameter) {
        return "parameters." + type.getName() + "." + parameter;
    }

    public void resetHRCParameters() {
        Enumeration fte = this.parserFactory.getHRCParser().enumerateFileTypes();
        while (fte.hasMoreElements()) {
            FileType type = (FileType)fte.nextElement();
            this.getPreferenceStore().setToDefault(HRD_SIGNATURE + type.getName());
            this.getPreferenceStore().setToDefault(WORD_WRAP_SIGNATURE + type.getName());
            String[] parameters = type.getParameters();
            for (int pindex = 0; parameters != null && pindex < parameters.length; ++pindex) {
                String pname = this.getParameterPropertyName(type, parameters[pindex]);
                this.getPreferenceStore().setToDefault(pname);
            }
        }
    }

    public String getPropertyHRD(FileType type) {
        String hrd = this.getPreferenceStore().getString(HRD_SIGNATURE + type.getName());
        if (hrd.equals("")) {
            hrd = null;
        }
        return hrd;
    }

    public void setPropertyHRD(FileType type, String value) {
        this.getPreferenceStore().setValue(HRD_SIGNATURE + type.getName(), value);
    }

    public int getPropertyWordWrap(FileType type) {
        return this.getPreferenceStore().getInt(WORD_WRAP_SIGNATURE + type.getName());
    }

    public void setPropertyWordWrap(FileType type, int value) {
        this.getPreferenceStore().setValue(WORD_WRAP_SIGNATURE + type.getName(), value);
    }

    public int getPropertyParameter(FileType type, String param) {
        String paramValue = this.getPreferenceStore().getString(this.getParameterPropertyName(type, param.toString()));
        if ("true".equals(paramValue)) {
            return 1;
        }
        if ("false".equals(paramValue)) {
            return 0;
        }
        return -1;
    }

    public void setPropertyParameter(FileType type, String param, int value) {
        if (value != 0 && value != 1) {
            this.getPreferenceStore().setToDefault(this.getParameterPropertyName(type, param));
        } else {
            this.getPreferenceStore().setValue(this.getParameterPropertyName(type, param), value == 0 ? "false" : "true");
        }
    }

    public synchronized void reloadParserFactory() {
        if (this.parserFactory != null && !this.parserFactory.isDisposed()) {
            this.parserFactory.dispose();
        }
        this.parserFactory = null;
        this.parserFactory = this.getParserFactory();
        this.notifyReloadListeners();
    }

    public Vector getHRDList() {
        this.getParserFactory();
        return this.hrdSetsList;
    }

    void notifyReloadListeners() {
        for (int idx = 0; idx < this.reloadListeners.size(); ++idx) {
            ((IColorerReloadListener)this.reloadListeners.elementAt(idx)).notifyReload();
        }
    }

    public void addReloadListener(IColorerReloadListener listener) {
        if (!this.reloadListeners.contains(listener)) {
            this.reloadListeners.add(listener);
        }
    }

    public void removeReloadListener(IColorerReloadListener listener) {
        this.reloadListeners.remove(listener);
    }

    public ColorManager getColorManager() {
        return this.colorManager;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("net.sf.colorer.eclipse.EclipsecolorerPluginResources");
            }
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }
}

