/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sf.colorer.eclipse.compare.StubTextEditor;
import net.sf.colorer.eclipse.editors.ColorerSourceViewerConfiguration;
import net.sf.colorer.eclipse.jface.TextColorer;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ColorerTextViewer
extends Viewer {
    private SourceViewer fSourceViewer;
    private Object fInput;
    private TextColorer fTextColorer;

    ColorerTextViewer(Composite parent) {
        this.fSourceViewer = new SourceViewer(parent, null, 768);
        this.fTextColorer = new TextColorer(new StubTextEditor((ITextViewer)this.fSourceViewer, ""));
        this.fSourceViewer.configure((SourceViewerConfiguration)new ColorerSourceViewerConfiguration(this.fTextColorer));
        this.fSourceViewer.setEditable(false);
    }

    public Control getControl() {
        return this.fSourceViewer.getControl();
    }

    public void setInput(Object input) {
        if (input instanceof IStreamContentAccessor) {
            Document document = new Document(ColorerTextViewer.getString(input));
            this.fSourceViewer.setDocument((IDocument)document);
        }
        this.fInput = input;
    }

    public Object getInput() {
        return this.fInput;
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection s, boolean reveal) {
    }

    public void refresh() {
    }

    private static String getString(Object input) {
        if (input instanceof IStreamContentAccessor) {
            IStreamContentAccessor sa = (IStreamContentAccessor)input;
            try {
                return ColorerTextViewer.readString(sa);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return "";
    }

    public static String readString(IStreamContentAccessor sa) throws CoreException {
        InputStream is = sa.getContents();
        if (is != null) {
            String encoding = null;
            if (sa instanceof IEncodedStreamContentAccessor) {
                try {
                    encoding = ((IEncodedStreamContentAccessor)sa).getCharset();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            return ColorerTextViewer.readString(is, encoding);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readString(InputStream is, String encoding) {
        if (is == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            StringBuffer buffer = new StringBuffer();
            char[] part = new char[2048];
            int read = 0;
            reader = new BufferedReader(new InputStreamReader(is, encoding));
            while ((read = reader.read(part)) != -1) {
                buffer.append(part, 0, read);
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException ex) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
        return null;
    }
}

