/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.view;

import java.util.Enumeration;
import net.sf.colorer.FileType;
import net.sf.colorer.HRCParser;
import net.sf.colorer.Region;
import net.sf.colorer.eclipse.ColorerPlugin;
import net.sf.colorer.eclipse.ImageStore;
import net.sf.colorer.eclipse.Messages;
import net.sf.colorer.eclipse.jface.IColorerEditorAdapter;
import net.sf.colorer.eclipse.jface.TextColorer;
import net.sf.colorer.eclipse.view.RegionContentProvider;
import net.sf.colorer.eclipse.view.RegionTreeLabelProvider;
import net.sf.colorer.handlers.LineRegion;
import net.sf.colorer.handlers.RegionMapper;
import net.sf.colorer.handlers.StyledRegion;
import net.sf.colorer.impl.Logger;
import net.sf.colorer.swt.dialog.ResourceManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;

public class HRCRegionsTreeView
extends ViewPart
implements IPropertyChangeListener {
    private Composite composite;
    private TreeViewer treeViewer;
    private HRCParser hrcParser;
    private Action refreshAction;
    private Action loadAllAction;
    private Action linkToEditorAction;
    private IPreferenceStore prefStore;
    RegionMapper regionMapper;
    StyledRegion def_Text;
    Label fg_label;
    Label bg_label;
    Color foreColor;
    Color backColor;
    ISelectionListener thisSelectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            TextColorer activeEditor = null;
            if (part instanceof IColorerEditorAdapter && HRCRegionsTreeView.this.linkToEditorAction.isChecked()) {
                activeEditor = ((IColorerEditorAdapter)part).getTextColorer();
                LineRegion lr = activeEditor.getCaretRegion();
                if (lr == null || lr.region == null) {
                    return;
                }
                HRCRegionsTreeView.this.treeViewer.expandToLevel((Object)lr.region, 0);
                HRCRegionsTreeView.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)lr.region), true);
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.prefStore = ColorerPlugin.getDefault().getPreferenceStore();
        this.prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.composite = this.createComposite(parent);
        this.makeActions();
        this.contributeToActionBars();
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.thisSelectionListener);
        this.propertyChange(null);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.regionMapper != null) {
            this.regionMapper.dispose();
            this.regionMapper = null;
        }
        try {
            this.regionMapper = ColorerPlugin.getDefaultPF().createStyledMapper("rgb", this.prefStore.getString("HRD_SET"));
        }
        catch (Exception e) {
            Logger.error("HRCRegionsTreeView", "createStyledMapper:", e);
        }
        this.def_Text = (StyledRegion)this.regionMapper.getRegionDefine("def:Text");
    }

    Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayout((Layout)new GridLayout());
        composite_1.setLayoutData((Object)new GridData(1808));
        PatternFilter patternFilter = new PatternFilter();
        FilteredTree filter = new FilteredTree(composite_1, 2820, patternFilter);
        filter.setLayoutData((Object)new GridData(1808));
        this.treeViewer = filter.getViewer();
        this.treeViewer.setContentProvider((IContentProvider)new RegionContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new RegionTreeLabelProvider());
        this.hrcParser = ColorerPlugin.getDefaultPF().getHRCParser();
        this.treeViewer.setInput((Object)this.hrcParser);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Region sel = HRCRegionsTreeView.this.getSelectedRegion(event.getSelection());
                if (sel == null) {
                    return;
                }
                Logger.trace("doubleClick", sel);
                if (HRCRegionsTreeView.this.treeViewer.getExpandedState((Object)sel)) {
                    HRCRegionsTreeView.this.treeViewer.collapseToLevel((Object)sel, 1);
                } else {
                    HRCRegionsTreeView.this.treeViewer.expandToLevel((Object)sel, 1);
                }
            }
        });
        this.treeViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Region sel = HRCRegionsTreeView.this.getSelectedRegion(event.getSelection());
                if (sel == null) {
                    return;
                }
                StyledRegion sr = (StyledRegion)HRCRegionsTreeView.this.regionMapper.getRegionDefine(sel);
                HRCRegionsTreeView.this.foreColor = ResourceManager.newColor(HRCRegionsTreeView.this.def_Text.fore);
                HRCRegionsTreeView.this.backColor = ResourceManager.newColor(HRCRegionsTreeView.this.def_Text.back);
                if (sr != null) {
                    if (sr.bfore) {
                        HRCRegionsTreeView.this.foreColor.dispose();
                        HRCRegionsTreeView.this.foreColor = ResourceManager.newColor(sr.fore);
                    }
                    if (sr.bback) {
                        HRCRegionsTreeView.this.backColor.dispose();
                        HRCRegionsTreeView.this.backColor = ResourceManager.newColor(sr.back);
                    }
                }
                HRCRegionsTreeView.this.fg_label.setForeground(HRCRegionsTreeView.this.backColor);
                HRCRegionsTreeView.this.fg_label.setBackground(HRCRegionsTreeView.this.foreColor);
                HRCRegionsTreeView.this.bg_label.setForeground(HRCRegionsTreeView.this.foreColor);
                HRCRegionsTreeView.this.bg_label.setBackground(HRCRegionsTreeView.this.backColor);
            }
        });
        composite_1 = new Composite(composite, 2048);
        composite_1.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite_1.setLayout((Layout)gridLayout);
        this.fg_label = new Label(composite_1, 0x1000A00);
        GridData gridData = new GridData(592);
        gridData.verticalSpan = 2;
        gridData.heightHint = 30;
        this.fg_label.setLayoutData((Object)gridData);
        this.fg_label.setBackground(ResourceManager.getColor(1));
        this.fg_label.setText("Foreground");
        this.bg_label = new Label(composite_1, 0x1000A00);
        this.bg_label.setBackground(ResourceManager.getColor(1));
        gridData = new GridData(592);
        gridData.verticalSpan = 2;
        gridData.heightHint = 30;
        this.bg_label.setLayoutData((Object)gridData);
        this.bg_label.setText("Background");
        return composite;
    }

    Region getSelectedRegion(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection sel = (StructuredSelection)selection;
            if (sel.isEmpty()) {
                return null;
            }
            Region region = (Region)sel.getFirstElement();
            return region;
        }
        return null;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.loadAllAction);
        manager.add((IAction)this.linkToEditorAction);
    }

    private void makeActions() {
        this.refreshAction = new Action("Refresh", ImageStore.getID("regions-tree-refresh")){

            public void run() {
                HRCRegionsTreeView.this.hrcParser = ColorerPlugin.getDefaultPF().getHRCParser();
                HRCRegionsTreeView.this.treeViewer.setInput((Object)HRCRegionsTreeView.this.hrcParser);
            }
        };
        this.refreshAction.setToolTipText(Messages.get("regions-tree.refresh"));
        this.loadAllAction = new Action("Load All", ImageStore.getID("regions-tree-loadall")){

            public void run() {
                BusyIndicator.showWhile((Display)HRCRegionsTreeView.this.treeViewer.getTree().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        Enumeration e = HRCRegionsTreeView.this.hrcParser.enumerateFileTypes();
                        while (e.hasMoreElements()) {
                            FileType ft = (FileType)e.nextElement();
                            ft.getBaseScheme();
                        }
                        HRCRegionsTreeView.this.refreshAction.run();
                    }
                });
            }
        };
        this.loadAllAction.setToolTipText(Messages.get("regions-tree.loadall"));
        this.linkToEditorAction = new Action("Link", 2){

            public void run() {
                HRCRegionsTreeView.this.prefStore.setValue("RegionsTree.Link", this.isChecked());
            }
        };
        this.linkToEditorAction.setImageDescriptor(ImageStore.getID("regions-tree-link"));
        this.linkToEditorAction.setToolTipText(Messages.get("regions-tree.link"));
        this.linkToEditorAction.setChecked(this.prefStore.getBoolean("RegionsTree.Link"));
    }

    public void setFocus() {
        this.composite.setFocus();
    }

    public void dispose() {
        if (this.foreColor != null) {
            this.foreColor.dispose();
        }
        if (this.backColor != null) {
            this.backColor.dispose();
        }
        this.regionMapper.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.thisSelectionListener);
        this.prefStore.removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }
}

