/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.editor;

import java.util.Stack;
import net.sf.colorer.Region;
import net.sf.colorer.RegionHandler;
import net.sf.colorer.editor.BaseEditor;
import net.sf.colorer.editor.EditorListener;
import net.sf.colorer.editor.IFoldingReciever;

public class FoldingBuilder {
    private BaseEditor fBaseEditor;
    private InternalRegionHandler fHandler = new InternalRegionHandler();
    private IFoldingReciever fReciever;
    private int fThreshold = 1;

    public void getFoldingItems() {
    }

    public void setThreshold(int linesThreshold) {
        this.fThreshold = linesThreshold;
    }

    public void install(BaseEditor baseEditor, IFoldingReciever reciever) {
        this.fBaseEditor = baseEditor;
        this.fReciever = reciever;
        this.fBaseEditor.addRegionHandler(this.fHandler, this.fBaseEditor.getParserFactory().getHRCParser().getRegion("def:EmbeddedTag"));
        this.fBaseEditor.addEditorListener(this.fHandler);
    }

    public void uninstall() {
        this.fBaseEditor.removeRegionHandler(this.fHandler);
        this.fBaseEditor.removeEditorListener(this.fHandler);
        this.fBaseEditor = null;
        this.fReciever = null;
    }

    class InternalRegionHandler
    implements RegionHandler,
    EditorListener {
        Stack schemeStack = new Stack();
        private int fLastLine;
        private int fFirstLine;
        private int compensateReparse;
        private boolean compensationRun;

        InternalRegionHandler() {
        }

        public void addRegion(int lno, String line, int sx, int ex, Region region) {
        }

        public void clearLine(int lno, String line) {
        }

        public void startParsing(int lno) {
            this.compensateReparse = 0;
            this.compensationRun = true;
        }

        public void endParsing(int lno) {
        }

        public void enterScheme(int lno, String line, int sx, int ex, Region region, String scheme) {
            if (this.compensationRun && this.compensateReparse < this.schemeStack.size()) {
                ++this.compensateReparse;
            } else {
                this.compensationRun = false;
                this.schemeStack.push(new FoldingElement(lno, sx, scheme));
            }
        }

        public void leaveScheme(int lno, String line, int sx, int ex, Region region, String scheme) {
            if (this.compensationRun) {
                this.compensationRun = false;
            }
            FoldingElement last = (FoldingElement)this.schemeStack.pop();
            if (!this.schemeStack.empty() && last.s_line == ((FoldingElement)this.schemeStack.peek()).s_line) {
                return;
            }
            if (last.s_line < lno && last.s_line < lno - FoldingBuilder.this.fThreshold) {
                FoldingBuilder.this.fReciever.notifyFoldingItem(last.s_line, last.s_offset, lno, ex, last.scheme);
                this.fLastLine = lno;
            }
        }

        public void modifyEvent(int topLine) {
            FoldingBuilder.this.fReciever.notifyInvalidate(topLine);
            this.fLastLine = -1;
            this.fFirstLine = -1;
        }
    }

    public class FoldingElement {
        int s_line;
        int s_offset;
        String scheme;

        FoldingElement(int line, int offset, String scheme) {
            this.scheme = scheme;
            this.s_line = line;
            this.s_offset = offset;
        }
    }
}

