/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.viewer;

import java.io.IOException;
import java.io.Writer;
import net.sf.colorer.handlers.LineRegion;
import net.sf.colorer.handlers.StyledRegion;

public class ParsedLineWriter {
    public static void tokenWrite(Writer markupWriter, Writer textWriter, String line, LineRegion[] lineRegions) throws IOException {
        int pos = 0;
        for (int idx = 0; idx < lineRegions.length; ++idx) {
            LineRegion l1 = lineRegions[idx];
            if (l1.special || l1.region == null || l1.start == l1.end) continue;
            int end = l1.end;
            if (end == -1) {
                end = line.length();
            }
            if (l1.start > pos) {
                textWriter.write(line, pos, l1.start - pos);
                pos = l1.start;
            }
            String token = l1.region.getName().replace(':', '_');
            markupWriter.write("<span class='");
            markupWriter.write(token);
            markupWriter.write("'>");
            textWriter.write(line, pos, end - l1.start);
            markupWriter.write("</span>");
            pos += end - l1.start;
        }
    }

    public static void markupWrite(Writer markupWriter, Writer textWriter, String line, LineRegion[] lineRegions) throws IOException {
        int pos = 0;
        for (int idx = 0; idx < lineRegions.length; ++idx) {
            LineRegion l1 = lineRegions[idx];
            if (l1.special || l1.rdef == null || l1.start == l1.end) continue;
            int end = l1.end;
            if (end == -1) {
                end = line.length();
            }
            if (l1.start > pos) {
                textWriter.write(line, pos, l1.start - pos);
                pos = l1.start;
            }
            if (l1.texted().sback != null) {
                markupWriter.write(l1.texted().sback);
            }
            if (l1.texted().stext != null) {
                markupWriter.write(l1.texted().stext);
            }
            textWriter.write(line, pos, end - l1.start);
            if (l1.texted().etext != null) {
                markupWriter.write(l1.texted().etext);
            }
            if (l1.texted().eback != null) {
                markupWriter.write(l1.texted().eback);
            }
            pos += end - l1.start;
        }
        if (pos < line.length()) {
            textWriter.write(line, pos, line.length() - pos);
        }
    }

    public static void htmlRGBWrite(Writer markupWriter, Writer textWriter, String line, LineRegion[] lineRegions) throws IOException {
        int pos = 0;
        for (int idx = 0; idx < lineRegions.length; ++idx) {
            LineRegion l1 = lineRegions[idx];
            if (l1.special || l1.rdef == null || l1.start == l1.end) continue;
            int end = l1.end;
            if (end == -1) {
                end = line.length();
            }
            if (l1.start > pos) {
                textWriter.write(line, pos, l1.start - pos);
                pos = l1.start;
            }
            ParsedLineWriter.writeStart(markupWriter, l1.styled());
            textWriter.write(line, pos, end - l1.start);
            ParsedLineWriter.writeEnd(markupWriter, l1.styled());
            pos += end - l1.start;
        }
        if (pos < line.length()) {
            textWriter.write(line, pos, line.length() - pos);
        }
    }

    static String hexPrint(int val, int width) {
        String tv = Integer.toHexString(val);
        while (tv.length() < width) {
            tv = "0" + tv;
        }
        return tv;
    }

    public static void writeStyle(Writer writer, StyledRegion lr) throws IOException {
        StringBuffer span = new StringBuffer();
        if (lr.bfore) {
            span.append("color:#" + ParsedLineWriter.hexPrint(lr.fore, 6) + "; ");
        }
        if (lr.bback) {
            span.append("background:#" + ParsedLineWriter.hexPrint(lr.back, 6) + "; ");
        }
        if ((lr.style & 1) != 0) {
            span.append("font-weight:bold; ");
        }
        if ((lr.style & 2) != 0) {
            span.append("font-style:italic; ");
        }
        if ((lr.style & 4) != 0) {
            span.append("text-decoration:underline; ");
        }
        writer.write(span.toString());
    }

    public static void writeStart(Writer writer, StyledRegion lr) throws IOException {
        if (!lr.bfore && !lr.bback) {
            return;
        }
        writer.write("<span style='");
        ParsedLineWriter.writeStyle(writer, lr);
        writer.write("'>");
    }

    public static void writeEnd(Writer writer, StyledRegion lr) throws IOException {
        if (!lr.bfore && !lr.bback) {
            return;
        }
        writer.write("</span>");
    }
}

