/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.util.EventObject;

public class DiffSummary
extends EventObject {
    private static final long serialVersionUID = 1L;
    private DiffKind diffKind;
    private boolean propsChanged;
    private int nodeKind;

    DiffSummary(String path, int diffKind, boolean propsChanged, int nodeKind) {
        super(path);
        this.diffKind = DiffKind.getInstance(diffKind);
        this.propsChanged = propsChanged;
        this.nodeKind = nodeKind;
    }

    public String getPath() {
        return (String)this.source;
    }

    public DiffKind getDiffKind() {
        return this.diffKind;
    }

    public boolean propsChanged() {
        return this.propsChanged;
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public String toString() {
        return this.getPath();
    }

    public static class DiffKind {
        public static DiffKind NORMAL = new DiffKind(0);
        public static DiffKind ADDED = new DiffKind(1);
        public static DiffKind MODIFIED = new DiffKind(2);
        public static DiffKind DELETED = new DiffKind(3);
        private int kind;

        private DiffKind(int kind) {
            this.kind = kind;
        }

        public static DiffKind getInstance(int diffKind) throws IllegalArgumentException {
            switch (diffKind) {
                case 0: {
                    return NORMAL;
                }
                case 1: {
                    return ADDED;
                }
                case 2: {
                    return MODIFIED;
                }
                case 3: {
                    return DELETED;
                }
            }
            throw new IllegalArgumentException("Diff kind " + diffKind + " not recognized");
        }

        public boolean equals(Object diffKind) {
            return ((DiffKind)diffKind).kind == this.kind;
        }

        public int hashCode() {
            return this.kind;
        }

        public String toString() {
            switch (this.kind) {
                case 0: {
                    return "normal";
                }
                case 1: {
                    return "added";
                }
                case 2: {
                    return "modified";
                }
                case 3: {
                    return "deleted";
                }
            }
            return "unknown";
        }
    }
}

