/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.SVNPropertyAction;
import org.tigris.subversion.subclipse.ui.dialogs.DeletePropertyDialog;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class SVNPropertyDeleteAction
extends SVNPropertyAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                ISVNProperty[] svnProperties = SVNPropertyDeleteAction.this.getSelectedSvnProperties();
                boolean directory = svnProperties[0].getFile().isDirectory();
                String message = svnProperties.length == 1 ? Policy.bind("SVNPropertyDeleteAction.confirmSingle", svnProperties[0].getName()) : Policy.bind("SVNPropertyDeleteAction.confirmMultiple", Integer.toString(svnProperties.length));
                DeletePropertyDialog dialog = new DeletePropertyDialog(SVNPropertyDeleteAction.this.getShell(), message, directory);
                if (dialog.open() == 1) {
                    return;
                }
                int i = 0;
                while (i < svnProperties.length) {
                    ISVNProperty svnProperty = svnProperties[i];
                    ISVNLocalResource svnResource = SVNPropertyDeleteAction.this.getSVNLocalResource(svnProperty);
                    try {
                        svnResource.deleteSvnProperty(svnProperty.getName(), dialog.isRecurse());
                    }
                    catch (SVNException e) {
                        throw new InvocationTargetException(e);
                    }
                    ++i;
                }
            }
        }, false, 2);
    }

    protected boolean isEnabled() throws TeamException {
        return this.getSelectedSvnProperties().length > 0;
    }

    protected String getErrorTitle() {
        return Policy.bind("SVNPropertyDeleteAction.delete");
    }

    protected String getImageId() {
        return "Menu Property Delete";
    }
}

