/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.annotations;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RemoteAnnotationStorage
extends PlatformObject
implements IEncodedStorage {
    private InputStream contents;
    private ISVNRemoteFile file;

    public RemoteAnnotationStorage(ISVNRemoteFile file, InputStream contents) {
        this.file = file;
        this.contents = contents;
    }

    public InputStream getContents() throws CoreException {
        try {
            this.contents.reset();
        }
        catch (IOException e) {
            SVNUIPlugin.log((TeamException)((Object)SVNException.wrapException((Exception)e)));
        }
        return this.contents;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCharset() throws CoreException {
        String string;
        InputStream contents = this.getContents();
        try {
            try {
                String charSet;
                string = charSet = SVNUIPlugin.getCharset(this.getName(), contents);
                Object var3_5 = null;
            }
            catch (IOException e) {
                throw new SVNException((IStatus)new Status(4, "org.tigris.subversion.subclipse.ui", 381, Policy.bind("RemoteAnnotationStorage.1", this.getFullPath().toString()), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            try {
                contents.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        contents.close();
        return string;
    }

    public IPath getFullPath() {
        ISVNRepositoryLocation location = this.file.getRepository();
        SVNUrl repositoryUrl = location.getRepositoryRoot();
        String[] segments = repositoryUrl.getPathSegments();
        Path path = new Path(null, "/");
        int i = 0;
        while (i < segments.length) {
            path = path.append(segments[i]);
            ++i;
        }
        path = path.setDevice(String.valueOf(repositoryUrl.getHost()) + ':');
        path = path.append(this.file.getRepositoryRelativePath());
        return path;
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isReadOnly() {
        return true;
    }
}

