/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.resources.RemoteResource;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;
import org.tigris.subversion.subclipse.ui.compare.RevisionAwareDifferencer;
import org.tigris.subversion.subclipse.ui.compare.SVNAbstractCompareEditorInput;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNCompareEditorInput
extends SVNAbstractCompareEditorInput {
    private ITypedElement left;
    private ITypedElement right;
    private ITypedElement ancestor;
    private Image leftImage;
    private Image rightImage;
    private Image ancestorImage;

    public SVNCompareEditorInput(ResourceEditionNode left, ResourceEditionNode right) {
        this(left, right, null);
    }

    public SVNCompareEditorInput(ResourceEditionNode left, ResourceEditionNode right, ResourceEditionNode ancestor) {
        super(new CompareConfiguration());
        this.left = left;
        this.right = right;
        this.ancestor = ancestor;
        if (left != null) {
            this.leftImage = left.getImage();
            if (left.getRemoteResource() instanceof RemoteResource && ((RemoteResource)left.getRemoteResource()).getPegRevision() == null) {
                ((RemoteResource)left.getRemoteResource()).setPegRevision(SVNRevision.HEAD);
            }
        }
        if (right != null) {
            this.rightImage = right.getImage();
            if (right.getRemoteResource() instanceof RemoteResource && ((RemoteResource)right.getRemoteResource()).getPegRevision() == null) {
                ((RemoteResource)right.getRemoteResource()).setPegRevision(SVNRevision.HEAD);
            }
        }
        if (ancestor != null) {
            this.ancestorImage = ancestor.getImage();
        }
    }

    private String getLabel(ITypedElement element) {
        if (element instanceof ResourceEditionNode) {
            ISVNRemoteResource edition = ((ResourceEditionNode)element).getRemoteResource();
            if (edition instanceof ISVNRemoteFile) {
                return Policy.bind("nameAndRevision", edition.getName(), edition.getLastChangedRevision().toString());
            }
            if (edition.isContainer()) {
                return Policy.bind("SVNCompareEditorInput.inHead", edition.getName());
            }
            return Policy.bind("SVNCompareEditorInput.repository", new Object[]{edition.getName(), edition.getLastChangedRevision().toString()});
        }
        return element.getName();
    }

    private String getVersionLabel(ITypedElement element) {
        if (element instanceof ResourceEditionNode) {
            ISVNRemoteResource edition = ((ResourceEditionNode)element).getRemoteResource();
            if (edition.isContainer()) {
                return Policy.bind("SVNCompareEditorInput.headLabel");
            }
            return edition.getLastChangedRevision().toString();
        }
        return element.getName();
    }

    private String guessResourceName() {
        if (this.left != null) {
            return this.left.getName();
        }
        if (this.right != null) {
            return this.right.getName();
        }
        if (this.ancestor != null) {
            return this.ancestor.getName();
        }
        return "";
    }

    private void initLabels() {
        String title;
        CompareConfiguration cc = this.getCompareConfiguration();
        ITypedElement left = this.left;
        ITypedElement right = this.right;
        ITypedElement ancestor = this.ancestor;
        if (left != null) {
            cc.setLeftLabel(this.getLabel(left));
            cc.setLeftImage(this.leftImage);
        }
        if (right != null) {
            cc.setRightLabel(this.getLabel(right));
            cc.setRightImage(this.rightImage);
        }
        if (ancestor != null) {
            cc.setAncestorLabel(this.getLabel(ancestor));
            cc.setAncestorImage(this.ancestorImage);
        }
        if (ancestor != null) {
            title = Policy.bind("SVNCompareEditorInput.titleAncestor", new Object[]{this.guessResourceName(), this.getVersionLabel(ancestor), this.getVersionLabel(left), this.getVersionLabel(right)});
        } else {
            String leftName = null;
            if (left != null) {
                leftName = left.getName();
            }
            String rightName = null;
            if (right != null) {
                rightName = right.getName();
            }
            title = leftName != null && !leftName.equals(rightName) ? Policy.bind("SVNCompareEditorInput.titleNoAncestorDifferent", new Object[]{leftName, this.getVersionLabel(left), rightName, this.getVersionLabel(right)}) : Policy.bind("SVNCompareEditorInput.titleNoAncestor", new Object[]{this.guessResourceName(), this.getVersionLabel(left), this.getVersionLabel(right)});
        }
        this.setTitle(title);
    }

    public boolean isSaveNeeded() {
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object prepareInput(IProgressMonitor monitor) throws InterruptedException {
        Object object;
        boolean threeWay;
        boolean bl = threeWay = this.ancestor != null;
        if (this.right == null || this.left == null) {
            this.setMessage(Policy.bind("SVNCompareEditorInput.different"));
            return null;
        }
        this.initLabels();
        try {
            try {
                Object[] result = new Object[1];
                monitor.beginTask(Policy.bind("SVNCompareEditorInput.comparing"), 30);
                SubProgressMonitor sub = new SubProgressMonitor(monitor, 30);
                sub.beginTask(Policy.bind("SVNCompareEditorInput.comparing"), 100);
                try {
                    result[0] = new RevisionAwareDifferencer().findDifferences(threeWay, (IProgressMonitor)sub, null, this.ancestor, this.left, this.right);
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    sub.done();
                    throw throwable;
                }
                {
                    Object var5_9 = null;
                }
                sub.done();
                object = result[0];
                Object var7_12 = null;
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            catch (RuntimeException e) {
                String string = e.getMessage();
                Object var7_13 = null;
                monitor.done();
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return object;
    }

    public boolean canRunAsJob() {
        return true;
    }
}

