/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.GetRemoteResourceCommand;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.compare.MultipleSelectionNode;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalResourceNode;
import org.tigris.subversion.subclipse.ui.compare.StatusAwareDifferencer;
import org.tigris.subversion.subclipse.ui.internal.Utils;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNLocalBaseCompareInput
extends CompareEditorInput
implements ISaveableWorkbenchPart {
    private final SVNRevision remoteRevision;
    private boolean readOnly;
    private SVNLocalResourceNode[] localResourceNodes;
    private ResourceEditionNode[] remoteResourceNodes;

    public SVNLocalBaseCompareInput(ISVNLocalResource[] resources, SVNRevision revision, boolean readOnly) throws SVNException {
        super(new CompareConfiguration());
        this.remoteRevision = revision;
        this.readOnly = readOnly;
        this.localResourceNodes = new SVNLocalResourceNode[resources.length];
        this.remoteResourceNodes = new ResourceEditionNode[resources.length];
        int i = 0;
        while (i < resources.length) {
            SVNUrl copiedFromUrl;
            this.localResourceNodes[i] = new SVNLocalResourceNode(resources[i]);
            ISVNRemoteResource remoteResource = null;
            LocalResourceStatus status = resources[i].getStatus();
            if (status != null && status.isCopied() && (copiedFromUrl = status.getUrlCopiedFrom()) != null) {
                GetRemoteResourceCommand getRemoteResourceCommand = new GetRemoteResourceCommand(resources[i].getRepository(), copiedFromUrl, SVNRevision.HEAD);
                getRemoteResourceCommand.run(null);
                remoteResource = getRemoteResourceCommand.getRemoteResource();
            }
            if (remoteResource == null) {
                remoteResource = resources[i].getRemoteResource(revision);
            }
            this.remoteResourceNodes[i] = new ResourceEditionNode(remoteResource);
            this.remoteResourceNodes[i].setLocalResource(this.localResourceNodes[i]);
            ++i;
        }
    }

    public SVNLocalBaseCompareInput(ISVNLocalResource[] resources, SVNRevision revision) throws SVNException {
        this(resources, revision, false);
    }

    private void initLabels() {
        String rightLabel;
        String leftLabel;
        String title;
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftEditable(!this.readOnly);
        cc.setRightEditable(false);
        if (this.localResourceNodes.length > 1) {
            title = String.valueOf(Policy.bind("SVNLocalBaseCompareInput.0")) + this.remoteRevision;
            leftLabel = Policy.bind("SVNLocalBaseCompareInput.1");
            rightLabel = this.remoteRevision.toString();
        } else {
            title = Policy.bind("SVNCompareRevisionsInput.compareResourceAndVersions", new Object[]{this.localResourceNodes[0].getName()});
            leftLabel = Policy.bind("SVNCompareRevisionsInput.workspace", new Object[]{this.localResourceNodes[0].getName()});
            rightLabel = Policy.bind("SVNCompareRevisionsInput.repository", new Object[]{this.localResourceNodes[0].getName()});
        }
        this.setTitle(title);
        cc.setLeftLabel(leftLabel);
        cc.setRightLabel(rightLabel);
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        DiffNode diffNode;
        this.initLabels();
        MultipleSelectionNode left = new MultipleSelectionNode((Object[])this.localResourceNodes);
        MultipleSelectionNode right = new MultipleSelectionNode(this.remoteResourceNodes);
        Object differences = new StatusAwareDifferencer().findDifferences(false, monitor, null, null, left, right);
        if (differences instanceof DiffNode && !(diffNode = (DiffNode)differences).hasChildren()) {
            return null;
        }
        return differences;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveChanges(monitor);
        }
        catch (CoreException e) {
            Utils.handle(e);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void createPartControl(Composite parent) {
        this.createContents(parent);
    }

    public void dispose() {
    }

    public IWorkbenchPartSite getSite() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
    }
}

