/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.ClosableWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.CommentCommitWizardPage;
import org.tigris.subversion.subclipse.ui.wizards.IClosableWizard;
import org.tigris.subversion.subclipse.ui.wizards.MoveRemoteResourceWizardMainPage;

public class MoveRemoteResourceWizard
extends Wizard
implements IClosableWizard {
    private MoveRemoteResourceWizardMainPage mainPage;
    private CommentCommitWizardPage commitCommentPage;
    private ISVNRemoteResource selection;
    private Dialog parentDialog;

    public MoveRemoteResourceWizard(ISVNRemoteResource selection) {
        this.setWindowTitle(Policy.bind("moveRemoteFolderWizard.title"));
        this.selection = selection;
    }

    public void addPages() {
        this.mainPage = new MoveRemoteResourceWizardMainPage("newRemoteFolderPage1", Policy.bind("MoveRemoteFolderWizard.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newfolder_wizban.gif"));
        this.mainPage.setRemoteResource(this.selection);
        this.addPage((IWizardPage)this.mainPage);
        String pageTitle = Policy.bind("CommentCommitWizardPage.pageTitle");
        String pageDescription = Policy.bind("CommentCommitWizardPage.pageDescription");
        ImageDescriptor image = SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newfolder_wizban.gif");
        this.commitCommentPage = new CommentCommitWizardPage(this.parentDialog, pageTitle, pageTitle, image, pageDescription);
        this.addPage((IWizardPage)this.commitCommentPage);
    }

    public boolean performFinish() {
        try {
            SVNUIPlugin.runWithProgress(this.getContainer().getShell(), false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        SVNProviderPlugin.getPlugin().getRepositoryResourcesManager().moveRemoteResource(MoveRemoteResourceWizard.this.selection, MoveRemoteResourceWizard.this.mainPage.getParentFolder(), MoveRemoteResourceWizard.this.mainPage.getResourceName(), MoveRemoteResourceWizard.this.commitCommentPage.getComment(), monitor);
                    }
                    catch (SVNException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            SVNUIPlugin.openError(this.getContainer().getShell(), Policy.bind("exception"), null, e.getCause(), 1);
            return false;
        }
        return true;
    }

    public void setParentDialog(Dialog dialog) {
        this.parentDialog = dialog;
    }

    public void finishAndClose() {
        if (this.parentDialog != null && this.parentDialog instanceof ClosableWizardDialog && this.canFinish()) {
            ((ClosableWizardDialog)this.parentDialog).finishPressed();
        }
    }
}

