/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.swt.widgets.Shell;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.actions.PerlEditorAction;
import org.epic.perleditor.editors.PerlEditor;
import org.epic.perleditor.editors.util.SourceFormatter;
import org.epic.perleditor.editors.util.SourceRefactor;

public class ExtractSubroutineAction
extends PerlEditorAction {
    public ExtractSubroutineAction(PerlEditor editor) {
        super(editor);
    }

    @Override
    protected void doRun() {
        Shell shell = PerlEditorPlugin.getWorkbenchWindow().getShell();
        TextSelection selection = (TextSelection)this.getEditor().getSelectionProvider().getSelection();
        if (selection.getText().length() == 0) {
            MessageDialog.openInformation((Shell)shell, (String)"No selection", (String)"Nothing has been selected.");
            return;
        }
        InputDialog inputDialog = new InputDialog(shell, "Subroutine Name", "Name of Subroutine", "", null);
        int returnCode = inputDialog.open();
        if (returnCode != 0) {
            return;
        }
        String[] result = SourceRefactor.extractMethod(inputDialog.getValue(), selection.getText(), this.getLog());
        if (result.length == 0) {
            MessageDialog.openInformation((Shell)shell, (String)"Error", (String)"Subroutine could not be generated.");
            return;
        }
        if (result[0].endsWith("\n")) {
            result[0] = result[0].substring(0, result[0].lastIndexOf("\n"));
        }
        IDocument doc = this.getEditor().getDocumentProvider().getDocument((Object)this.getEditor().getEditorInput());
        try {
            doc.replace(selection.getOffset(), selection.getLength(), result[0]);
            int offset = -1;
            FindReplaceDocumentAdapter docFind = new FindReplaceDocumentAdapter(doc);
            IRegion regionEnd = docFind.find(selection.getOffset(), "^__END__", true, true, false, true);
            offset = regionEnd != null ? regionEnd.getOffset() : doc.getLength();
            String lineSep = this.getLineSeparator(doc.get());
            doc.replace(offset, 0, String.valueOf(lineSep) + SourceFormatter.format(result[1], this.getLog()));
        }
        catch (CoreException e) {
            this.log(e.getStatus());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getPerlEditorActionId() {
        return "org.epic.perleditor.actions.ExtractSubroutineAction";
    }

    private String getLineSeparator(String text) {
        String lineSep = System.getProperty("line.separator");
        if (text.indexOf(System.getProperty("line.separator")) == -1) {
            if (text.indexOf("\r\n") > 0) {
                lineSep = "\r\n";
            } else if (text.indexOf("\n") > 0) {
                lineSep = "\n";
            } else if (text.indexOf("\r") > 0) {
                lineSep = "\r";
            }
        }
        return lineSep;
    }
}

