/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.epic.core.util.MarkerUtilities;
import org.epic.perleditor.actions.PerlUserJobAction;
import org.epic.perleditor.editors.PerlEditor;
import org.epic.perleditor.editors.util.PodChecker;

public class PodCheckerAction
extends PerlUserJobAction {
    private static final String POD_MARKER = "org.epic.perleditor.markers.podChecker";

    public PodCheckerAction(PerlEditor editor) {
        super(editor);
    }

    @Override
    protected Map createMarkerAttributes(MarkerUtilities factory, Object violation) {
        HashMap attributes = new HashMap(3);
        PodChecker.Violation v = (PodChecker.Violation)violation;
        int severity = "error".equalsIgnoreCase(v.severity) ? 2 : 1;
        factory.setMessage(attributes, v.message);
        factory.setSeverity((Map)attributes, severity);
        factory.setLineNumber(attributes, v.lineNumber);
        return attributes;
    }

    @Override
    protected Object[] doJob(IResource resource) {
        return PodChecker.podchecker(resource, this.getLog());
    }

    @Override
    protected String getJobTitle(IResource resource) {
        return "Executing Pod::Checker against " + resource.getName();
    }

    @Override
    protected String getMarker() {
        return POD_MARKER;
    }

    @Override
    protected String getPerlEditorActionId() {
        return "org.epic.perleditor.actions.PodCheckerAction";
    }
}

