/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.epic.core.util.StatusFactory;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.PartitionTypes;

public class OccurrencesUpdater
implements ISelectionChangedListener {
    private static final Pattern LETTER_PATTERN = Pattern.compile("[a-zA-Z]||\\d");
    private static final String ANNOTATION_TYPE = "org.epic.perleditor.occurrence";
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z_&][a-zA-Z0-9_]*");
    private ISourceViewer sourceViewer;
    private final LinkedList annotations = new LinkedList();
    private String lastMarkedText = "";

    public void install(ISourceViewer sourceViewer) {
        assert (this.sourceViewer == null) : "already installed";
        this.sourceViewer = sourceViewer;
        ISelectionProvider selectionProvider = sourceViewer.getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
            provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        assert (this.annotations.isEmpty());
        this.updateAnnotations((ITextSelection)selectionProvider.getSelection());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ITextSelection textSelection = (ITextSelection)event.getSelection();
        this.updateAnnotations(textSelection);
    }

    public void uninstall() {
        assert (this.sourceViewer != null);
        ISelectionProvider selectionProvider = this.sourceViewer.getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.removeAnnotations();
        this.lastMarkedText = "";
        this.sourceViewer = null;
    }

    private void addAnnotation(String text, Map newAnnotations, int offset, int length) {
        Annotation annotation = new Annotation(ANNOTATION_TYPE, false, text);
        Position position = new Position(offset, length);
        this.annotations.add(annotation);
        newAnnotations.put(annotation, position);
    }

    private String getMarkedText(IDocument doc, ITextSelection textSelection) throws BadLocationException {
        String text;
        if (textSelection.getLength() < 1) {
            ITypedRegion typedRegion = PartitionTypes.getPerlPartitioner(doc).getPartition(textSelection.getOffset());
            text = doc.get(typedRegion.getOffset(), typedRegion.getLength());
        } else {
            text = textSelection.getText();
        }
        return text != null ? text : "";
    }

    private void markText(IDocument doc, String type, String text, IAnnotationModelExtension model) throws BadLocationException, BadPartitioningException {
        int offset = 0;
        String docText = doc.get();
        int index = docText.indexOf(text, offset);
        HashMap newAnnotations = new HashMap();
        while (index != -1) {
            String behind;
            offset = index + text.length();
            String contentType = PartitionTypes.getPerlPartition(doc, index).getType();
            if ((contentType.equals(type) || contentType.equals("LITERAL1") && type.equals("VARIABLE") || contentType.equals("VARIABLE") && type.equals("LITERAL1")) && offset < doc.getLength() && !LETTER_PATTERN.matcher(behind = "" + doc.getChar(offset)).matches()) {
                this.addAnnotation(text, newAnnotations, index, text.length());
            }
            index = docText.indexOf(text, offset);
        }
        model.replaceAnnotations(new Annotation[0], newAnnotations);
    }

    private void removeAnnotations() {
        IAnnotationModel _model = this.sourceViewer.getAnnotationModel();
        IAnnotationModelExtension model = (IAnnotationModelExtension)_model;
        Annotation[] array = this.annotations.toArray(new Annotation[this.annotations.size()]);
        if (model != null) {
            model.replaceAnnotations(array, Collections.EMPTY_MAP);
        }
        this.annotations.clear();
    }

    private boolean shouldMark(IDocument doc, ITextSelection selection) {
        IDocumentPartitioner partitioner = PartitionTypes.getPerlPartitioner(doc);
        ITypedRegion partition = partitioner.getPartition(selection.getOffset());
        String contentType = partition.getType();
        if (this.shouldMarkContentType(contentType)) {
            return true;
        }
        if (!this.getBoolPref("Occurrences.NAME")) {
            return false;
        }
        if (!contentType.equals("__dftl_partition_content_type")) {
            return false;
        }
        if (partition.getLength() < 3) {
            return false;
        }
        try {
            String text = doc.get(partition.getOffset(), partition.getLength());
            return NAME_PATTERN.matcher(text).matches();
        }
        catch (BadLocationException e) {
            this.logUnexpected(e);
            return false;
        }
    }

    private boolean shouldMarkContentType(String contentType) {
        if (contentType == null || contentType.equals("__dftl_partition_content_type")) {
            return false;
        }
        if (contentType.equals("VARIABLE") ? !this.getBoolPref("Occurrences.VARIABLE") : (contentType.equals("COMMENT") ? !this.getBoolPref("Occurrences.COMMENT") : (contentType.equals("KEYWORD1") || contentType.equals("KEYWORD2") ? !this.getBoolPref("Occurrences.KEYWORD") : (contentType.equals("LITERAL1") || contentType.equals("LITERAL2") ? !this.getBoolPref("Occurrences.LITERAL") : (contentType.equals("NUMBER") ? !this.getBoolPref("Occurrences.NUMBER") : contentType.equals("OPERATOR") && !this.getBoolPref("Occurrences.OPERATOR")))))) {
            return false;
        }
        return !contentType.equals("POD") || this.getBoolPref("Occurrences.POD");
    }

    private boolean getBoolPref(String name) {
        return PerlEditorPlugin.getDefault().getPreferenceStore().getBoolean(name);
    }

    private void updateAnnotations(ITextSelection textSelection) {
        IAnnotationModel _model = this.sourceViewer.getAnnotationModel();
        IAnnotationModelExtension model = (IAnnotationModelExtension)_model;
        if (model == null) {
            return;
        }
        IDocument doc = this.sourceViewer.getDocument();
        if (!this.getBoolPref("Occurrences.markOccurrences") || !this.shouldMark(doc, textSelection)) {
            if (!this.getBoolPref("Occurrences.keepMarks")) {
                this.lastMarkedText = "";
                this.removeAnnotations();
            }
            return;
        }
        try {
            String text = this.getMarkedText(doc, textSelection);
            if (text.equals(this.lastMarkedText)) {
                return;
            }
            this.lastMarkedText = text;
            this.removeAnnotations();
            String type = PartitionTypes.getPerlPartition(doc, textSelection.getOffset()).getType();
            this.markText(doc, type, text, model);
        }
        catch (BadPartitioningException e) {
            this.logUnexpected(e);
            this.lastMarkedText = "";
            this.removeAnnotations();
        }
        catch (BadLocationException e) {
            this.logUnexpected(e);
            this.lastMarkedText = "";
            this.removeAnnotations();
        }
    }

    private void logUnexpected(Throwable t) {
        PerlEditorPlugin.getDefault().getLog().log(StatusFactory.createError(PerlEditorPlugin.getPluginId(), "An unexpected exception occurred in OccurrencesUpdater", t));
    }
}

