/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.PartitionTypes;
import org.epic.perleditor.editors.PerlAnnotationHover;
import org.epic.perleditor.editors.PerlEditor;
import org.epic.perleditor.editors.PerlPresentationReconciler;
import org.epic.perleditor.editors.PerlReconcilingStrategy;
import org.epic.perleditor.editors.PerlSubHyperlinkDetector;
import org.epic.perleditor.editors.PerlTextHover;
import org.epic.perleditor.editors.perl.PerlAutoIndentStrategy;
import org.epic.perleditor.editors.perl.PerlCompletionProcessor;
import org.epic.perleditor.editors.perl.PerlDoubleClickSelector;
import org.epic.perleditor.editors.util.PreferenceUtil;

public class PerlSourceViewerConfiguration
extends SourceViewerConfiguration {
    private final IPreferenceStore prefs;
    private final PerlEditor editor;

    public PerlSourceViewerConfiguration(IPreferenceStore store, PerlEditor textEditor) {
        assert (store != null);
        this.prefs = store;
        this.editor = textEditor;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.editor == null) {
            return null;
        }
        return new PerlAnnotationHover(this.editor);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] iAutoEditStrategyArray;
        if ("COMMENT".equals(contentType)) {
            IAutoEditStrategy[] iAutoEditStrategyArray2 = new IAutoEditStrategy[1];
            iAutoEditStrategyArray = iAutoEditStrategyArray2;
            iAutoEditStrategyArray2[0] = new DefaultIndentLineAutoEditStrategy();
        } else {
            IAutoEditStrategy[] iAutoEditStrategyArray3 = new IAutoEditStrategy[1];
            iAutoEditStrategyArray = iAutoEditStrategyArray3;
            iAutoEditStrategyArray3[0] = new PerlAutoIndentStrategy();
        }
        return iAutoEditStrategyArray;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return PartitionTypes.getTypes();
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.editor == null) {
            return null;
        }
        ContentAssistant assistant = new ContentAssistant();
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < contentTypes.length) {
            assistant.setContentAssistProcessor((IContentAssistProcessor)new PerlCompletionProcessor(this.editor), contentTypes[i]);
            ++i;
        }
        assistant.enableAutoActivation(true);
        assistant.enableAutoInsert(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setContextInformationPopupBackground(PerlEditorPlugin.getDefault().getColor(new RGB(0, 0, 0)));
        assistant.setProposalSelectorBackground(PerlEditorPlugin.getDefault().getColor(new RGB(255, 255, 255)));
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"#", ""};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new PerlDoubleClickSelector();
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (this.editor == null) {
            return null;
        }
        IHyperlinkDetector[] superDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (superDetectors == null) {
            superDetectors = new IHyperlinkDetector[]{};
        }
        IHyperlinkDetector[] ourDetectors = new IHyperlinkDetector[superDetectors.length + 1];
        ourDetectors[ourDetectors.length - 1] = new PerlSubHyperlinkDetector(this.editor);
        return ourDetectors;
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{PreferenceUtil.getTab(0), "\t"};
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return this.prefs.getInt("editorTabWidth");
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.editor == null) {
            return null;
        }
        return new PerlTextHover(this.editor);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        return new PerlPresentationReconciler(this.prefs);
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.editor == null) {
            return null;
        }
        MonoReconciler r = new MonoReconciler((IReconcilingStrategy)new PerlReconcilingStrategy(sourceViewer, this.editor), false);
        r.setDelay(this.prefs.getInt("SYNTAX_VALIDATION_IDLE_INTERVAL"));
        return r;
    }
}

