/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.epic.core.util.ScriptExecutor;
import org.epic.core.util.StatusFactory;
import org.epic.perleditor.preferences.PerlCriticPreferencePage;

public class SourceCritic
extends ScriptExecutor {
    private static Violation[] EMPTY_ARRAY = new Violation[0];
    private IResource resource;

    protected SourceCritic(ILog log) {
        super(log);
    }

    public static Violation[] critique(IResource resource, ILog log) {
        IFile file = (IFile)resource;
        ArrayList<String> args = new ArrayList<String>(1);
        args.add(file.getRawLocation().toOSString());
        try {
            SourceCritic critic = new SourceCritic(log);
            critic.resource = resource;
            String output = critic.run(args).stdout;
            return critic.parseViolations(output);
        }
        catch (CoreException e) {
            log.log(e.getStatus());
            return EMPTY_ARRAY;
        }
    }

    @Override
    protected List getCommandLineOpts(List additionalOptions) {
        if (additionalOptions == null || additionalOptions.isEmpty()) {
            additionalOptions = new ArrayList<String>(2);
        }
        IFile rc = this.resource.getProject().getFile(".perlcriticrc");
        try {
            rc.refreshLocal(0, null);
        }
        catch (CoreException e) {
            this.log(e.getStatus());
        }
        if (rc.exists()) {
            additionalOptions.add("-profile");
            additionalOptions.add(rc.getRawLocation().toOSString());
        }
        additionalOptions.add("-verbose");
        additionalOptions.add("%f~|~%s~|~%l~|~%c~|~%m~|~%e" + this.getSystemLineSeparator());
        return additionalOptions;
    }

    @Override
    protected String getExecutable() {
        return PerlCriticPreferencePage.getPerlCritic();
    }

    @Override
    protected String getScriptDir() {
        return "";
    }

    private final Violation parseLine(String toParse) {
        String[] tmp = toParse.split("~\\|~");
        if (tmp.length != 6) {
            return null;
        }
        Violation violation = new Violation();
        violation.file = tmp[0];
        violation.severity = this.parseInt(tmp[1]);
        violation.lineNumber = this.parseInt(tmp[2]);
        violation.column = this.parseInt(tmp[3]);
        violation.message = tmp[4];
        violation.pbp = tmp[5];
        return violation;
    }

    private final Violation[] parseViolations(String toParse) {
        String separator = this.getLineSeparator(toParse);
        if (toParse == null || "".equals(toParse) || toParse.endsWith("OK" + separator)) {
            return EMPTY_ARRAY;
        }
        String[] lines = toParse.split(separator);
        ArrayList<Violation> violations = new ArrayList<Violation>();
        int i = 0;
        while (i < lines.length) {
            System.out.println("critic: " + lines[i]);
            Violation v = this.parseLine(lines[i]);
            if (v != null) {
                violations.add(v);
            }
            ++i;
        }
        if (violations.size() == 0) {
            this.log(StatusFactory.createWarning(this.getPluginId(), "Perl::Critic violations.length == 0, output change?"));
        }
        return violations.toArray(new Violation[violations.size()]);
    }

    public static class Violation {
        public int column;
        public String file;
        public int lineNumber;
        public String message;
        public String pbp;
        public int severity;
    }
}

