/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates;

import java.io.File;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.templates.TemplateMessages;
import org.epic.perleditor.templates.TemplateSet;

public class Templates
extends TemplateSet {
    private static final String DEFAULT_FILE = "default-templates.xml";
    private static final String TEMPLATE_FILE = "templates.xml";
    private static Templates fgTemplates;

    public static Templates getInstance() {
        if (fgTemplates == null) {
            fgTemplates = Templates.create();
        }
        return fgTemplates;
    }

    private static Templates create() {
        Templates templates = new Templates();
        try {
            File templateFile = Templates.getTemplateFile();
            if (templateFile.exists()) {
                templates.addFromFile(templateFile);
            } else {
                templates.addFromStream(Templates.getDefaultsAsStream());
                templates.saveToFile(templateFile);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            ErrorDialog.openError(null, (String)TemplateMessages.getString("Templates.error.title"), (String)e.getMessage(), (IStatus)e.getStatus());
            templates.clear();
        }
        return templates;
    }

    public void reset() throws CoreException {
        this.clear();
        this.addFromFile(Templates.getTemplateFile());
    }

    public void restoreDefaults() throws CoreException {
        this.clear();
        this.addFromStream(Templates.getDefaultsAsStream());
    }

    public void save() throws CoreException {
        this.saveToFile(Templates.getTemplateFile());
    }

    private static InputStream getDefaultsAsStream() {
        return Templates.class.getResourceAsStream(DEFAULT_FILE);
    }

    private static File getTemplateFile() {
        IPath path = PerlEditorPlugin.getDefault().getStateLocation();
        path = path.append(TEMPLATE_FILE);
        return path.toFile();
    }
}

