/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.epic.core.model.IPackageElement;
import org.epic.core.model.ISourceFileListener;
import org.epic.core.model.ModuleUse;
import org.epic.core.model.Package;
import org.epic.core.model.SourceFile;
import org.epic.core.model.Subroutine;

public class PerlOutlineContentProvider
implements ITreeContentProvider {
    static final String MODULES = " Modules";
    static final String SUBROUTINES = " Subroutines";
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final List prevSubsContent;
    private final List prevUsesContent;
    private final ISourceFileListener listener = new ISourceFileListener(){

        @Override
        public void sourceFileChanged(SourceFile source) {
            PerlOutlineContentProvider.this.modelChanged();
        }
    };
    private SourceFile model;
    private TreeViewer viewer;

    public PerlOutlineContentProvider() {
        this.prevSubsContent = new ArrayList();
        this.prevUsesContent = new ArrayList();
    }

    public void dispose() {
        if (this.model != null) {
            this.model.removeListener(this.listener);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput instanceof SourceFile) {
            ((SourceFile)oldInput).removeListener(this.listener);
        }
        this.model = (SourceFile)newInput;
        this.viewer = (TreeViewer)viewer;
        this.rememberContent();
        if (this.model != null) {
            this.model.addListener(this.listener);
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof SourceFile) {
            return this.model.getPackages().toArray();
        }
        if (parentElement instanceof Package) {
            Package pkg = (Package)parentElement;
            Object[] ret = new PackageElem[]{new PackageElem(pkg, MODULES), new PackageElem(pkg, SUBROUTINES)};
            return ret;
        }
        if (parentElement instanceof PackageElem) {
            PackageElem elem = (PackageElem)parentElement;
            if (elem.name.equals(MODULES)) {
                return elem.pkg.getUses().toArray();
            }
            if (elem.name.equals(SUBROUTINES)) {
                return elem.pkg.getSubs().toArray();
            }
            assert (false);
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof Subroutine) {
            return ((Subroutine)element).getParent();
        }
        if (element instanceof ModuleUse) {
            return ((ModuleUse)element).getParent();
        }
        if (element instanceof PackageElem) {
            return ((PackageElem)element).pkg;
        }
        if (element instanceof Package) {
            return this.model;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    private boolean contentChanged() {
        return this.packageContentChanged(this.model.getSubs(), this.prevSubsContent.iterator()) || this.packageContentChanged(this.model.getUses(), this.prevUsesContent.iterator());
    }

    private boolean packageContentChanged(Iterator curContent, Iterator prevContent) {
        while (curContent.hasNext() && prevContent.hasNext()) {
            IPackageElement prevElem;
            IPackageElement curElem = (IPackageElement)curContent.next();
            if (!this.packageElementsDiffer(curElem, prevElem = (IPackageElement)prevContent.next())) continue;
            return true;
        }
        return curContent.hasNext() ^ prevContent.hasNext();
    }

    private boolean packageElementsDiffer(IPackageElement curElem, IPackageElement prevElem) {
        return !curElem.getName().equals(prevElem.getName()) || curElem.getOffset() != prevElem.getOffset() || !curElem.getParent().getName().equals(prevElem.getParent().getName());
    }

    private void modelChanged() {
        if (this.contentChanged()) {
            this.updateViewer();
            this.rememberContent();
        }
    }

    private void rememberContent() {
        this.prevSubsContent.clear();
        this.prevUsesContent.clear();
        if (this.model != null) {
            Iterator i = this.model.getSubs();
            while (i.hasNext()) {
                this.prevSubsContent.add(i.next());
            }
            i = this.model.getUses();
            while (i.hasNext()) {
                this.prevUsesContent.add(i.next());
            }
        }
    }

    private void updateViewer() {
        this.viewer.refresh();
        this.viewer.expandToLevel(3);
    }

    public static class PackageElem {
        public final Package pkg;
        public final String name;

        public PackageElem(Package pkg, String name) {
            this.pkg = pkg;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PackageElem) {
                obj = ((PackageElem)obj).pkg;
            } else if (!(obj instanceof Package)) {
                return false;
            }
            Package pkg = (Package)obj;
            return pkg.equals(this.pkg) && this.name.equals(this.name);
        }

        public int hashCode() {
            return this.pkg.hashCode() * 37 + this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

