/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.identity;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.GUID;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.identity.LongID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.NamespacePermission;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.internal.core.identity.Activator;

public class IDFactory
implements IIDFactory {
    public static final String SECURITY_PROPERTY;
    private static final int IDENTITY_CREATION_ERRORCODE = 2001;
    private static Hashtable namespaces;
    private static boolean securityEnabled;
    protected static IIDFactory instance;
    private static boolean initialized;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SECURITY_PROPERTY = String.valueOf(clazz.getName()) + ".security";
        namespaces = new Hashtable();
        securityEnabled = false;
        instance = null;
        instance = new IDFactory();
        IDFactory.addNamespace0(new StringID.StringIDNamespace());
        IDFactory.addNamespace0(new GUID.GUIDNamespace());
        IDFactory.addNamespace0(new LongID.LongNamespace());
        initialized = false;
    }

    private static synchronized void initialize() {
        if (!initialized) {
            Activator a = Activator.getDefault();
            if (a != null) {
                a.setupNamespaceExtensionPoint();
            }
            initialized = true;
        }
    }

    public static synchronized IIDFactory getDefault() {
        return instance;
    }

    private IDFactory() {
    }

    public Namespace addNamespace(Namespace namespace) throws SecurityException {
        if (namespace == null) {
            return null;
        }
        IDFactory.checkPermission(new NamespacePermission(namespace.toString(), "add"));
        IDFactory.initialize();
        return IDFactory.addNamespace0(namespace);
    }

    public static final Namespace addNamespace0(Namespace namespace) {
        if (namespace == null) {
            return null;
        }
        return namespaces.put(namespace.getName(), namespace);
    }

    protected static final void checkPermission(NamespacePermission namespacepermission) throws SecurityException {
        if (securityEnabled) {
            AccessController.checkPermission(namespacepermission);
        }
    }

    public boolean containsNamespace(Namespace namespace) throws SecurityException {
        if (namespace == null) {
            return false;
        }
        IDFactory.checkPermission(new NamespacePermission(namespace.toString(), "contains"));
        IDFactory.initialize();
        return IDFactory.containsNamespace0(namespace);
    }

    public List getNamespaces() {
        IDFactory.initialize();
        return new ArrayList(namespaces.values());
    }

    public static final boolean containsNamespace0(Namespace n) {
        if (n == null) {
            return false;
        }
        return namespaces.containsKey(n.getName());
    }

    public Namespace getNamespace(Namespace namespace) throws SecurityException {
        if (namespace == null) {
            return null;
        }
        IDFactory.checkPermission(new NamespacePermission(namespace.toString(), "get"));
        IDFactory.initialize();
        return IDFactory.getNamespace0(namespace);
    }

    public Namespace getNamespaceByName(String name) throws SecurityException {
        IDFactory.initialize();
        return IDFactory.getNamespace0(name);
    }

    protected static final Namespace getNamespace0(Namespace n) {
        if (n == null) {
            return null;
        }
        return (Namespace)namespaces.get(n.getName());
    }

    protected static final Namespace getNamespace0(String name) {
        if (name == null) {
            return null;
        }
        return (Namespace)namespaces.get(name);
    }

    public ID createGUID() throws IDCreateException {
        return this.createGUID(20);
    }

    public ID createGUID(int length) throws IDCreateException {
        return this.createID((Namespace)new GUID.GUIDNamespace(), (Object[])new Integer[]{new Integer(length)});
    }

    protected static void logAndThrow(String s, Throwable t) throws IDCreateException {
        IDCreateException e = null;
        e = t != null ? new IDCreateException(String.valueOf(s) + ": " + t.getClass().getName() + ": " + t.getMessage(), t) : new IDCreateException(s);
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.identity", 2001, s, (Throwable)e));
        throw e;
    }

    public ID createID(Namespace n, Object[] args) throws IDCreateException {
        if (n == null) {
            IDFactory.logAndThrow("Namespace cannot be null", null);
        }
        IDFactory.initialize();
        Namespace ns = IDFactory.getNamespace0(n);
        if (ns == null) {
            IDFactory.logAndThrow("Namespace " + n.getName() + " not found", null);
        }
        return ns.createInstance(args);
    }

    public ID createID(String namespaceName, Object[] args) throws IDCreateException {
        Namespace n = this.getNamespaceByName(namespaceName);
        if (n == null) {
            throw new IDCreateException("Namespace " + namespaceName + " not found");
        }
        return this.createID(n, args);
    }

    public ID createID(Namespace namespace, String uri) throws IDCreateException {
        return this.createID(namespace, new Object[]{uri});
    }

    public ID createID(String namespace, String uri) throws IDCreateException {
        return this.createID(namespace, new Object[]{uri});
    }

    public ID createStringID(String idstring) throws IDCreateException {
        if (idstring == null) {
            throw new IDCreateException("StringID cannot be null");
        }
        return this.createID((Namespace)new StringID.StringIDNamespace(), (Object[])new String[]{idstring});
    }

    public ID createLongID(long l) throws IDCreateException {
        return this.createID((Namespace)new LongID.LongNamespace(), (Object[])new Long[]{new Long(l)});
    }

    public Namespace removeNamespace(Namespace n) throws SecurityException {
        if (n == null) {
            return null;
        }
        IDFactory.checkPermission(new NamespacePermission(n.toString(), "remove"));
        IDFactory.initialize();
        return IDFactory.removeNamespace0(n);
    }

    protected static final Namespace removeNamespace0(Namespace n) {
        if (n == null) {
            return null;
        }
        return (Namespace)namespaces.remove(n.getName());
    }
}

