/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import org.eclipse.jface.viewers.StructuredViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSequenceInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSequenceSearcher;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.Schema;

public class OracleSequeceSearchAction
implements Runnable {
    private StructuredViewer viewer;
    private Folder folder;

    public OracleSequeceSearchAction(StructuredViewer viewer, Folder folder) {
        this.viewer = viewer;
        this.folder = folder;
    }

    public void run() {
        try {
            Connection con = Transaction.getInstance(this.folder.getDbConfig()).getConnection();
            Schema schema = (Schema)this.folder.getParent();
            String owner = schema.getName();
            OracleSequenceInfo[] infos = OracleSequenceSearcher.execute(con, owner);
            OracleSequeceSearchAction.AddSequences(con, this.folder, infos);
            if (this.viewer != null) {
                this.viewer.refresh((Object)this.folder);
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private static void AddSequences(Connection con, Folder folder, OracleSequenceInfo[] infos) throws Exception {
        int i = 0;
        while (i < infos.length) {
            OracleSequence seq = new OracleSequence();
            seq.setOracleSequenceInfo(infos[i]);
            folder.addChild(seq);
            ++i;
        }
    }
}

