/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.actions.ITableViewEditorAction;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.editors.ITableViewEditor;

public abstract class TableViewEditorAction
extends Action
implements Runnable,
ITableViewEditorAction {
    protected IStructuredSelection selection;
    protected ITableViewEditor editor;
    protected IDBConfig config;

    public void selectionChanged(ISelection _selection) {
        this.selection = _selection instanceof IStructuredSelection ? (IStructuredSelection)_selection : null;
    }

    public void setActiveEditor(ITableViewEditor target) {
        if (target != null) {
            this.editor = target;
            this.config = target.getDBConfig();
        } else {
            this.editor = null;
            this.config = null;
        }
    }

    public void setImage(int operation) {
        String imageName = null;
        switch (operation) {
            case 4: {
                imageName = "IMG_TOOL_COPY";
                this.setText(Messages.getString("TableViewEditorAction.CopyRecord"));
                this.setAccelerator(262211);
                break;
            }
            case 5: {
                imageName = "IMG_TOOL_PASTE";
                this.setText(Messages.getString("TableViewEditorAction.PasteRecord"));
                this.setAccelerator(262230);
                break;
            }
            case 6: {
                imageName = "IMG_TOOL_DELETE";
                this.setText(Messages.getString("TableViewEditorAction.DeleteRecord"));
                this.setAccelerator(127);
                break;
            }
            case 7: {
                this.setText(Messages.getString("TableViewEditorAction.SelectAll"));
                this.setAccelerator(262209);
                imageName = null;
                break;
            }
        }
        if (imageName != null) {
            this.setImageDescriptor(imageName);
        }
    }

    protected void setImageDescriptor(String imageName) {
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imageName));
    }
}

