/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.contentassist;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.SchemaInfo;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TableSearcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.AbstractStatementFactory;
import zigen.plugin.db.ui.actions.ConfirmConnectDBAction;
import zigen.plugin.db.ui.contentassist.ContentAssistUtil;
import zigen.plugin.db.ui.contentassist.ObjectCacher;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ContentAssistTable;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.views.TreeView;

public class ContentInfo {
    IDBConfig config;
    Transaction trans;
    boolean isConnected = false;
    String currentSchema = null;
    Map schemaInfoMap = null;
    char encloseChar;

    public ContentInfo(IDBConfig config) {
        this.config = config;
        if (config != null) {
            this.configure();
        } else {
            DbPlugin.log("There is no data base definition.");
        }
    }

    private void configure() {
        try {
            this.trans = Transaction.getInstance(this.config);
            if (this.trans.isConneting()) {
                this.isConnected = true;
                this.encloseChar = AbstractStatementFactory.getFactory(this.config).getEncloseChar();
                this.schemaInfoMap = this.getSchemas();
                this.currentSchema = this.findCurrentSchema();
                DbPlugin.fireStatusChangeListener(this.config, 106);
            } else {
                Display.getDefault().syncExec((Runnable)new ConfirmConnectDBAction(this.trans));
                if (this.trans.isConneting()) {
                    this.configure();
                } else {
                    this.isConnected = false;
                }
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    private String findCurrentSchema() throws Exception {
        DbPlugin.getDefault();
        TreeView tw = (TreeView)DbPlugin.findView("zigen.plugin.db.ui.views.TreeView");
        if (tw != null) {
            DataBase db = tw.getContentProvider().findDataBase(this.config);
            if (SchemaSearcher.isSupport(this.trans.getConnection())) {
                List list = db.getChildren();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    TreeNode node = (TreeNode)iterator.next();
                    if (node instanceof Schema) {
                        Schema schema = (Schema)node;
                        if (!schema.getName().equalsIgnoreCase(this.config.getSchema())) continue;
                        return schema.getName();
                    }
                    throw new IllegalStateException("Schema is not found.");
                }
                throw new IllegalStateException("schema name is wrong.");
            }
            return null;
        }
        return this.findCorrectSchema(this.config.getSchema().toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getSchemas() throws Exception {
        ObjectCacher holder;
        HashMap<String, SchemaInfo> map = null;
        ObjectCacher objectCacher = holder = ObjectCacher.getInstance("@" + this.config.getDbName());
        synchronized (objectCacher) {
            map = (HashMap<String, SchemaInfo>)holder.get();
            if (map == null) {
                map = new HashMap<String, SchemaInfo>();
                try {
                    String[] result = SchemaSearcher.execute(this.trans.getConnection());
                    int i = 0;
                    while (i < result.length) {
                        String schema = result[i];
                        schema = SQLUtil.enclose(schema, this.encloseChar);
                        SchemaInfo info = new SchemaInfo(this.config, schema);
                        map.put(schema.toUpperCase(), info);
                        ++i;
                    }
                }
                catch (Exception e) {
                    DbPlugin.log(e);
                }
                holder.put(map);
            }
        }
        return map;
    }

    public TableInfo[] getTableInfo() throws Exception {
        return this.getTableInfo(this.currentSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableInfo[] getTableInfo(String schemaName) throws Exception {
        ObjectCacher holder;
        if (this.config == null) {
            return null;
        }
        schemaName = SQLUtil.removeEnclosedChar(schemaName, this.encloseChar);
        String[] tableTypes = null;
        switch (this.config.getDbType()) {
            case 1: {
                tableTypes = new String[]{"TABLE", "VIEW", "SYNONYM"};
                break;
            }
            default: {
                tableTypes = new String[]{"TABLE", "VIEW"};
            }
        }
        TableInfo[] result = null;
        String keySchemaName = schemaName != null ? schemaName : this.config.getDbName();
        ObjectCacher objectCacher = holder = ObjectCacher.getInstance(String.valueOf(keySchemaName) + "@" + this.config.getDbName());
        synchronized (objectCacher) {
            result = (TableInfo[])holder.get();
            if (result == null) {
                try {
                    result = schemaName != null ? TableSearcher.execute(this.trans.getConnection(), schemaName, tableTypes, new Character(this.encloseChar)) : TableSearcher.execute(this.trans.getConnection(), null, tableTypes, new Character(this.encloseChar));
                }
                catch (Exception e) {
                    DbPlugin.log(e);
                }
                holder.put(result);
            }
        }
        return result;
    }

    public Column[] getColumns(String tableName) {
        return this.getColumns(this.currentSchema, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column[] getColumns(String schemaName, String tableName) {
        ObjectCacher holder;
        schemaName = SQLUtil.removeEnclosedChar(schemaName, this.encloseChar);
        tableName = SQLUtil.removeEnclosedChar(tableName, this.encloseChar);
        Column[] result = null;
        ObjectCacher objectCacher = holder = ObjectCacher.getInstance(String.valueOf(tableName) + "@" + schemaName + "@" + this.config.getDbName());
        synchronized (objectCacher) {
            result = (Column[])holder.get();
            if (result == null) {
                ContentAssistTable table = ContentAssistUtil.createContentAssistTable(schemaName, tableName);
                result = table.getColumns();
                holder.put(result);
            }
        }
        return result;
    }

    public String findCorrectSchema(String target) {
        SchemaInfo info = (SchemaInfo)this.schemaInfoMap.get(target.toUpperCase());
        if (info != null) {
            return info.getName();
        }
        return null;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public IDBConfig getConfig() {
        return this.config;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public SchemaInfo[] getSchemaInfos() {
        if (this.schemaInfoMap == null) {
            return null;
        }
        SchemaInfo[] infos = new SchemaInfo[this.schemaInfoMap.size()];
        int i = 0;
        Iterator iterator = this.schemaInfoMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            infos[i++] = (SchemaInfo)this.schemaInfoMap.get(key);
        }
        return infos;
    }
}

