/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.internal;

import java.util.ArrayList;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.internal.TreeNode;

public class Table
extends TreeNode
implements ITable {
    private static final long serialVersionUID = 1L;
    String remarks;
    TablePKColumn[] tablePKColumns = null;
    TableFKColumn[] tableFKColumns = null;
    TableConstraintColumn[] tableConstraintColumns = null;
    TableIDXColumn[] tableUIDXColumns = null;
    TableIDXColumn[] tableNonUIDXColumns = null;

    public Table(String name, String remarks) {
        super(name);
        this.remarks = remarks;
    }

    public Table(String name) {
        super(name);
    }

    public Table() {
    }

    public void update(Table node) {
        this.remarks = node.remarks;
        this.tablePKColumns = node.tablePKColumns;
        this.tableFKColumns = node.tableFKColumns;
        this.tableUIDXColumns = node.tableUIDXColumns;
        this.tableNonUIDXColumns = node.tableNonUIDXColumns;
    }

    public String getLabel() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        if (this.remarks != null && this.remarks.length() > 0) {
            sb.append(" [");
            sb.append(this.remarks);
            sb.append("]");
        }
        return sb.toString();
    }

    public String getRemarks() {
        return this.remarks == null ? "" : this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    protected Column[] convertColumns(TreeLeaf[] leafs) {
        ArrayList<Column> list = new ArrayList<Column>(leafs.length);
        int i = 0;
        while (i < leafs.length) {
            if (leafs[i] instanceof Column) {
                list.add((Column)leafs[i]);
            }
            ++i;
        }
        return list.toArray(new Column[0]);
    }

    public Column[] getColumns() {
        return this.convertColumns(this.getChildrens());
    }

    public String getEnclosedName() {
        return SQLUtil.enclose(this.name, this.getDataBase().getEncloseChar());
    }

    public String getSqlTableName() {
        StringBuffer sb = new StringBuffer();
        if (this.getDataBase().isSchemaSupport()) {
            sb.append(this.getSchema().getEscapedName());
            sb.append(".");
            sb.append(this.getEnclosedName());
        } else {
            sb.append(this.getEnclosedName());
        }
        return sb.toString();
    }

    public String getSchemaName() {
        if (this.getSchema() != null) {
            return this.getSchema().getName();
        }
        return null;
    }

    public boolean isSchemaSupport() {
        return this.getDataBase().isSchemaSupport;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Table castedObj = (Table)o;
        IDBConfig config = castedObj.getDbConfig();
        Schema schema = castedObj.getSchema();
        if (config == null) {
            return false;
        }
        return castedObj.getName().equals(this.getName()) && config.equals(this.getDbConfig()) && schema.equals(this.getSchema());
    }

    public Object clone() {
        Table inst = new Table();
        inst.name = this.name == null ? null : new String(this.name);
        inst.remarks = this.remarks == null ? null : new String(this.remarks);
        return inst;
    }

    public TableFKColumn[] getTableFKColumns() {
        return this.tableFKColumns;
    }

    public TablePKColumn[] getTablePKColumns() {
        return this.tablePKColumns;
    }

    public void setTableFKColumns(TableFKColumn[] tableFKColumns) {
        this.tableFKColumns = tableFKColumns;
    }

    public void setTablePKColumns(TablePKColumn[] tablePKColumns) {
        this.tablePKColumns = tablePKColumns;
    }

    public TableIDXColumn[] getTableUIDXColumns() {
        return this.tableUIDXColumns;
    }

    public void setTableUIDXColumns(TableIDXColumn[] tableUIDXColumns) {
        this.tableUIDXColumns = tableUIDXColumns;
    }

    public TableIDXColumn[] getTableNonUIDXColumns() {
        return this.tableNonUIDXColumns;
    }

    public void setTableNonUIDXColumns(TableIDXColumn[] tableNonUIDXColumns) {
        this.tableNonUIDXColumns = tableNonUIDXColumns;
    }

    public String getFolderName() {
        if (this.getFolder() != null) {
            return this.getFolder().getName();
        }
        return null;
    }

    public TableConstraintColumn[] getTableConstraintColumns() {
        return this.tableConstraintColumns;
    }

    public void setTableConstraintColumns(TableConstraintColumn[] tableConstraintColumns) {
        this.tableConstraintColumns = tableConstraintColumns;
    }
}

