/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.status;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.GetInfoCommand;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.status.IStatusCache;
import org.tigris.subversion.subclipse.core.status.NonRecursiveStatusUpdateStrategy;
import org.tigris.subversion.subclipse.core.status.RecursiveStatusUpdateStrategy;
import org.tigris.subversion.subclipse.core.status.StatusUpdateStrategy;
import org.tigris.subversion.subclipse.core.status.SynchronizerSyncInfoCache;
import org.tigris.subversion.subclipse.core.util.JobUtility;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class StatusCacheManager
implements IResourceChangeListener,
Preferences.IPropertyChangeListener {
    public static final QualifiedName SVN_BC_SYNC_KEY = new QualifiedName("org.tigris.subversion.subclipse.core", "svn-bc-sync-key");
    private IStatusCache statusCache;
    private StatusUpdateStrategy statusUpdateStrategy;
    private boolean flushCache;

    public StatusCacheManager() {
        this.chooseUpdateStrategy();
        ResourcesPlugin.getWorkspace().getSynchronizer().add(SVN_BC_SYNC_KEY);
        this.statusCache = new SynchronizerSyncInfoCache();
    }

    private void chooseUpdateStrategy() {
        boolean recursiveStatusUpdate = SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("resursive_status_update");
        this.statusUpdateStrategy = recursiveStatusUpdate ? new RecursiveStatusUpdateStrategy(this.statusCache) : new NonRecursiveStatusUpdateStrategy(this.statusCache);
    }

    public boolean hasCachedStatus(IResource resource) {
        return this.statusCache.hasCachedStatus(resource);
    }

    protected List updateCache(IResource parent, ISVNStatus[] statuses) throws CoreException {
        ArrayList<IResource> result = new ArrayList<IResource>(statuses.length);
        int i = 0;
        while (i < statuses.length) {
            IResource resource = SVNWorkspaceRoot.getResourceFor(parent, statuses[i]);
            result.add(this.updateCache(resource, statuses[i]));
            ++i;
        }
        return result;
    }

    protected IResource updateCache(IResource resource, ISVNStatus status) {
        return this.statusCache.addStatus(resource, new LocalResourceStatus(status, this.getURL(status)));
    }

    public LocalResourceStatus getStatus(IResource resource) throws SVNException {
        return this.getStatus(resource, this.statusUpdateStrategy, true);
    }

    public LocalResourceStatus getStatusFromCache(IResource resource) throws SVNException {
        return this.getStatus(resource, this.statusUpdateStrategy, false);
    }

    public LocalResourceStatus getStatus(IResource resource, boolean useRecursiveStartegy) throws SVNException {
        return this.getStatus(resource, useRecursiveStartegy ? new RecursiveStatusUpdateStrategy(this.statusCache) : new NonRecursiveStatusUpdateStrategy(this.statusCache), true);
    }

    public SVNRevision getResourceRevision(ISVNLocalResource resource) throws SVNException {
        if (resource == null) {
            return null;
        }
        GetInfoCommand command = new GetInfoCommand(resource);
        command.run(null);
        ISVNInfo info = command.getInfo();
        return info != null ? info.getRevision() : null;
    }

    private LocalResourceStatus getStatus(IResource resource, StatusUpdateStrategy strategy, boolean getStatusFromSvn) throws SVNException {
        if (!resource.exists() && !resource.isPhantom()) {
            return null;
        }
        LocalResourceStatus status = null;
        status = this.statusCache.getStatus(resource);
        if (status == null && getStatusFromSvn) {
            status = this.basicGetStatus(resource, strategy);
        }
        return status;
    }

    private LocalResourceStatus basicGetStatus(IResource resource, StatusUpdateStrategy strategy) throws SVNException {
        if (!resource.exists()) {
            return LocalResourceStatus.NONE;
        }
        LocalResourceStatus status = null;
        strategy.setStatusCache(this.statusCache);
        this.setStatuses(resource, strategy.statusesToUpdate(resource));
        status = this.statusCache.getStatus(resource);
        if (status == null && resource != null && resource.getLocation() != null) {
            status = new LocalResourceStatus((ISVNStatus)new SVNStatusUnversioned(resource.getLocation().toFile(), false), null);
        }
        return status;
    }

    public void setStatuses(IResource parent, ISVNStatus[] statuses) throws SVNException {
        try {
            this.updateCache(parent, statuses);
        }
        catch (CoreException e) {
            throw SVNException.wrapException(e);
        }
    }

    public IResource[] refreshStatus(IContainer resource, boolean recursive) throws SVNException {
        if (SVNWorkspaceRoot.isLinkedResource((IResource)resource)) {
            return new IResource[0];
        }
        int depth = recursive ? 2 : 1;
        StatusUpdateStrategy strategy = depth == 2 ? new RecursiveStatusUpdateStrategy(this.statusCache) : new NonRecursiveStatusUpdateStrategy(this.statusCache);
        try {
            List refreshedResources = this.updateCache((IResource)resource, strategy.statusesToUpdate((IResource)resource));
            Set resourcesToRefresh = this.resourcesToRefresh((IResource)resource, depth, 1, refreshedResources.size());
            Iterator iter = refreshedResources.iterator();
            while (iter.hasNext()) {
                resourcesToRefresh.remove(iter.next());
            }
            Iterator it = resourcesToRefresh.iterator();
            while (it.hasNext()) {
                IResource res = (IResource)it.next();
                if (res.getType() != 1 && res.isPhantom()) {
                    Set children = this.resourcesToRefresh(res, 2, 3, 0);
                    Iterator iter2 = children.iterator();
                    while (iter2.hasNext()) {
                        IResource child = (IResource)iter2.next();
                        this.statusCache.removeStatus(child);
                        refreshedResources.add(child);
                    }
                }
                this.statusCache.removeStatus(res);
                refreshedResources.add(res);
            }
            return refreshedResources.toArray(new IResource[refreshedResources.size()]);
        }
        catch (CoreException e) {
            throw SVNException.wrapException(e);
        }
    }

    private Set resourcesToRefresh(IResource resource, int depth, int flags, int expectedSize) throws CoreException {
        if (!resource.exists() && !resource.isPhantom()) {
            return new HashSet(0);
        }
        final HashSet resultSet = expectedSize != 0 ? new HashSet(expectedSize) : new HashSet();
        resource.accept(new IResourceVisitor(){

            public boolean visit(IResource aResource) throws CoreException {
                resultSet.add(aResource);
                return true;
            }
        }, depth, flags);
        return resultSet;
    }

    public void purgeCache(IContainer root, boolean deep) throws SVNException {
        this.statusCache.purgeCache(root, deep);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if ("resursive_status_update".equals(event.getProperty())) {
            this.chooseUpdateStrategy();
        }
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        JobUtility.scheduleJob("StatusCacheOperation", new Runnable(){

            public void run() {
                StatusCacheManager.this.flushCache = false;
                try {
                    event.getDelta().accept(new IResourceDeltaVisitor(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IResource resource = delta.getResource();
                            if (resource.getType() == 4) {
                                IProject project = (IProject)resource;
                                if (!project.isAccessible()) {
                                    return false;
                                }
                                if (SVNWorkspaceRoot.isManagedBySubclipse(project)) {
                                    StatusCacheManager.access$0(2.access$0(this.this$1), true);
                                }
                                return false;
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    SVNProviderPlugin.log(e.getStatus());
                }
                if (StatusCacheManager.this.flushCache) {
                    StatusCacheManager.this.statusCache.flushPendingStatuses();
                }
            }

            static /* synthetic */ StatusCacheManager access$0(2 var0) {
                return var0.StatusCacheManager.this;
            }
        }, null, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getURL(ISVNStatus status) {
        String url = status.getUrlString();
        if (url != null) return url;
        if (status.getTextStatus() == SVNStatusKind.UNVERSIONED) return url;
        if (status.getTextStatus() == SVNStatusKind.IGNORED) return url;
        try {
            try {
                ISVNClientAdapter svnClient = SVNProviderPlugin.getPlugin().getSVNClient();
                SVNProviderPlugin.disableConsoleLogging();
                ISVNInfo info = svnClient.getInfoFromWorkingCopy(status.getFile());
                SVNUrl svnurl = info.getUrl();
                url = svnurl != null ? svnurl.toString() : null;
            }
            catch (SVNException sVNException) {
            }
            catch (SVNClientException sVNClientException) {}
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            SVNProviderPlugin.enableConsoleLogging();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        SVNProviderPlugin.enableConsoleLogging();
        return url;
    }
}

