/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;

public class Util {
    public static final String CURRENT_LOCAL_FOLDER = ".";
    public static final String SERVER_SEPARATOR = "/";

    public static String getLastSegment(String path) {
        int index = path.lastIndexOf(SERVER_SEPARATOR);
        if (index == -1) {
            return path;
        }
        return path.substring(index + 1);
    }

    public static String appendPath(String prefix, String suffix) {
        if (prefix.length() == 0 || prefix.equals(CURRENT_LOCAL_FOLDER)) {
            return suffix;
        }
        if (prefix.endsWith(SERVER_SEPARATOR)) {
            if (suffix.startsWith(SERVER_SEPARATOR)) {
                return String.valueOf(prefix) + suffix.substring(1);
            }
            return String.valueOf(prefix) + suffix;
        }
        if (suffix.startsWith(SERVER_SEPARATOR)) {
            return String.valueOf(prefix) + suffix;
        }
        return String.valueOf(prefix) + SERVER_SEPARATOR + suffix;
    }

    public static void logError(String message, Throwable throwable) {
        SVNProviderPlugin.log((IStatus)new Status(4, "org.tigris.subversion.subclipse.core", 4, message, throwable));
    }

    public static String getParentUrl(ISVNLocalResource svnResource) throws SVNException {
        ISVNLocalFolder parent = svnResource.getParent();
        while (parent != null) {
            String url = parent.getStatus().getUrlString();
            if (url != null) {
                return url;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static String flattenText(String string) {
        StringBuffer buffer = new StringBuffer(string.length() + 20);
        boolean skipAdjacentLineSeparator = true;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') {
                if (!skipAdjacentLineSeparator) {
                    buffer.append(SERVER_SEPARATOR);
                }
                skipAdjacentLineSeparator = true;
            } else {
                buffer.append(c);
                skipAdjacentLineSeparator = false;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String unescape(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception exception) {
            return s;
        }
    }

    public static void saveLocalHistory(IResource resource) throws CoreException {
        if (resource instanceof IFile && resource.exists()) {
            if (!resource.isSynchronized(0)) {
                resource.refreshLocal(0, null);
            }
            ((IFile)resource).appendContents((InputStream)new ByteArrayInputStream(new byte[0]), 2, null);
        }
    }

    public static boolean isSpecialEclipseFile(IResource resource) {
        return resource.getName().equals(".project") || resource.getName().equals(".classpath");
    }
}

