/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.cgi;

import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.swt.graphics.Color;
import org.epic.debug.cgi.CGIProxy;

public class CGIConsoleColorProvider
implements IConsoleColorProvider {
    private IProcess fProcess;
    private IConsole fConsole;

    public void connect(IProcess process, IConsole console) {
        this.fProcess = process;
        this.fConsole = console;
        console.connect(((CGIProxy)process).getErrorStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM");
        console.connect(((CGIProxy)process).getInputStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM");
        console.connect(((CGIProxy)process).getOutputStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM");
    }

    public void disconnect() {
        this.fConsole = null;
        this.fProcess = null;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Color getColor(String streamIdentifer) {
        if ("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM".equals(streamIdentifer)) {
            return DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.outColor");
        }
        if ("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM".equals(streamIdentifer)) {
            return DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.errorColor");
        }
        if ("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM".equals(streamIdentifer)) {
            return DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.inColor");
        }
        return null;
    }

    protected IProcess getProcess() {
        return this.fProcess;
    }

    protected IConsole getConsole() {
        return this.fConsole;
    }
}

